/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt.views;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.window.Window;
import org.eclipse.riena.ui.ridgets.controller.AbstractWindowController;
import org.eclipse.riena.ui.ridgets.swt.views.AbstractControlledView;
import org.eclipse.riena.ui.swt.GrabCorner;
import org.eclipse.riena.ui.swt.RienaWindowRenderer;
import org.eclipse.riena.ui.swt.lnf.LnFUpdater;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.SWTControlFinder;
import org.eclipse.riena.ui.swt.utils.UIControlsFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractDialogView
extends Dialog {
    private static final LnFUpdater LNF_UPDATER = LnFUpdater.getInstance();
    private final RienaWindowRenderer dlgRenderer = new RienaWindowRenderer((Window)this, this.isPaintTitlebar());
    private final ControlledView controlledView = new ControlledView();
    private String title = "";
    private boolean isClosing;

    private static Shell getShellByGuessing() {
        if (PlatformUI.isWorkbenchRunning()) {
            IWorkbenchWindow activeWorkbenchWindow;
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench != null && (activeWorkbenchWindow = workbench.getActiveWorkbenchWindow()) != null) {
                return activeWorkbenchWindow.getShell();
            }
        } else if (Display.getCurrent() != null) {
            return Display.getCurrent().getActiveShell();
        }
        return null;
    }

    protected AbstractDialogView(Shell parentShell) {
        super(parentShell != null ? parentShell : AbstractDialogView.getShellByGuessing());
        this.controlledView.setController(this.createController());
    }

    protected boolean isPaintTitlebar() {
        return true;
    }

    public void create() {
        this.setShellStyle(this.dlgRenderer.computeShellStyle());
        super.create();
        this.applyTitle(this.getShell());
        this.addUIControls((Composite)this.getShell());
        this.bindController();
        LNF_UPDATER.updateUIControls((Composite)this.getShell(), true);
        this.initializeBounds();
        this.centerWindow(this.getShell());
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!AbstractDialogView.this.isClosing) {
                    AbstractDialogView.this.close();
                } else {
                    AbstractWindowController controller = AbstractDialogView.this.getController();
                    controller.setReturnCode(1);
                    AbstractDialogView.this.setReturnCode(controller.getReturnCode());
                }
                AbstractDialogView.this.isClosing = false;
            }
        });
    }

    public boolean close() {
        AbstractWindowController controller = this.getController();
        this.isClosing = true;
        this.setReturnCode(controller.getReturnCode());
        this.controlledView.unbind(controller);
        return super.close();
    }

    public final AbstractWindowController getController() {
        return (AbstractWindowController)this.controlledView.getController();
    }

    public void setDefaultButton(Button defaultButton) {
        this.getShell().setDefaultButton(defaultButton);
    }

    public final void setTitle(String title) {
        Assert.isNotNull((Object)title);
        this.title = title;
    }

    @Deprecated
    public final void build() {
        this.open();
    }

    protected final void addUIControl(Object uiControl, String bindingId) {
        this.controlledView.addUIControl(uiControl, bindingId);
    }

    protected final Control createButtonBar(Composite parent) {
        return this.dlgRenderer.createButtonBar(parent);
    }

    protected final Control createContents(Composite parent) {
        Control result = this.dlgRenderer.createContents(parent);
        super.createContents(this.dlgRenderer.getCenterComposite());
        return result;
    }

    protected final Control createDialogArea(Composite parent) {
        Composite mainComposite = this.createMainComposite(parent);
        if (this.isResizable() && this.isHideOsBorder() && this.isPaintTitlebar()) {
            new GrabCorner(mainComposite, mainComposite.getStyle());
        }
        this.createContentComposite(mainComposite);
        return mainComposite;
    }

    protected void createOkCancelButtons(Composite parent) {
    }

    private Composite createMainComposite(Composite parent) {
        Composite mainComposite = UIControlsFactory.createComposite((Composite)parent, (int)parent.getStyle());
        mainComposite.setBackground(parent.getBackground());
        mainComposite.setLayout((Layout)new FormLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)mainComposite);
        return mainComposite;
    }

    private void createContentComposite(Composite parent) {
        Composite mainContentComposite = UIControlsFactory.createComposite((Composite)parent, (int)parent.getStyle());
        GridLayoutFactory.fillDefaults().applyTo(mainContentComposite);
        Composite contentComposite = UIControlsFactory.createComposite((Composite)mainContentComposite, (int)parent.getStyle());
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)contentComposite);
        GridLayoutFactory.fillDefaults().applyTo(contentComposite);
        this.buildView(contentComposite);
        this.addUIControl(this.getShell(), "windowRidget");
        FormData resultFormData = new FormData();
        resultFormData.top = new FormAttachment(0, 0);
        resultFormData.left = new FormAttachment(0, 0);
        resultFormData.right = new FormAttachment(100, 0);
        resultFormData.bottom = new FormAttachment(100, 0);
        mainContentComposite.setLayoutData((Object)resultFormData);
        this.createOkCancelButtons(mainContentComposite);
    }

    protected boolean isResizable() {
        return (this.getShellStyle() & 0x10) == 16;
    }

    private boolean isHideOsBorder() {
        return LnfManager.getLnf().getBooleanSetting("Dialog.hideOsBorder");
    }

    protected abstract Control buildView(Composite var1);

    protected abstract AbstractWindowController createController();

    private void applyTitle(Shell shell) {
        if (shell.getText().length() == 0) {
            shell.setText(this.title);
        }
    }

    private void addUIControls(Composite composite) {
        SWTControlFinder finder = new SWTControlFinder(composite){

            public void handleBoundControl(Control control, String bindingProperty) {
                AbstractDialogView.this.addUIControl(control, bindingProperty);
            }
        };
        finder.run();
    }

    private void bindController() {
        this.controlledView.initialize(this.getController());
        this.controlledView.bind(this.getController());
    }

    private void centerWindow(Shell dialogShell) {
        if (dialogShell != null && dialogShell.getParent() != null) {
            Rectangle parentShellBounds = dialogShell.getParent().getBounds();
            Rectangle dialogShellBounds = dialogShell.getBounds();
            int leftMargin = parentShellBounds.x + (parentShellBounds.width - dialogShellBounds.width) / 2;
            int topMargin = parentShellBounds.y + (parentShellBounds.height - dialogShellBounds.height) / 2;
            dialogShell.setLocation(leftMargin, topMargin);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ControlledView
    extends AbstractControlledView<AbstractWindowController> {
        private ControlledView() {
        }

        @Override
        protected void addUIControl(Object uiControl, String propertyName) {
            super.addUIControl(uiControl, propertyName);
        }

        @Override
        protected void setController(AbstractWindowController controller) {
            super.setController(controller);
        }
    }
}

