/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.annotation.processor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.riena.core.singleton.SingletonProvider;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.annotation.handler.IRidgetContainerAnnotationHandler;
import org.eclipse.riena.ui.ridgets.annotation.processor.AnnotatedOverriddenMethodsGuard;
import org.eclipse.riena.ui.ridgets.annotation.processor.IRidgetContainerAnnotationExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RidgetContainerAnnotationProcessor {
    private final Map<Class<? extends Annotation>, IRidgetContainerAnnotationHandler> handlerMap = new HashMap<Class<? extends Annotation>, IRidgetContainerAnnotationHandler>();
    private static final SingletonProvider<RidgetContainerAnnotationProcessor> RCAP = new SingletonProvider(RidgetContainerAnnotationProcessor.class);

    public static RidgetContainerAnnotationProcessor getInstance() {
        return (RidgetContainerAnnotationProcessor)RCAP.getInstance();
    }

    private RidgetContainerAnnotationProcessor() {
    }

    @InjectExtension
    public void update(IRidgetContainerAnnotationExtension[] extensions) {
        this.handlerMap.clear();
        IRidgetContainerAnnotationExtension[] iRidgetContainerAnnotationExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IRidgetContainerAnnotationExtension extension = iRidgetContainerAnnotationExtensionArray[n2];
            this.handlerMap.put(extension.getAnnotation(), extension.createHandler());
            ++n2;
        }
    }

    public void processAnnotations(IRidgetContainer ridgetContainer) {
        this.processAnnotations(ridgetContainer, ridgetContainer);
    }

    public void processAnnotations(IRidgetContainer ridgetContainer, Object target) {
        this.processAnnotations(ridgetContainer, target, target.getClass(), new AnnotatedOverriddenMethodsGuard());
    }

    private void processAnnotations(IRidgetContainer ridgetContainer, Object target, Class<?> targetClass, AnnotatedOverriddenMethodsGuard guard) {
        if (targetClass == Object.class) {
            return;
        }
        this.processAnnotations(ridgetContainer, target, targetClass.getSuperclass(), guard);
        Method[] methodArray = targetClass.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method targetMethod = methodArray[n2];
            Annotation[] annotationArray = targetMethod.getAnnotations();
            int n3 = annotationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation annotation = annotationArray[n4];
                this.handle(annotation, ridgetContainer, target, targetMethod, guard);
                ++n4;
            }
            ++n2;
        }
    }

    public void handle(Annotation annotation, IRidgetContainer ridgetContainer, Object target, Method targetMethod, AnnotatedOverriddenMethodsGuard guard) {
        IRidgetContainerAnnotationHandler handler = this.handlerMap.get(annotation.annotationType());
        if (handler != null && guard.add(annotation, targetMethod)) {
            handler.handleAnnotation(annotation, ridgetContainer, target, targetMethod, guard);
        }
    }
}

