/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.validation;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Locale;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.conversion.NumberToStringConverter;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.log.Logger;
import org.eclipse.osgi.util.NLS;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.util.ArraysUtil;
import org.eclipse.riena.core.util.PropertiesUtils;
import org.eclipse.riena.ui.ridgets.nls.Messages;
import org.eclipse.riena.ui.ridgets.validation.Utils;
import org.eclipse.riena.ui.ridgets.validation.ValidDecimal;
import org.eclipse.riena.ui.ridgets.validation.ValidationRuleStatus;

public class ValidRange
extends ValidDecimal
implements IExecutableExtension {
    private Number min;
    private Number max;
    private final IConverter converter;

    public ValidRange() {
        this(0, 0);
    }

    public ValidRange(Number min, Number max) {
        this(min, max, Locale.getDefault());
    }

    public ValidRange(Number min, Number max, Locale locale) {
        this(min, max, locale, null);
    }

    public ValidRange(Number min, Number max, IConverter converter) {
        this(min, max, Locale.getDefault(), converter);
    }

    public ValidRange(Number min, Number max, Locale locale, IConverter converter) {
        super(true, locale);
        Assert.isNotNull((Object)min, (String)"parameter min must not be null");
        Assert.isNotNull((Object)max, (String)"parameter max must not be null");
        Assert.isLegal((boolean)min.getClass().equals(max.getClass()), (String)("min and max must be of the same class. (min =  " + min.getClass().getName() + ", max = " + max.getClass().getName()));
        this.min = min;
        this.max = max;
        Assert.isLegal((this.toBigDecimal(this.min).compareTo(this.toBigDecimal(this.max)) <= 0 ? 1 : 0) != 0, (String)("min " + this.min + " must be smaller or equal max " + this.max));
        this.converter = converter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus validate(Object value) {
        String string;
        IStatus validDecimalStatus = super.validate(value);
        if (!validDecimalStatus.isOK()) {
            return validDecimalStatus;
        }
        Assert.isLegal((value == null || value instanceof String ? 1 : 0) != 0);
        BigDecimal currentValue = BigDecimal.ZERO;
        if (value != null && (string = Utils.removeWhitespace((String)value)).length() > 0) {
            DecimalFormat format;
            DecimalFormat decimalFormat = format = this.getFormat();
            synchronized (decimalFormat) {
                format.setParseBigDecimal(true);
                try {
                    currentValue = (BigDecimal)format.parse(string);
                }
                catch (ParseException pex) {
                    Logger logger = Log4r.getLogger(ValidRange.class);
                    String message = NLS.bind((String)Messages.ValidRange_error_cannotParse, (Object)string);
                    logger.log(1, message, (Throwable)pex);
                    return ValidationRuleStatus.error(true, message);
                }
            }
        }
        if (this.validateRange(currentValue)) {
            String message = NLS.bind((String)Messages.ValidRange_error_outOfRange, (Object[])new Object[]{this.convert(currentValue), this.convert(this.min), this.convert(this.max)});
            return ValidationRuleStatus.error(true, message);
        }
        return ValidationRuleStatus.ok();
    }

    private String convert(Number number) {
        if (this.converter == null) {
            return (String)NumberToStringConverter.fromBigDecimal().convert((Object)this.toBigDecimal(number));
        }
        return (String)this.converter.convert((Object)number);
    }

    protected boolean validateRange(BigDecimal value) {
        return value.compareTo(this.toBigDecimal(this.min, value)) < 0 || value.compareTo(this.toBigDecimal(this.max, value)) > 0;
    }

    protected BigDecimal toBigDecimal(Number number) {
        return this.toBigDecimal(number, 0);
    }

    protected BigDecimal toBigDecimal(Number number, BigDecimal value) {
        return this.toBigDecimal(number, value.precision());
    }

    protected BigDecimal toBigDecimal(Number number, int precision) {
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof BigInteger) {
            return new BigDecimal((BigInteger)number);
        }
        if (number instanceof Float || number instanceof Double) {
            return new BigDecimal(number.doubleValue(), new MathContext(precision));
        }
        return new BigDecimal(number.longValue());
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            Object[] args = PropertiesUtils.asArray((Object)data);
            if (args.length > 0) {
                this.min = new BigDecimal(args[0]);
            }
            if (args.length > 1) {
                this.max = new BigDecimal(args[1]);
            }
            if (args.length > 2) {
                String[] localArgs = (String[])ArraysUtil.copyRange((Object[])args, (int)2, (int)args.length);
                this.setLocale(localArgs);
            }
        }
    }
}

