/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.swt.utils;

import org.eclipse.equinox.log.Logger;
import org.eclipse.jface.util.Util;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.internal.ui.swt.utils.RcpUtilities;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;

public class ShellHelper {
    private static final Logger LOGGER = Log4r.getLogger(ShellHelper.class);
    private Rectangle restoreBounds;

    public void maximizeRestore() {
        Shell shell = RcpUtilities.getWorkbenchShell();
        if (shell == null) {
            LOGGER.log(2, "No shell of the application found! Maximize/restore of shell canceled.");
            return;
        }
        if (ShellHelper.isShellTitleless()) {
            if (ShellHelper.isShellMaximzed()) {
                if (this.restoreBounds != null) {
                    shell.setBounds(this.restoreBounds);
                } else {
                    LOGGER.log(2, "No restore bounds exists! Restore of shell canceled.");
                }
            } else {
                this.restoreBounds = shell.getBounds();
                Rectangle clientBounds = ShellHelper.calcMaxBounds(shell);
                shell.setBounds(clientBounds);
            }
        } else {
            shell.setMaximized(shell.getMaximized());
        }
    }

    public static Rectangle calcMaxBounds(Shell shell) {
        Rectangle clientBounds = shell.getMonitor().getClientArea();
        Rectangle newBounds = new Rectangle(clientBounds.x, clientBounds.y, clientBounds.width, clientBounds.height);
        if (ShellHelper.isTaskbarHidden()) {
            ++newBounds.x;
            ++newBounds.y;
            newBounds.width -= 2;
            newBounds.height -= 2;
        }
        return newBounds;
    }

    private static boolean isTaskbarHidden() {
        if (!Util.isWindows()) {
            return false;
        }
        Shell shell = RcpUtilities.getWorkbenchShell();
        if (shell == null) {
            LOGGER.log(2, "No shell of the application found!");
            return false;
        }
        Rectangle clientBounds = shell.getMonitor().getClientArea();
        Rectangle monitorBounds = shell.getMonitor().getBounds();
        return clientBounds.equals((Object)monitorBounds);
    }

    public static boolean isShellMaximzed() {
        Shell shell = RcpUtilities.getWorkbenchShell();
        if (shell == null) {
            LOGGER.log(2, "No shell of the application found!");
            return false;
        }
        return ShellHelper.isMaximzed(shell);
    }

    private static boolean isMaximzed(Shell shell) {
        if (shell == null || shell.isDisposed()) {
            LOGGER.log(2, "shell equals null or is disposed!");
            return false;
        }
        if (ShellHelper.isShellTitleless()) {
            Rectangle clientBounds = shell.getMonitor().getClientArea();
            if (clientBounds.equals((Object)shell.getBounds())) {
                return true;
            }
            clientBounds = ShellHelper.calcMaxBounds(shell);
            return clientBounds.equals((Object)shell.getBounds());
        }
        return shell.getMaximized();
    }

    private static boolean isTitleless(Shell shell) {
        if (shell == null || shell.isDisposed()) {
            LOGGER.log(2, "shell equals null or is disposed!");
            return false;
        }
        int style = shell.getStyle();
        return (style & 8) == 8;
    }

    private static boolean isShellTitleless() {
        Shell shell = RcpUtilities.getWorkbenchShell();
        if (shell == null) {
            LOGGER.log(2, "No shell of the application found!");
            return false;
        }
        return ShellHelper.isTitleless(shell);
    }
}

