/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.uiprocess;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.exception.IExceptionHandlerManager;
import org.eclipse.riena.core.service.Service;
import org.eclipse.riena.internal.ui.swt.Activator;
import org.eclipse.riena.ui.core.uiprocess.IUISynchronizer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwtUISynchronizer
implements IUISynchronizer {
    private static List<FutureSyncLatch> syncJobs = Collections.synchronizedList(new ArrayList());
    private static List<Runnable> asyncJobs = Collections.synchronizedList(new ArrayList());
    private static Thread displayObserver;
    private static AtomicBoolean workbenchShutdown;
    private final Display display = Display.getCurrent();

    static {
        workbenchShutdown = new AtomicBoolean(false);
    }

    public void syncExec(Runnable runnable) {
        this.execute(new SyncExecutor(), runnable);
    }

    public void asyncExec(Runnable runnable) {
        this.execute(new ASyncExecutor(), runnable);
    }

    private void execute(Executor executor, Runnable runnable) {
        Display currentDisplay;
        if (SwtUISynchronizer.isWorkbenchShutdown()) {
            return;
        }
        if (!this.hasDisplay()) {
            this.waitForDisplay(15000);
        }
        if (this.executeOnDisplay(executor, runnable, currentDisplay = this.getDisplay())) {
            return;
        }
        if (currentDisplay == null || this.getDisplay().isDisposed()) {
            if (this.isSyncExecutor(executor)) {
                this.waitForDisplayInitialisation(runnable);
            } else {
                this.queueRunnable(executor, runnable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startObserver() {
        Class<SwtUISynchronizer> clazz = SwtUISynchronizer.class;
        synchronized (SwtUISynchronizer.class) {
            if (displayObserver == null) {
                displayObserver = new DisplayObserver();
                displayObserver.start();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueRunnable(Executor executor, Runnable runnable) {
        Class<SwtUISynchronizer> clazz = SwtUISynchronizer.class;
        synchronized (SwtUISynchronizer.class) {
            asyncJobs.add(runnable);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.startObserver();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForDisplayInitialisation(Runnable job) {
        FutureSyncLatch latch = new FutureSyncLatch(1, job);
        Class<SwtUISynchronizer> clazz = SwtUISynchronizer.class;
        synchronized (SwtUISynchronizer.class) {
            syncJobs.add(latch);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.startObserver();
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                this.getLogger().log(1, e.getMessage());
            }
            return;
        }
    }

    private boolean isSyncExecutor(Executor executor) {
        return executor instanceof SyncExecutor;
    }

    private boolean executeOnDisplay(Executor executor, Runnable runnable, Display display) {
        if (display != null && !display.isDisposed()) {
            executor.execute(display, runnable);
            return true;
        }
        return false;
    }

    public Display getDisplay() {
        if (this.display != null) {
            return this.display;
        }
        return PlatformUI.getWorkbench().getDisplay();
    }

    private Logger getLogger() {
        return Log4r.getLogger((IRienaActivator)Activator.getDefault(), SwtUISynchronizer.class);
    }

    protected boolean hasDisplay() {
        return this.display != null || PlatformUI.isWorkbenchRunning() && PlatformUI.getWorkbench().getDisplay() != null;
    }

    private void waitForDisplay(int timeoutMs) {
        Assert.isTrue((timeoutMs >= 0 ? 1 : 0) != 0);
        int time = 0;
        do {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        } while ((time += 500) < timeoutMs && !this.hasDisplay());
    }

    public static boolean isWorkbenchShutdown() {
        return workbenchShutdown.get();
    }

    public static void setWorkbenchShutdown(boolean workbenchShutdown) {
        SwtUISynchronizer.workbenchShutdown.set(workbenchShutdown);
    }

    public void readAndDispatch(Callable<Boolean> condition) {
        Assert.isNotNull(condition);
        Display currentDisplay = Display.getCurrent();
        try {
            while (!condition.call().booleanValue()) {
                if (currentDisplay.readAndDispatch()) continue;
                currentDisplay.sleep();
            }
        }
        catch (Exception e) {
            ((IExceptionHandlerManager)Service.get(IExceptionHandlerManager.class)).handleException((Throwable)e);
        }
    }

    private static class ASyncExecutor
    implements Executor {
        private ASyncExecutor() {
        }

        public void execute(Display display, Runnable runnable) {
            display.asyncExec(runnable);
        }
    }

    private class DisplayObserver
    extends Thread {
        private DisplayObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (PlatformUI.isWorkbenchRunning() && SwtUISynchronizer.this.getDisplay() == null || SwtUISynchronizer.this.getDisplay() != null && SwtUISynchronizer.this.getDisplay().isDisposed()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    SwtUISynchronizer.this.getLogger().log(1, e.getMessage());
                }
            }
            Class<SwtUISynchronizer> clazz = SwtUISynchronizer.class;
            synchronized (SwtUISynchronizer.class) {
                Iterator syncIter = syncJobs.iterator();
                while (syncIter.hasNext()) {
                    FutureSyncLatch futureSyncLatch = (FutureSyncLatch)syncIter.next();
                    futureSyncLatch.countDown();
                    syncIter.remove();
                }
                if (SwtUISynchronizer.this.getDisplay() == null) {
                    // ** MonitorExit[var1_2] (shouldn't be in output)
                    return;
                }
                Iterator asyncIter = asyncJobs.iterator();
                while (asyncIter.hasNext()) {
                    Runnable next = (Runnable)asyncIter.next();
                    if (!SwtUISynchronizer.isWorkbenchShutdown()) {
                        new ASyncExecutor().execute(SwtUISynchronizer.this.getDisplay(), next);
                    }
                    asyncIter.remove();
                }
                displayObserver = null;
                // ** MonitorExit[var1_2] (shouldn't be in output)
                return;
            }
        }
    }

    private static interface Executor {
        public void execute(Display var1, Runnable var2);
    }

    private class FutureSyncLatch
    extends CountDownLatch {
        private final Runnable job;

        public FutureSyncLatch(int count, Runnable job) {
            super(count);
            this.job = job;
        }

        public void await() throws InterruptedException {
            super.await();
            if (!SwtUISynchronizer.isWorkbenchShutdown()) {
                new SyncExecutor().execute(SwtUISynchronizer.this.getDisplay(), this.job);
            }
        }
    }

    private static class SyncExecutor
    implements Executor {
        private SyncExecutor() {
        }

        public void execute(Display display, Runnable runnable) {
            display.syncExec(runnable);
        }
    }
}

