/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.nebula.widgets.compositetable.internal;

import org.eclipse.swt.nebula.widgets.compositetable.internal.ReflectedMethod;

public class ReflectedProperty {
    private String propertyName;
    private ReflectedMethod getter;
    private ReflectedMethod setter;

    public ReflectedProperty(Object object, String propertyName) {
        this.propertyName = propertyName;
        this.getter = new ReflectedMethod(object, this.makeGetterName(propertyName), new Class[0]);
        if (!this.getter.exists()) {
            this.getter = new ReflectedMethod(object, this.makeBooleanGetterName(propertyName), new Class[0]);
            if (!this.getter.exists()) {
                throw new IllegalArgumentException("Cannot find getter for " + propertyName);
            }
        }
        this.setter = new ReflectedMethod(object, this.makeSetterName(propertyName), new Class[]{this.getter.getType()});
    }

    private String makeBooleanGetterName(String propertyName) {
        return "is" + this.capitalize(propertyName);
    }

    private String makeSetterName(String propertyName) {
        return "set" + this.capitalize(propertyName);
    }

    private String makeGetterName(String propertyName) {
        return "get" + this.capitalize(propertyName);
    }

    private String capitalize(String string) {
        return String.valueOf(string.substring(0, 1).toUpperCase()) + string.substring(1);
    }

    public Class getType() {
        return this.getter.getType();
    }

    public Object get() {
        return this.getter.invoke(new Object[0]);
    }

    public void set(Object newValue) {
        this.setter.invoke(new Object[]{newValue});
    }

    public boolean isReadOnly() {
        return !this.setter.exists();
    }

    public String getPropertyName() {
        return this.propertyName;
    }
}

