/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.navigation.ui.swt.handlers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.riena.navigation.ApplicationNodeManager;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.model.NavigationModelFailure;
import org.eclipse.ui.AbstractSourceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationSourceProvider
extends AbstractSourceProvider {
    private boolean isDisposed;
    private static final String ACTIVE_SUB_APPLICATION_NODE = "activeSubApplicationNode";
    private static final String ACTIVE_SUB_APPLICATION_NODE_ID = "activeSubApplicationNodeId";
    private static final String ACTIVE_MODULE_GROUP_NODE = "activeModuleGroupNode";
    private static final String ACTIVE_MODULE_GROUP_NODE_ID = "activeModuleGroupNodeId";
    private static final String ACTIVE_MODULE_NODE = "activeModuleNode";
    private static final String ACTIVE_MODULE_NODE_ID = "activeModuleNodeId";
    private static final String ACTIVE_SUB_MODULE_NODE = "activeSubModuleNode";
    private static final String ACTIVE_SUB_MODULE_NODE_ID = "activeSubModuleNodeId";
    private static final int EVENT_PRIORITY = 0x10000000;
    private static final String[] PROVIDED_SOURCE_NAMES = new String[]{"activeSubApplicationNodeId", "activeModuleGroupNodeId", "activeModuleNodeId", "activeSubModuleNodeId", "activeModuleNode"};

    public void dispose() {
        this.isDisposed = true;
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public final Map<String, Object> getCurrentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        ISubApplicationNode subAppNode = ApplicationNodeManager.locateActiveSubApplicationNode();
        IModuleGroupNode moduleGroupNode = ApplicationNodeManager.locateActiveModuleGroupNode();
        IModuleNode moduleNode = ApplicationNodeManager.locateActiveModuleNode();
        ISubModuleNode subModuleNode = ApplicationNodeManager.locateActiveSubModuleNode();
        state.put(ACTIVE_SUB_APPLICATION_NODE_ID, this.getTypeNodeId((INavigationNode<?>)subAppNode));
        state.put(ACTIVE_MODULE_GROUP_NODE_ID, this.getTypeNodeId((INavigationNode<?>)moduleGroupNode));
        state.put(ACTIVE_MODULE_NODE_ID, this.getTypeNodeId((INavigationNode<?>)moduleNode));
        state.put(ACTIVE_SUB_MODULE_NODE_ID, this.getTypeNodeId((INavigationNode<?>)subModuleNode));
        state.put(ACTIVE_SUB_APPLICATION_NODE, subAppNode);
        state.put(ACTIVE_MODULE_GROUP_NODE, moduleGroupNode);
        state.put(ACTIVE_MODULE_NODE, moduleNode);
        state.put(ACTIVE_SUB_MODULE_NODE, subModuleNode);
        return state;
    }

    public String[] getProvidedSourceNames() {
        return PROVIDED_SOURCE_NAMES;
    }

    void fireSourceChange(INavigationNode<?> node) {
        String variable = this.getVariableNameForNode(node);
        this.fireSourceChanged(0x10000000, String.valueOf(variable) + "Id", this.getTypeNodeId(node));
        this.fireSourceChanged(0x10000000, variable, node);
    }

    private String getTypeNodeId(INavigationNode<?> node) {
        if (node != null && node.getNodeId() != null) {
            return node.getNodeId().getTypeId();
        }
        return "";
    }

    private String getVariableNameForNode(INavigationNode<?> node) {
        if (node == null) {
            return null;
        }
        if (node instanceof ISubApplicationNode) {
            return ACTIVE_SUB_APPLICATION_NODE;
        }
        if (node instanceof IModuleGroupNode) {
            return ACTIVE_MODULE_GROUP_NODE;
        }
        if (node instanceof IModuleNode) {
            return ACTIVE_MODULE_NODE;
        }
        if (node instanceof ISubModuleNode) {
            return ACTIVE_SUB_MODULE_NODE;
        }
        throw new NavigationModelFailure("Unsupported instance of INavigationNode: " + node);
    }

    @Deprecated
    public String getPovidesSourceName(INavigationNode<?> node) {
        if (node == null) {
            return null;
        }
        if (node instanceof ISubApplicationNode) {
            return ACTIVE_SUB_APPLICATION_NODE_ID;
        }
        if (node instanceof IModuleGroupNode) {
            return ACTIVE_MODULE_GROUP_NODE_ID;
        }
        if (node instanceof IModuleNode) {
            return ACTIVE_MODULE_NODE_ID;
        }
        if (node instanceof ISubModuleNode) {
            return ACTIVE_SUB_MODULE_NODE_ID;
        }
        throw new NavigationModelFailure("Unsupported instance of INavigationNode: " + node);
    }

    public void activeNodeChanged(INavigationNode<?> node) {
        this.fireSourceChange(node);
        if (node.getParent() != null && !(node.getParent() instanceof IApplicationNode)) {
            this.activeNodeChanged(node.getParent());
        }
    }
}

