/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.application;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.exception.ExceptionFailure;
import org.eclipse.riena.core.util.ReflectionFailure;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.internal.navigation.ui.swt.Activator;
import org.eclipse.riena.internal.navigation.ui.swt.IAdvisorHelper;
import org.eclipse.riena.internal.ui.swt.utils.RcpUtilities;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.listener.ApplicationNodeListener;
import org.eclipse.riena.navigation.listener.INavigationNodeListener;
import org.eclipse.riena.navigation.ui.application.AbstractApplication;
import org.eclipse.riena.navigation.ui.controllers.ApplicationController;
import org.eclipse.riena.navigation.ui.login.ILoginDialogView;
import org.eclipse.riena.navigation.ui.swt.login.ILoginSplashViewExtension;
import org.eclipse.riena.navigation.ui.swt.splashHandlers.AbstractLoginSplashHandler;
import org.eclipse.riena.navigation.ui.swt.views.ApplicationAdvisor;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.riena.ui.swt.utils.ImageStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.internal.Workbench;

public class SwtApplication
extends AbstractApplication {
    protected ILoginSplashViewExtension loginSplashViewExtension;
    private LoginNonActivityTimer loginNonActivityTimer;

    protected void initializeUI() {
        PlatformUI.createDisplay();
    }

    public Object createView(IApplicationContext context, IApplicationNode pNode) {
        Display display = Display.getCurrent();
        try {
            ApplicationAdvisor advisor = new ApplicationAdvisor(this.createApplicationController(pNode), new AdvisorHelper());
            this.initializeLoginNonActivityTimer(display, pNode, context);
            int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)advisor);
            if (returnCode == 1) {
                Integer n = IApplication.EXIT_RESTART;
                return n;
            }
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        finally {
            display.dispose();
        }
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new ActionBarAdvisor(configurer);
    }

    protected String getKeyScheme() {
        return "org.eclipse.riena.ui.defaultBindings";
    }

    public void stop() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        final Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                if (!display.isDisposed()) {
                    workbench.close();
                }
            }
        });
    }

    @InjectExtension
    public void update(ILoginSplashViewExtension[] data) {
        if (data.length > 0) {
            this.loginSplashViewExtension = data[0];
        }
    }

    protected ApplicationController createApplicationController(IApplicationNode pModel) {
        return new ApplicationController(pModel);
    }

    protected void prePerformLogin(IApplicationContext context) {
        if (RcpUtilities.getWorkbenchShell() != null) {
            RcpUtilities.getWorkbenchShell().setVisible(false);
            RcpUtilities.getWorkbenchShell().setMinimized(true);
            RcpUtilities.getWorkbenchShell().setVisible(true);
        }
    }

    protected void postPerformLogin(IApplicationContext context, Object result) {
        if (!EXIT_OK.equals(result)) {
            PlatformUI.getWorkbench().close();
        } else {
            RcpUtilities.getWorkbenchShell().setMinimized(false);
            this.loginNonActivityTimer.schedule();
        }
    }

    protected Object doPerformLogin(IApplicationContext context) {
        Realm realm = SWTObservables.getRealm((Display)this.getDisplay());
        final ILoginDialogView loginDialogView = this.loginDialogViewExtension.createViewClass();
        do {
            Realm.runWithDefault((Realm)realm, (Runnable)new Runnable(){

                public void run() {
                    loginDialogView.build();
                }
            });
        } while (EXIT_RESTART.equals(loginDialogView.getResult()));
        return loginDialogView.getResult();
    }

    protected Object doPerformSplashLogin(IApplicationContext context) {
        Shell shell = new Shell(this.getDisplay(), 65544);
        this.initilizeShellBackgroundImage(shell, this.getBackgroundImagePath(context));
        AbstractLoginSplashHandler loginSplashHandler = this.getLoginSplashHandler();
        loginSplashHandler.init(shell);
        shell.open();
        while (!shell.isDisposed()) {
            if (this.getDisplay().readAndDispatch()) continue;
            this.getDisplay().sleep();
        }
        return loginSplashHandler.getResult();
    }

    protected boolean isSplashLogin(IApplicationContext context) {
        return this.loginSplashViewExtension != null && this.getLoginSplashHandler() != null;
    }

    protected boolean isDialogLogin(IApplicationContext context) {
        return super.isDialogLogin(context) && this.loginSplashViewExtension == null;
    }

    protected void initializeLoginViewDefinition() {
        super.initializeLoginViewDefinition();
        this.initializeLoginSplashViewDefinition();
    }

    private String getBackgroundImagePath(IApplicationContext context) {
        return "splash.bmp";
    }

    private Display getDisplay() {
        if (PlatformUI.isWorkbenchRunning()) {
            return PlatformUI.getWorkbench().getDisplay();
        }
        return PlatformUI.createDisplay();
    }

    private AbstractLoginSplashHandler getLoginSplashHandler() {
        AbstractLoginSplashHandler result = null;
        if (PlatformUI.isWorkbenchRunning() && !SWTFacade.isRAP()) {
            try {
                Object loginSplashHandler = ReflectionUtils.invokeHidden(Workbench.class, (String)"getSplash", (Object[])new Object[0]);
                if (loginSplashHandler instanceof AbstractLoginSplashHandler) {
                    result = (AbstractLoginSplashHandler)((Object)loginSplashHandler);
                }
            }
            catch (ReflectionFailure refFail) {
                Log4r.getLogger(SwtApplication.class).log(1, "Workbench.getSplash()", (Throwable)refFail);
            }
        }
        return result;
    }

    private void initializeLoginNonActivityTimer(final Display display, IApplicationNode pNode, final IApplicationContext context) {
        pNode.addListener((INavigationNodeListener)new ApplicationNodeListener(){

            public void afterActivated(IApplicationNode source) {
                if (SwtApplication.this.isSplashLogin(context) && SwtApplication.this.loginSplashViewExtension.getNonActivityDuration() > 0) {
                    SwtApplication.this.loginNonActivityTimer = new LoginNonActivityTimer(display, context, SwtApplication.this.loginSplashViewExtension.getNonActivityDuration());
                    SwtApplication.this.loginNonActivityTimer.schedule();
                } else if (SwtApplication.this.isDialogLogin(context) && SwtApplication.this.loginDialogViewExtension.getNonActivityDuration() > 0) {
                    SwtApplication.this.loginNonActivityTimer = new LoginNonActivityTimer(display, context, SwtApplication.this.loginDialogViewExtension.getNonActivityDuration());
                    SwtApplication.this.loginNonActivityTimer.schedule();
                }
            }
        });
    }

    private void initializeLoginSplashViewDefinition() {
        Wire.instance((Object)((Object)this)).andStart(Activator.getDefault().getContext());
    }

    private void initilizeShellBackgroundImage(Shell shell, String imageName) {
        Image bi = ImageStore.getInstance().getImage(imageName);
        shell.setSize(bi.getBounds().width, bi.getBounds().height);
        shell.setBackgroundImage(bi);
    }

    private final class AdvisorHelper
    implements IAdvisorHelper {
        private AdvisorHelper() {
        }

        public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
            return SwtApplication.this.createActionBarAdvisor(configurer);
        }

        public String getKeyScheme() {
            return SwtApplication.this.getKeyScheme();
        }
    }

    private static final class EventListener
    implements Listener {
        private boolean activity = false;
        private long activityTime = -1L;

        private EventListener() {
        }

        public void handleEvent(Event event) {
            this.activity = true;
            this.activityTime = System.currentTimeMillis();
        }
    }

    private final class LoginNonActivityTimer
    implements Runnable {
        private final Display display;
        private final IApplicationContext context;
        private EventListener eventListener;
        private final int nonActivityDuration;

        private LoginNonActivityTimer(Display display, IApplicationContext context, int nonActivityDuration) {
            this.display = display;
            this.context = context;
            this.nonActivityDuration = nonActivityDuration;
            this.initializeEventListener();
        }

        public void run() {
            try {
                if (this.eventListener.activity) {
                    this.schedule();
                    return;
                }
                SwtApplication.this.prePerformLogin(this.context);
                SwtApplication.this.postPerformLogin(this.context, SwtApplication.this.performLogin(this.context));
            }
            catch (Exception e) {
                throw new ExceptionFailure(e.getLocalizedMessage(), (Throwable)e);
            }
        }

        private void initializeEventListener() {
            this.eventListener = new EventListener();
            this.display.addFilter(1, (Listener)this.eventListener);
            this.display.addFilter(2, (Listener)this.eventListener);
            this.display.addFilter(8, (Listener)this.eventListener);
            this.display.addFilter(3, (Listener)this.eventListener);
            this.display.addFilter(4, (Listener)this.eventListener);
            this.display.addFilter(31, (Listener)this.eventListener);
            SWTFacade facade = SWTFacade.getDefault();
            facade.addFilterMouseExit(this.display, (Listener)this.eventListener);
            facade.addFilterMouseMove(this.display, (Listener)this.eventListener);
            facade.addFilterMouseWheel(this.display, (Listener)this.eventListener);
        }

        private void schedule() {
            this.initializeForSchedule();
            this.display.timerExec(this.getTimerDelay(), (Runnable)this);
        }

        private void initializeForSchedule() {
            if (this.eventListener.activityTime == -1L) {
                this.eventListener.activityTime = System.currentTimeMillis();
            }
            this.eventListener.activity = false;
        }

        private int getTimerDelay() {
            return this.nonActivityDuration - (int)(System.currentTimeMillis() - this.eventListener.activityTime);
        }
    }
}

