/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.riena.internal.navigation.ui.swt.CoolbarUtils;
import org.eclipse.riena.ui.ridgets.swt.MenuManagerHelper;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuCoolBarComposite
extends Composite {
    private final IWorkbenchWindow window;
    private CoolItem menuCoolItem;
    private ToolBar menuToolBar;
    private CoolBar menuCoolBar;
    private final Map<MenuManager, Boolean> menuManagerToVisibility;
    private final Map<MenuManager, Integer> menuManagerToChildCount;

    public MenuCoolBarComposite(Composite parent, int style, IWorkbenchWindow window) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.window = window;
        this.menuManagerToVisibility = new HashMap<MenuManager, Boolean>();
        this.menuManagerToChildCount = new HashMap<MenuManager, Integer>();
        this.create();
    }

    public List<ToolItem> getTopLevelItems() {
        ToolItem[] toolItems = this.menuToolBar.getItems();
        return Arrays.asList(toolItems);
    }

    private void calcSize(CoolItem item) {
        Control control = item.getControl();
        Point pt = control.computeSize(-1, -1);
        pt = item.computeSize(pt.x, pt.y);
        item.setSize(pt);
    }

    private ToolItem createAndAddMenu(MenuManager menuManager) {
        if (menuManager.isVisible()) {
            ToolItem toolItem = new ToolItem(this.menuToolBar, 32);
            toolItem.setText(menuManager.getMenuText());
            MenuManagerHelper helper = new MenuManagerHelper();
            helper.createMenu((Composite)this.menuToolBar, toolItem, menuManager);
            this.calcSize(this.menuCoolItem);
            return toolItem;
        }
        return null;
    }

    private void create() {
        this.menuCoolBar = new CoolBar((Composite)this, 0x800000);
        this.menuCoolItem = CoolbarUtils.initCoolBar(this.menuCoolBar, this.getMenuBarFont());
        this.menuToolBar = (ToolBar)this.menuCoolItem.getControl();
        SWTFacade.getDefault().addMouseMoveListener((Control)this.menuToolBar, (MouseMoveListener)new ToolBarMouseListener());
        this.fillMenuBar();
    }

    private void fillMenuBar() {
        IContributionItem[] iContributionItemArray = this.getTopLevelMenuEntries();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem contribItem = iContributionItemArray[n2];
            if (contribItem instanceof MenuManager) {
                MenuManager topMenuManager = (MenuManager)contribItem;
                this.menuManagerToVisibility.put(topMenuManager, topMenuManager.isVisible());
                if (topMenuManager.getMenu() != null) {
                    this.menuManagerToChildCount.put(topMenuManager, topMenuManager.getMenu().getItemCount());
                }
                this.createAndAddMenu(topMenuManager);
            }
            ++n2;
        }
    }

    private Font getMenuBarFont() {
        return LnfManager.getLnf().getFont("Menubar.font");
    }

    private IContributionItem[] getTopLevelMenuEntries() {
        if (this.window instanceof WorkbenchWindow) {
            MenuManager menuManager = ((WorkbenchWindow)this.window).getMenuManager();
            return menuManager.getItems();
        }
        return new IContributionItem[0];
    }

    public List<ToolItem> updateMenuItems() {
        List<MenuManager> changedTopMenuManager = this.getChangedVisibilityItems();
        ArrayList<ToolItem> changedMenus = new ArrayList<ToolItem>();
        if (!changedTopMenuManager.isEmpty()) {
            if (this.menuCoolBar != null) {
                this.menuCoolBar.dispose();
            }
            this.create();
            this.layout();
            for (ToolItem contribItem : this.getTopLevelItems()) {
                for (MenuManager manager : changedTopMenuManager) {
                    if (!manager.getMenuText().equals(contribItem.getText())) continue;
                    changedMenus.add(contribItem);
                }
            }
        }
        return changedMenus;
    }

    private List<MenuManager> getChangedVisibilityItems() {
        ArrayList<MenuManager> changedItems = new ArrayList<MenuManager>();
        IContributionItem[] iContributionItemArray = this.getTopLevelMenuEntries();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem contribItem = iContributionItemArray[n2];
            if (contribItem instanceof MenuManager) {
                MenuManager topMenuManager = (MenuManager)contribItem;
                topMenuManager.updateAll(true);
                Boolean isVisible = this.menuManagerToVisibility.get(topMenuManager);
                Integer childCount = this.menuManagerToChildCount.get(topMenuManager);
                if (childCount == null || this.isTopMenuVisibilityChanged(topMenuManager, isVisible) || this.isMenuItemVisibilityChanged(topMenuManager, childCount)) {
                    changedItems.add(topMenuManager);
                }
            }
            ++n2;
        }
        return changedItems;
    }

    private boolean isMenuItemVisibilityChanged(MenuManager topMenuManager, int childCount) {
        return topMenuManager.getMenu() == null || childCount != topMenuManager.getMenu().getItemCount();
    }

    private boolean isTopMenuVisibilityChanged(MenuManager topMenuManager, Boolean wasVisible) {
        return wasVisible == null || !wasVisible.equals(topMenuManager.isVisible());
    }

    private static final class ToolBarMouseListener
    implements MouseMoveListener {
        private ToolBarMouseListener() {
        }

        public void mouseMove(MouseEvent e) {
            if (e.getSource() instanceof ToolBar) {
                ToolItem[] items;
                ToolBar toolBar = (ToolBar)e.getSource();
                ToolItem selectedItem = null;
                ToolItem[] toolItemArray = items = toolBar.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    ToolItem item = toolItemArray[n2];
                    if (item.getSelection()) {
                        selectedItem = item;
                    }
                    ++n2;
                }
                ToolItem hoverItem = toolBar.getItem(new Point(e.x, e.y));
                if (hoverItem != null && !hoverItem.getSelection() && selectedItem != null) {
                    selectedItem.setSelection(false);
                    hoverItem.setSelection(true);
                }
            }
        }
    }
}

