/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.util.List;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.swt.views.IModuleNavigationComponentProvider;
import org.eclipse.riena.navigation.ui.swt.views.ModuleView;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScrollingSupport {
    protected static final int SCROLLING_STEP = 20;
    protected final IModuleNavigationComponentProvider navigationComponentProvider;

    public AbstractScrollingSupport(IModuleNavigationComponentProvider navigationComponentProvider) {
        this.navigationComponentProvider = navigationComponentProvider;
        this.initMouseWheelObserver(this.getNavigationComponent());
    }

    public abstract void scroll();

    protected abstract boolean scrollTo(Composite var1, Composite var2);

    protected abstract boolean scrollTo(Tree var1);

    protected abstract void scrollUp(int var1);

    protected abstract void scrollDown(int var1);

    protected boolean scrollTo(IModuleNode module) {
        boolean result = false;
        if (module != null) {
            boolean isClosed;
            ModuleView moduleView = this.navigationComponentProvider.getModuleViewForNode(module);
            if (moduleView == null) {
                return result;
            }
            boolean bl = isClosed = moduleView.getOpenHeight() == 0;
            if (isClosed) {
                result = this.scrollTo((Composite)moduleView.getTitle(), moduleView.getBody());
            } else {
                int moduleHeight = moduleView.getParent().getSize().y;
                if (moduleHeight < this.getNavigationComponentHeight()) {
                    result = this.scrollTo((Composite)moduleView.getTitle(), moduleView.getBody());
                }
                result = result || this.scrollTo(moduleView.getTree());
            }
        }
        return result;
    }

    protected INavigationNode<?> getActiveNode() {
        IModuleGroupNode group = this.navigationComponentProvider.getActiveModuleGroupNode();
        IModuleNode module = null;
        ISubModuleNode submodule = null;
        if (group != null) {
            for (IModuleNode candidate : group.getChildren()) {
                if (!candidate.isActivated()) continue;
                module = candidate;
                break;
            }
        }
        if (module != null) {
            submodule = this.getActiveSubModuleNode(module.getChildren());
        }
        return submodule != null ? submodule : (module != null ? module : group);
    }

    protected ISubModuleNode getActiveSubModuleNode(List<ISubModuleNode> nodes) {
        ISubModuleNode result = null;
        for (ISubModuleNode candidate : nodes) {
            if (!candidate.isActivated()) continue;
            ISubModuleNode activeChild = this.getActiveSubModuleNode(candidate.getChildren());
            result = activeChild != null ? activeChild : candidate;
            break;
        }
        return result;
    }

    protected int getScrolledComponentHeight() {
        return this.getScrolledComponent().getBounds().height;
    }

    protected Composite getScrolledComponent() {
        return this.navigationComponentProvider.getScrolledComponent();
    }

    protected int getNavigationComponentHeight() {
        return this.getNavigationComponent().getBounds().height;
    }

    protected Composite getNavigationComponent() {
        return this.navigationComponentProvider.getNavigationComponent();
    }

    protected boolean mayScroll() {
        int navigationComponentHeight = this.getNavigationComponentHeight();
        return this.getScrolledComponentHeight() > navigationComponentHeight && navigationComponentHeight > 0;
    }

    private void initMouseWheelObserver(Composite navigationComponent) {
        if (SwtUtilities.isDisposed((Widget)navigationComponent)) {
            return;
        }
        final Display display = navigationComponent.getDisplay();
        final MouseWheelAdapter wheelAdapter = new MouseWheelAdapter();
        SWTFacade.getDefault().addFilterMouseWheel(display, (Listener)wheelAdapter);
        navigationComponent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SWTFacade.getDefault().removeFilterMouseWheel(display, (Listener)wheelAdapter);
            }
        });
    }

    private final class MouseWheelAdapter
    implements Listener {
        private int lastEventTime = 0;

        private MouseWheelAdapter() {
        }

        public void handleEvent(Event event) {
            if (AbstractScrollingSupport.this.mayScroll() && this.acceptEvent(event)) {
                this.lastEventTime = event.time;
                Rectangle navigationComponentBounds = AbstractScrollingSupport.this.getNavigationComponent().getBounds();
                Point navigationPtAtDisplay = AbstractScrollingSupport.this.getNavigationComponent().toDisplay(0, 0);
                navigationComponentBounds.x = navigationPtAtDisplay.x;
                navigationComponentBounds.y = navigationPtAtDisplay.y;
                if (event.widget instanceof Control) {
                    Control widget = (Control)event.widget;
                    Point evtPt = widget.toDisplay(event.getBounds().x, event.getBounds().y);
                    if (navigationComponentBounds.contains(evtPt.x, evtPt.y)) {
                        if (event.count > 0) {
                            AbstractScrollingSupport.this.scrollUp(20);
                        } else {
                            AbstractScrollingSupport.this.scrollDown(20);
                        }
                    }
                }
            }
        }

        private boolean acceptEvent(Event event) {
            boolean isCurrent = event.time > this.lastEventTime;
            Control control = (Control)event.widget;
            boolean isActive = control.getShell() == this.getActiveShell();
            boolean isVisible = AbstractScrollingSupport.this.getNavigationComponent().isVisible();
            return isCurrent && isActive && isVisible;
        }

        private Shell getActiveShell() {
            IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            return activeWindow != null ? activeWindow.getShell() : null;
        }
    }
}

