/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.toolbox.previewer.customizer;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.riena.toolbox.previewer.IPreviewCustomizer;
import org.eclipse.riena.toolbox.previewer.customizer.Activator;
import org.eclipse.riena.ui.swt.lnf.ILnfTheme;
import org.eclipse.riena.ui.swt.lnf.LnFUpdater;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultTheme;
import org.eclipse.riena.ui.swt.utils.SWTControlFinder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RienaPreviewCustomizer
implements IPreviewCustomizer {
    private void updateLnf(ClassLoader classLoader) {
        String lnf = this.getLnfFromPreferences();
        if (lnf != null) {
            this.setLnf(classLoader, lnf);
        }
    }

    private String getLnfFromPreferences() {
        String customLnfClass = Activator.getDefault().getPreferenceStore().getString("lnfClassNamePreference");
        String lnf = Activator.getDefault().getPreferenceStore().getDefaultString("lnfClassNamePreference");
        if (customLnfClass != null && customLnfClass.trim().length() > 0) {
            lnf = customLnfClass;
        }
        return lnf;
    }

    private void setLnf(ClassLoader classLoader, String lnfName) {
        try {
            LnFUpdater.getInstance().clearCache();
            Class<?> loadClass = classLoader.loadClass(lnfName);
            RienaDefaultLnf lnf = (RienaDefaultLnf)loadClass.newInstance();
            Class<?> lnfTheme = classLoader.loadClass(lnf.getTheme().getClass().getName());
            RienaDefaultTheme theme = (RienaDefaultTheme)lnfTheme.newInstance();
            lnf.setTheme((ILnfTheme)theme);
            LnfManager.setLnf((RienaDefaultLnf)lnf);
            return;
        }
        catch (ClassNotFoundException e) {
            this.showWarning("ClassNotFoundException", e);
        }
        catch (InstantiationException e) {
            this.showWarning("InstantiationException", e);
        }
        catch (IllegalAccessException e) {
            this.showWarning("IllegalAccessException", e);
        }
    }

    private void showWarning(String message, Exception e) {
        String logMessage = String.valueOf(message) + "\n" + e.getMessage();
        MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Warning", (String)logMessage);
        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.riena.toolbox.previewer.lnf", logMessage, (Throwable)e));
    }

    public void beforeClassLoad(ClassLoader project) {
        this.updateLnf(project);
    }

    public Class<?> getParentClass() {
        return RienaDefaultLnf.class;
    }

    public void afterCreation(Composite parent) {
        SWTControlFinder finder;
        String currentLnf = this.getLnfFromPreferences();
        if (currentLnf == null) {
            finder = new SWTControlFinder(parent){

                public void handleControl(Control control) {
                    super.handleControl(control);
                    control.redraw();
                }

                public void handleBoundControl(Control control, String bindingProperty) {
                }
            };
            finder.run();
        }
        if (!Activator.getDefault().getPreferenceStore().getBoolean("showRidgetIdsPreference")) {
            return;
        }
        finder = new SWTControlFinder(parent){

            public void handleBoundControl(Control control, String bindingProperty) {
                control.setToolTipText(String.format("Ridget-Id '%s'", bindingProperty));
                control.redraw();
            }
        };
        finder.run();
    }
}

