/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.toolbox.previewer.ui;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.riena.toolbox.previewer.IPreviewCustomizer;
import org.eclipse.riena.toolbox.previewer.WorkspaceClassLoader;
import org.eclipse.riena.toolbox.previewer.model.ViewPartInfo;
import org.eclipse.riena.toolbox.previewer.ui.ReflectionUtil;
import org.eclipse.riena.toolbox.previewer.ui.WorkbenchUtil;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class Preview
extends ViewPart {
    public static final String ID = "org.eclipse.riena.toolbox.previewer.ui.Preview";
    private static final String VIEW_TITLE = "Previewer";
    private Composite globalParent;
    private CompResourceChangeListener changeListener;
    private Button showGridButton;
    private ViewPartInfo lastViewPart;
    private ShowGridPaintListener showGridPaintListener;

    public void createPartControl(Composite parent) {
        this.globalParent = parent;
        parent.setLayout((Layout)new FillLayout());
        this.setPartName(VIEW_TITLE);
        this.getViewSite().getActionBars().getToolBarManager().add((IContributionItem)new ViewSizeToolBar(parent));
        this.changeListener = new CompResourceChangeListener(parent.getDisplay());
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.changeListener, 1);
    }

    public void showView(ViewPartInfo viewPart) {
        this.updateView(viewPart);
        this.changeListener.setViewPart(viewPart);
    }

    private void updateView(ViewPartInfo viewPart) {
        IPreviewCustomizer contribution;
        Object instance;
        this.lastViewPart = viewPart;
        if (this.globalParent.isDisposed()) {
            return;
        }
        Control[] controlArray = this.globalParent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.removePaintListener((PaintListener)this.showGridPaintListener);
            child.dispose();
            ++n2;
        }
        this.repaintView();
        this.setPartName(viewPart.getName());
        if (ViewPart.class.isAssignableFrom(viewPart.getType())) {
            instance = ReflectionUtil.loadClass(viewPart);
            if (!ReflectionUtil.invokeMethod("createPartControl", instance, this.globalParent)) {
                this.setPartName(VIEW_TITLE);
                return;
            }
        } else {
            instance = (Control)ReflectionUtil.newInstance(viewPart.getType(), this.globalParent);
            if (instance == null) {
                MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Warning", (String)("Can not instantiate Composite " + viewPart.getType().getName() + "\nNo valid SWT-style constructor found"));
                return;
            }
            instance.addPaintListener((PaintListener)this.showGridPaintListener);
        }
        if ((contribution = WorkspaceClassLoader.getInstance().getContributedPreviewCustomizer()) != null) {
            contribution.afterCreation(this.globalParent);
        }
        this.repaintView();
    }

    private void repaintView() {
        this.globalParent.layout(true, true);
        this.globalParent.redraw();
    }

    public void setFocus() {
        this.globalParent.setFocus();
    }

    private class CompResourceChangeListener
    implements IResourceChangeListener {
        private ViewPartInfo viewPart;
        private final Display display;

        public CompResourceChangeListener(Display display) {
            this.display = display;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (this.viewPart == null) {
                return;
            }
            CompilationUnitVisitor pluginXmlVisitor = new CompilationUnitVisitor(this.viewPart);
            try {
                event.getDelta().accept((IResourceDeltaVisitor)pluginXmlVisitor);
                if (pluginXmlVisitor.isCompilationUnitChanged()) {
                    this.display.syncExec(new Runnable(){

                        public void run() {
                            Preview.this.updateView(WorkspaceClassLoader.getInstance().loadClass(CompResourceChangeListener.this.viewPart.getCompilationUnit()));
                        }
                    });
                }
            }
            catch (CoreException e) {
                WorkbenchUtil.handleException(e);
                throw new RuntimeException(e);
            }
        }

        public void setViewPart(ViewPartInfo viewPart) {
            this.viewPart = viewPart;
        }
    }

    private static class CompilationUnitVisitor
    implements IResourceDeltaVisitor {
        private final ViewPartInfo compilationUnitClassName;
        private boolean compilationUnitChanged = false;

        public CompilationUnitVisitor(ViewPartInfo compilationUnitClassName) {
            this.compilationUnitClassName = compilationUnitClassName;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource res = delta.getResource();
            if (res.getType() == 1 && (String.valueOf(this.compilationUnitClassName.getType().getSimpleName()) + ".class").equals(res.getName())) {
                this.compilationUnitChanged = true;
                return false;
            }
            return true;
        }

        public boolean isCompilationUnitChanged() {
            return this.compilationUnitChanged;
        }
    }

    private class ShowGridPaintListener
    implements PaintListener {
        private ShowGridPaintListener() {
        }

        public void paintControl(PaintEvent e) {
            if (!Preview.this.showGridButton.getSelection()) {
                return;
            }
            if (!(e.widget instanceof Composite)) {
                return;
            }
            Composite targetComposite = (Composite)e.widget;
            e.gc.setForeground(e.display.getSystemColor(3));
            Control[] controlArray = targetComposite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                int width = control.getBounds().width + control.getBounds().x;
                e.gc.drawLine(width, 0, width, targetComposite.getBounds().height);
                int height = control.getBounds().height + control.getBounds().y;
                e.gc.drawLine(0, height, targetComposite.getBounds().width, height);
                if (control instanceof Composite) {
                    control.addPaintListener((PaintListener)this);
                }
                ++n2;
            }
        }
    }

    private class ViewSizeToolBar
    extends ContributionItem {
        private static final String LABEL_HIDE_GRID = "hide grid";
        private static final String LABEL_SHOW_GRID = "show grid";
        private final Composite viewParent;

        public ViewSizeToolBar(Composite viewParent) {
            this.viewParent = viewParent;
        }

        public void fill(ToolBar parent, int index) {
            this.createShowGridButton(parent);
            final Text txtSize = this.createText(parent);
            this.viewParent.addListener(11, new Listener(){

                public void handleEvent(Event e) {
                    txtSize.setText(String.valueOf(((ViewSizeToolBar)ViewSizeToolBar.this).viewParent.getSize().x) + "x" + ((ViewSizeToolBar)ViewSizeToolBar.this).viewParent.getSize().y);
                }
            });
        }

        private Text createText(ToolBar parent) {
            ToolItem tool = new ToolItem(parent, 2);
            Text text = new Text((Composite)parent, 2048);
            tool.setWidth(80);
            text.setEditable(false);
            tool.setControl((Control)text);
            return text;
        }

        private Button createShowGridButton(ToolBar parent) {
            ToolItem tool = new ToolItem(parent, 2);
            Preview.this.showGridButton = new Button((Composite)parent, 2);
            Preview.this.showGridButton.setText(LABEL_SHOW_GRID);
            Preview.this.showGridButton.setSelection(false);
            Preview.this.showGridButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (Preview.this.lastViewPart != null && !ViewPart.class.isAssignableFrom(Preview.this.lastViewPart.getType())) {
                        Preview.this.updateView(Preview.this.lastViewPart);
                    } else {
                        Preview.this.repaintView();
                    }
                    Preview.this.showGridButton.setText(Preview.this.showGridButton.getSelection() ? ViewSizeToolBar.LABEL_HIDE_GRID : ViewSizeToolBar.LABEL_SHOW_GRID);
                }
            });
            tool.setWidth(70);
            tool.setControl((Control)Preview.this.showGridButton);
            Preview.this.showGridPaintListener = new ShowGridPaintListener();
            Preview.this.globalParent.addPaintListener((PaintListener)Preview.this.showGridPaintListener);
            return Preview.this.showGridButton;
        }
    }
}

