/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.ui.ridgets.AbstractRidget;
import org.eclipse.riena.ui.ridgets.IMessageBoxRidget;
import org.eclipse.riena.ui.swt.MessageBox;
import org.eclipse.riena.ui.swt.facades.DialogConstantsFacade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageBoxRidget
extends AbstractRidget
implements IMessageBoxRidget {
    private MessageBox messageBox;
    private String title;
    private String text;
    private boolean visible;
    private boolean enabled = true;
    private boolean focusable = true;
    private IMessageBoxRidget.Type type = IMessageBoxRidget.Type.PLAIN;
    private IMessageBoxRidget.MessageBoxOption[] options = OPTIONS_OK;

    public IMessageBoxRidget.MessageBoxOption[] getOptions() {
        return this.options;
    }

    public String getText() {
        return this.text;
    }

    public String getTitle() {
        return this.title;
    }

    public IMessageBoxRidget.Type getType() {
        return this.type;
    }

    public void setOptions(IMessageBoxRidget.MessageBoxOption[] options) {
        this.options = options;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setType(IMessageBoxRidget.Type type) {
        this.type = type;
    }

    public IMessageBoxRidget.MessageBoxOption show() {
        if (this.messageBox != null) {
            if (this.type == null) {
                this.type = IMessageBoxRidget.Type.PLAIN;
            }
            return this.show(this.type);
        }
        return null;
    }

    private IMessageBoxRidget.MessageBoxOption show(IMessageBoxRidget.Type type) {
        this.messageBox.show(this.getTitle(), this.getText(), this.getType(type), this.getButtonLabels(type));
        return this.getResultOption();
    }

    private String[] getButtonLabels(IMessageBoxRidget.Type type) {
        String[] labels = new String[this.options.length];
        int i = 0;
        while (i < this.options.length) {
            labels[i] = this.getButtonLabel(this.options[i]);
            ++i;
        }
        return labels;
    }

    private String getButtonLabel(IMessageBoxRidget.MessageBoxOption option) {
        String result = OK.equals(option) ? DialogConstantsFacade.getDefault().getOkLabel() : (CANCEL.equals(option) ? DialogConstantsFacade.getDefault().getCancelLabel() : (YES.equals(option) ? DialogConstantsFacade.getDefault().getYesLabel() : (NO.equals(option) ? DialogConstantsFacade.getDefault().getNoLabel() : option.getLabel())));
        return result;
    }

    private IMessageBoxRidget.MessageBoxOption getResultOption() {
        int result = this.messageBox.getResult();
        if (result == -1) {
            return CLOSED;
        }
        return this.getOptions()[result];
    }

    private int getType(IMessageBoxRidget.Type type) {
        switch (type) {
            case PLAIN: {
                return 0;
            }
            case INFORMATION: {
                return 2;
            }
            case WARNING: {
                return 4;
            }
            case ERROR: {
                return 1;
            }
            case HELP: {
                return 2;
            }
            case QUESTION: {
                return 3;
            }
        }
        return 0;
    }

    public String getID() {
        if (this.getUIControl() != null) {
            return this.getUIControl().getPropertyName();
        }
        return null;
    }

    public String getToolTipText() {
        return null;
    }

    public MessageBox getUIControl() {
        return this.messageBox;
    }

    public boolean hasFocus() {
        return this.messageBox.hasFocus();
    }

    public boolean isFocusable() {
        return this.focusable;
    }

    public boolean isVisible() {
        return this.messageBox != null && this.visible;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void requestFocus() {
        if (this.isFocusable()) {
            this.messageBox.requestFocus();
        }
    }

    public void setFocusable(boolean focusable) {
        this.focusable = focusable;
    }

    public void setToolTipText(String toolTipText) {
        throw new UnsupportedOperationException("not supported");
    }

    public void setUIControl(Object uiControl) {
        this.assertUIControlType(uiControl, MessageBox.class);
        this.messageBox = (MessageBox)uiControl;
        this.updateUIControl();
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.updateUIControl();
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.updateUIControl();
    }

    public void updateFromModel() {
    }

    private void updateUIControl() {
        if (this.messageBox != null) {
            this.updateVisible();
            this.updateEnabled();
        }
    }

    private void updateVisible() {
        this.messageBox.setVisible(this.visible);
    }

    private void updateEnabled() {
        this.messageBox.setVisible(this.enabled);
    }

    protected void assertUIControlType(Object uiControl, Class<MessageBox> requiredUIControlType) {
        Assert.isTrue((uiControl == null || requiredUIControlType.isAssignableFrom(uiControl.getClass()) ? 1 : 0) != 0, (String)("Wrong UI-control type. Expected " + requiredUIControlType));
    }
}

