/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.riena.ui.ridgets.validation.IValidationCallback;
import org.eclipse.riena.ui.ridgets.validation.ValidationRuleStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorCollection
implements IValidator,
Iterable<IValidator> {
    private final Collection<IValidator> validators = new HashSet<IValidator>(2);

    public Collection<IValidator> getValidators() {
        return Collections.unmodifiableCollection(new ArrayList<IValidator>(this.validators));
    }

    @Override
    public Iterator<IValidator> iterator() {
        return this.getValidators().iterator();
    }

    public void add(IValidator validator) {
        Assert.isNotNull((Object)validator);
        this.validators.add(validator);
    }

    public void remove(IValidator validator) {
        Assert.isNotNull((Object)validator);
        this.validators.remove(validator);
    }

    public boolean contains(IValidator validator) {
        return this.validators.contains(validator);
    }

    public IStatus validate(Object value) {
        return this.validate(value, null);
    }

    public IStatus validate(Object value, IValidationCallback callback) {
        IStatus[] statuses = new IStatus[this.validators.size()];
        int index = -1;
        for (IValidator validator : this.validators) {
            statuses[++index] = validator.validate(value);
            if (callback == null) continue;
            callback.validationRuleChecked(validator, statuses[index]);
        }
        IStatus result = ValidationRuleStatus.join(statuses);
        if (callback != null) {
            callback.validationResult(result);
        }
        return result;
    }
}

