/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.swt.lnf;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.riena.core.exception.Failure;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.internal.ui.swt.Activator;
import org.eclipse.riena.ui.swt.lnf.IDefaultLnfExtension;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.BundleUtil;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LnfManagerInternal {
    public static final String RIENA_LNF_SYSTEM_PROPERTY = "riena.lnf";
    private RienaDefaultLnf defaultLnf = new RienaDefaultLnf();
    private volatile RienaDefaultLnf currentLnf;
    private RienaDefaultLnf extensionLnf;
    private static final String BUNDLE_CLASS_NAME_SEPARATOR = ":";

    private LnfManagerInternal() {
    }

    public void setDefaultLnf(RienaDefaultLnf defaultLnf) {
        Assert.isNotNull((Object)defaultLnf, (String)"defaultLnf must not be null.");
        this.defaultLnf = defaultLnf;
        this.setLnf((RienaDefaultLnf)null);
    }

    public void setLnf(String currentLnfClassName) {
        this.setLnf(LnfManagerInternal.createLnf(currentLnfClassName));
    }

    public synchronized void setLnf(RienaDefaultLnf currentLnf) {
        if (this.currentLnf == currentLnf) {
            return;
        }
        if (this.currentLnf != null) {
            this.currentLnf.uninitialize();
        }
        this.currentLnf = currentLnf;
        if (this.currentLnf != null) {
            if (Activator.getDefault() != null) {
                Wire.instance((Object)this.currentLnf).andStart(Activator.getDefault().getContext());
            }
            this.currentLnf.initialize();
        }
    }

    @InjectExtension
    public void update(IDefaultLnfExtension[] lnfExtension) {
        if (lnfExtension != null && lnfExtension.length > 0) {
            this.extensionLnf = lnfExtension[0].createDefaultLnf();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RienaDefaultLnf getLnf() {
        if (this.currentLnf != null) return this.currentLnf;
        Class<LnfManagerInternal> clazz = LnfManagerInternal.class;
        synchronized (LnfManagerInternal.class) {
            if (this.currentLnf != null) return this.currentLnf;
            String className = System.getProperty(RIENA_LNF_SYSTEM_PROPERTY);
            if (className != null) {
                this.setLnf(className);
            } else if (this.extensionLnf != null) {
                this.setLnf(this.extensionLnf);
            } else {
                this.setLnf(this.defaultLnf);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.currentLnf;
        }
    }

    @Deprecated
    public String getLnfClassName() {
        return this.getLnf().getClass().getName();
    }

    public void dispose() {
        if (this.currentLnf != null) {
            this.currentLnf.uninitialize();
            this.currentLnf = null;
        }
    }

    private static RienaDefaultLnf createLnf(String lnfClassName) {
        if (lnfClassName == null) {
            return null;
        }
        Class lnfClass = null;
        if (lnfClassName.contains(BUNDLE_CLASS_NAME_SEPARATOR)) {
            String[] parts = lnfClassName.split(BUNDLE_CLASS_NAME_SEPARATOR);
            String bundleSymbolicName = parts[0];
            String className = parts[1];
            Bundle bundle = Platform.getBundle((String)bundleSymbolicName);
            if (!BundleUtil.isReady(bundle)) {
                throw new LnfManagerFailure("can't load LnfClass '" + className + "' from bundle " + bundleSymbolicName + " because bundle is not ready.");
            }
            try {
                lnfClass = bundle.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new LnfManagerFailure("can't load LnfClass '" + className + "' from bundle " + bundleSymbolicName + ".", e);
            }
        } else {
            lnfClass = LnfManagerInternal.loadClass(lnfClassName);
        }
        try {
            return (RienaDefaultLnf)lnfClass.newInstance();
        }
        catch (Exception e) {
            throw new LnfManagerFailure("can't create instance for LnfClass '" + lnfClass.getName() + ".", e);
        }
    }

    private static Class<?> loadClass(String className) {
        try {
            return LnfManagerInternal.class.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new LnfManagerFailure("Can't load LnfClass '" + className + "'. Please use the class format specified in the LnfManager or change your bundle dependencies.", e);
        }
    }

    private static class LnfManagerFailure
    extends Failure {
        public LnfManagerFailure(String msg) {
            super(msg);
        }

        public LnfManagerFailure(String msg, Throwable thrown) {
            super(msg, thrown);
        }
    }
}

