/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import java.util.EventListener;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.internal.ui.swt.Activator;
import org.eclipse.riena.ui.ridgets.IControlDecoration;
import org.eclipse.riena.ui.swt.DatePickerComposite;
import org.eclipse.riena.ui.swt.IDecorationActivationStrategy;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class BorderControlDecoration
implements IControlDecoration {
    private static final Rectangle ZERO_RECTANGLE = new Rectangle(0, 0, 0, 0);
    private static final int DEFAULT_BORDER_WIDTH = 1;
    private Control control;
    private DisposeListener disposeListener;
    private PaintListener paintListener;
    private ControlListener updateListener;
    private Rectangle updateArea;
    private Color borderColor;
    private int borderWidth = 1;
    private boolean visible;
    private final IDecorationActivationStrategy activationStrategy;

    private static void logWarning(String message) {
        Logger logger = Log4r.getLogger((IRienaActivator)Activator.getDefault(), BorderControlDecoration.class);
        logger.log(2, message);
    }

    public BorderControlDecoration(Control control) {
        this(control, 1);
    }

    public BorderControlDecoration(Control control, int borderWidth) {
        this(control, borderWidth, null);
    }

    public BorderControlDecoration(Control control, int borderWidth, Color borderColor) {
        this(control, borderWidth, borderColor, new DefaultActivationStrategy());
    }

    public BorderControlDecoration(Control control, int borderWidth, Color borderColor, IDecorationActivationStrategy activationStrategy) {
        this.activationStrategy = activationStrategy;
        this.control = this.getBorderControl(control);
        this.borderWidth = this.checkBorderWidth(borderWidth);
        this.borderColor = borderColor;
        this.addListeners();
    }

    public void dispose() {
        if (this.control == null) {
            return;
        }
        this.removeListeners();
        this.control = null;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void hide() {
        if (this.visible) {
            this.visible = false;
            this.update();
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        this.update();
    }

    public void show() {
        if (!this.visible) {
            this.visible = true;
            this.update();
        }
    }

    private void addListeners() {
        this.disposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                BorderControlDecoration.this.dispose();
            }
        };
        this.control.addDisposeListener(this.disposeListener);
        this.updateListener = new ControlListener(){

            public void controlMoved(ControlEvent e) {
                BorderControlDecoration.this.update();
            }

            public void controlResized(ControlEvent e) {
                BorderControlDecoration.this.update();
            }
        };
        this.paintListener = new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (BorderControlDecoration.this.shouldShowDecoration()) {
                    Control uiControl = (Control)event.widget;
                    Rectangle rect = BorderControlDecoration.this.getDecorationRectangle(uiControl);
                    BorderControlDecoration.this.onPaint(event.gc, rect);
                }
            }
        };
        Object c = this.control;
        Rectangle controlBounds = this.control.getBounds();
        while (c != null) {
            this.addPaintAndUpdateListeners((Control)c);
            if (c instanceof Shell) {
                c = null;
                continue;
            }
            if (c instanceof ScrolledComposite) {
                c = null;
                continue;
            }
            Rectangle globalRect = this.getGlobalRectangle((Control)c);
            c = globalRect.x >= 0 && globalRect.y >= 0 && controlBounds.width + this.getBorderWidth() <= globalRect.width && controlBounds.height + this.getBorderWidth() <= globalRect.height ? null : c.getParent();
        }
    }

    private Rectangle getDecorationRectangle(Control targetControl) {
        Rectangle globalRect = this.getGlobalRectangle(targetControl);
        if (globalRect.width <= 0 && globalRect.height <= 0) {
            return globalRect;
        }
        globalRect.x -= this.getBorderWidth();
        globalRect.y -= this.getBorderWidth();
        globalRect.height += 2 * this.getBorderWidth();
        globalRect.width += 2 * this.getBorderWidth();
        return globalRect;
    }

    private Rectangle getGlobalRectangle(Control targetControl) {
        if (this.control == null) {
            return ZERO_RECTANGLE;
        }
        Rectangle controlBounds = this.control.getBounds();
        if (controlBounds.width <= 0 && controlBounds.height <= 0) {
            return ZERO_RECTANGLE;
        }
        int x = controlBounds.x;
        int y = controlBounds.y;
        Point globalPoint = this.control.getParent().toDisplay(x, y);
        Point targetPoint = targetControl == null ? globalPoint : targetControl.toControl(globalPoint);
        int width = controlBounds.width - 1;
        int height = controlBounds.height - 1;
        return new Rectangle(targetPoint.x, targetPoint.y, width, height);
    }

    private void addPaintAndUpdateListeners(Control control) {
        if (!control.isDisposed()) {
            SWTFacade.getDefault().addPaintListener(control, (EventListener)this.paintListener);
            control.addControlListener(this.updateListener);
        }
    }

    private int checkBorderWidth(int candidate) {
        int result = candidate;
        if (candidate < 0) {
            BorderControlDecoration.logWarning("BorderWidth is lower than 0: " + candidate);
            result = 0;
        }
        return result;
    }

    private Control getBorderControl(Control control) {
        Control result = control;
        if (control.getParent() instanceof DatePickerComposite) {
            result = this.control.getParent();
        } else if ("mdTable".equals(SWTBindingPropertyLocator.getInstance().locateBindingProperty(control))) {
            result = control.getParent().getParent();
        }
        return result;
    }

    private void onPaint(GC gc, Rectangle rect) {
        if (rect.width == 0 && rect.height == 0) {
            return;
        }
        Color previousForeground = gc.getForeground();
        if (this.getBorderColor() != null) {
            gc.setForeground(this.getBorderColor());
        } else {
            BorderControlDecoration.logWarning("BorderColor is null!");
        }
        int i = 0;
        while (i < this.getBorderWidth()) {
            gc.drawRectangle(rect.x + i, rect.y + i, rect.width - i * 2, rect.height - i * 2);
            ++i;
        }
        gc.setForeground(previousForeground);
    }

    private void removeListeners() {
        if (this.control == null) {
            return;
        }
        this.control.removeDisposeListener(this.disposeListener);
        Object c = this.control;
        while (c != null) {
            this.removePaintAndUpdateListeners((Control)c);
            c = c instanceof Shell ? null : c.getParent();
        }
        this.paintListener = null;
        this.updateListener = null;
        this.disposeListener = null;
    }

    private void removePaintAndUpdateListeners(Control control) {
        if (!control.isDisposed()) {
            control.removeControlListener(this.updateListener);
            SWTFacade.getDefault().removePaintListener(control, (EventListener)this.paintListener);
        }
    }

    private boolean shouldShowDecoration() {
        if (this.activationStrategy != null && !this.activationStrategy.isActive()) {
            return false;
        }
        if (!this.visible) {
            return false;
        }
        if (SwtUtilities.isDisposed((Widget)this.control)) {
            return false;
        }
        if (!this.control.isVisible()) {
            return false;
        }
        return this.getBorderWidth() > 0;
    }

    private void update() {
        if (SwtUtilities.isDisposed((Widget)this.control) || this.getBorderWidth() <= 0) {
            return;
        }
        Shell shell = this.control.getShell();
        if (this.updateArea != null) {
            shell.redraw(this.updateArea.x, this.updateArea.y, this.updateArea.width, this.updateArea.height, true);
        }
        this.updateArea = this.getDecorationRectangle((Control)shell);
        --this.updateArea.x;
        --this.updateArea.y;
        this.updateArea.width += 2;
        this.updateArea.height += 2;
        shell.redraw(this.updateArea.x, this.updateArea.y, this.updateArea.width, this.updateArea.height, true);
        shell.update();
    }

    private static class DefaultActivationStrategy
    implements IDecorationActivationStrategy {
        private DefaultActivationStrategy() {
        }

        public boolean isActive() {
            return true;
        }
    }
}

