/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import org.eclipse.riena.core.util.RAPDetector;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.ui.swt.AbstractStatuslineComposite;
import org.eclipse.riena.ui.swt.IStatusLineContentFactory;
import org.eclipse.riena.ui.swt.Statusline;
import org.eclipse.riena.ui.swt.StatuslineDate;
import org.eclipse.riena.ui.swt.StatuslineMessage;
import org.eclipse.riena.ui.swt.StatuslineNumber;
import org.eclipse.riena.ui.swt.StatuslineTime;
import org.eclipse.riena.ui.swt.StatuslineUIProcess;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class DefaultStatuslineContentFactory
implements IStatusLineContentFactory {
    public void createContent(Statusline statusline) {
        statusline.setLayout((Layout)new FormLayout());
        FormData formData = null;
        AbstractStatuslineComposite lastControl = null;
        Control spacerControl = null;
        if (!RAPDetector.isRAPavailable()) {
            StatuslineTime time = new StatuslineTime(statusline, 0);
            formData = new FormData();
            formData.top = new FormAttachment(0, 0);
            formData.bottom = new FormAttachment(100, 0);
            formData.right = new FormAttachment(100, 0);
            time.setLayoutData(formData);
            lastControl = time;
            spacerControl = this.createSpacer(statusline);
            if (spacerControl != null) {
                this.setSpaceLayoutData((Control)lastControl, spacerControl);
                lastControl = spacerControl;
            }
            StatuslineDate date = new StatuslineDate(statusline, 0);
            formData = new FormData();
            formData.top = new FormAttachment(0, 0);
            formData.bottom = new FormAttachment(100, 0);
            formData.right = new FormAttachment((Control)lastControl, 0);
            date.setLayoutData(formData);
            lastControl = date;
            spacerControl = this.createSpacer(statusline);
            if (spacerControl != null) {
                this.setSpaceLayoutData((Control)lastControl, spacerControl);
                lastControl = spacerControl;
            }
        }
        StatuslineNumber number = this.createStatuslineNumber(statusline);
        statusline.addUIControl((Widget)number, "statuslineNumberRidget");
        FormData formData1 = new FormData();
        formData1.top = new FormAttachment(0, 0);
        formData1.bottom = new FormAttachment(100, 0);
        formData1.right = RAPDetector.isRAPavailable() ? new FormAttachment(100, 0) : new FormAttachment(lastControl, 0);
        number.setLayoutData(formData1);
        lastControl = number;
        spacerControl = this.createSpacer(statusline);
        if (spacerControl != null) {
            this.setSpaceLayoutData((Control)lastControl, spacerControl);
            lastControl = spacerControl;
        }
        StatuslineUIProcess uiProcess = new StatuslineUIProcess(statusline, 0);
        statusline.addUIControl((Widget)uiProcess, "statuslineUIProcessRidget");
        formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        formData.right = new FormAttachment((Control)lastControl, 0);
        uiProcess.setLayoutData(formData);
        lastControl = uiProcess;
        spacerControl = this.createSpacer(statusline);
        if (spacerControl != null) {
            this.setSpaceLayoutData((Control)lastControl, spacerControl);
            lastControl = spacerControl;
        }
        StatuslineMessage message = statusline.getMessageComposite();
        formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment((Control)lastControl, 0);
        message.setLayoutData(formData);
        lastControl = message;
    }

    private void setSpaceLayoutData(Control lastControl, Control spacerControl) {
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        formData.right = new FormAttachment(lastControl, 0);
        spacerControl.setLayoutData((Object)formData);
    }

    protected StatuslineNumber createStatuslineNumber(Statusline statusline) {
        return new StatuslineNumber(statusline, 0);
    }

    protected Control createSpacer(Statusline statusline) {
        Control result = null;
        Class<? extends Control> spacer = statusline.getSpacer();
        if (spacer != null) {
            try {
                result = (Control)ReflectionUtils.newInstance(spacer, (Object[])new Object[]{statusline, 0});
            }
            catch (Exception exception) {
                result = null;
            }
        }
        return result;
    }
}

