/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.riena.ui.swt.RienaMessageDialog;
import org.eclipse.riena.ui.swt.utils.IPropertyNameProvider;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;

public class MessageBox
implements IPropertyNameProvider {
    private String propertyName;
    private final Composite parent;
    private int result;
    private MessageDialog messageDialog;
    private final Set<FocusListener> focusListeners;

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public MessageBox(Composite parent) {
        this.parent = parent;
        this.focusListeners = new HashSet<FocusListener>();
    }

    public void show(String title, String text, int type, String[] buttonLabels) {
        this.messageDialog = new RienaMessageDialog(this.parent.getShell(), title, null, text, type, buttonLabels, 0){

            public boolean close() {
                for (FocusListener l : MessageBox.this.focusListeners) {
                    MessageBox.this.messageDialog.getShell().removeFocusListener(l);
                }
                boolean closed = super.close();
                MessageBox.this.messageDialog = null;
                return closed;
            }

            public void create() {
                super.create();
                for (FocusListener l : MessageBox.this.focusListeners) {
                    this.getShell().addFocusListener(l);
                }
            }
        };
        this.result = this.messageDialog.open();
    }

    public int getResult() {
        return this.result;
    }

    public void requestFocus() {
        if (this.messageDialog != null) {
            this.messageDialog.getShell().setFocus();
        }
    }

    public boolean hasFocus() {
        if (this.messageDialog != null) {
            return this.messageDialog.getShell().isFocusControl();
        }
        return false;
    }

    public void setVisible(boolean visible) {
        if (this.messageDialog != null) {
            this.messageDialog.getShell().setVisible(visible);
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.messageDialog != null) {
            this.messageDialog.getShell().setEnabled(enabled);
        }
    }

    public void addFocusListener(FocusListener listener) {
        this.focusListeners.add(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.focusListeners.remove(listener);
    }
}

