/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.riena.ui.swt.AbstractStatuslineComposite;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

public class StatuslineTime
extends AbstractStatuslineComposite {
    protected SimpleDateFormat format;
    private Date date;
    private CLabel timeLabel;
    private Timer timer = new Timer();

    public StatuslineTime(Composite parent, int style) {
        super(parent, style | 0x80000);
        StatuslineUpdateTask task = new StatuslineUpdateTask();
        this.timer.scheduleAtFixedRate((TimerTask)task, 0L, 1000L);
    }

    protected void createContents() {
        this.timeLabel = new CLabel((Composite)this, 16384);
        this.timeLabel.setBackground(LnfManager.getLnf().getColor("statusline.background"));
        this.updateTime();
    }

    public void dispose() {
        super.dispose();
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        SwtUtilities.dispose((Widget)this.timeLabel);
    }

    protected SimpleDateFormat getFormat() {
        if (this.format == null) {
            this.format = new SimpleDateFormat("HH:mm");
        }
        return this.format;
    }

    private void updateTime() {
        if (this.date == null) {
            this.date = new Date();
        }
        this.date.setTime(System.currentTimeMillis());
        String timeStrg = this.getFormat().format(this.date);
        if (this.timeLabel != null && !this.timeLabel.isDisposed()) {
            this.timeLabel.setText(timeStrg);
        }
    }

    private class StatuslineUpdateTask
    extends TimerTask {
        private StatuslineUpdateTask() {
        }

        public void run() {
            if (!StatuslineTime.this.isDisposed() && !StatuslineTime.this.getDisplay().isDisposed()) {
                StatuslineTime.this.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        StatuslineTime.this.updateTime();
                    }
                });
            }
        }
    }
}

