/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.lnf;

import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.marker.Markable;
import org.eclipse.riena.ui.core.marker.DisabledMarker;
import org.eclipse.riena.ui.swt.facades.GCFacade;
import org.eclipse.riena.ui.swt.lnf.ILnfRenderer;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLnfRenderer
implements ILnfRenderer {
    private Collection<? extends IMarker> markers;
    private Rectangle bounds;

    @Override
    public void paint(GC gc, Object value) {
        Assert.isNotNull((Object)gc);
        this.initGC(gc);
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        this.setBounds(new Rectangle(x, y, width, height));
    }

    @Override
    public void setBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    @Override
    public void setMarkers(Collection<? extends IMarker> markers) {
        this.markers = markers;
    }

    @Override
    public Collection<? extends IMarker> getMarkers() {
        return this.markers;
    }

    @Override
    public <T extends IMarker> Collection<T> getMarkersOfType(Class<T> type) {
        return Markable.getMarkersOfType(this.getMarkers(), type);
    }

    protected boolean isEnabled() {
        return this.getMarkersOfType(DisabledMarker.class).isEmpty();
    }

    protected void initGC(GC gc) {
        GCFacade gcFacade = GCFacade.getDefault();
        gcFacade.setAdvanced(gc, true);
        gcFacade.setAntialias(gc, 1);
    }
}

