/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.utils;

import java.beans.Beans;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.riena.ui.swt.ChoiceComposite;
import org.eclipse.riena.ui.swt.CompletionCombo;
import org.eclipse.riena.ui.swt.DatePickerComposite;
import org.eclipse.riena.ui.swt.ImageButton;
import org.eclipse.riena.ui.swt.InfoFlyout;
import org.eclipse.riena.ui.swt.MasterDetailsComposite;
import org.eclipse.riena.ui.swt.MessageBox;
import org.eclipse.riena.ui.swt.StatusMeterWidget;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.separator.Separator;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.riena.ui.swt.utils.UIControlsCounter;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIControlsFactory {
    public static final String KEY_LNF_STYLE = "lnfStyle";
    public static final String KEY_TYPE = "type";
    public static final String LNF_STYLE_SECTION_LABEL = "sectionLabel";
    public static final String TYPE_NUMERIC = "numeric";
    public static final String TYPE_DECIMAL = "decimal";
    public static final String TYPE_DATE = "date";
    @Deprecated
    protected static final Color SHARED_BG_COLOR = LnfManager.getLnf().getColor("SubModule.background");

    static {
        Assert.isNotNull((Object)SHARED_BG_COLOR, (String)"You must define a color for LnfKeyConstants.SUB_MODULE_BACKGROUND");
    }

    protected static <T> T registerConstruction(T control) {
        UIControlsCounter.getInstance().registerConstruction(control);
        return control;
    }

    protected static <T> T bind(T widget, String bindingId) {
        SWTBindingPropertyLocator.getInstance().setBindingProperty(widget, bindingId);
        return widget;
    }

    public static Browser createBrowser(Composite parent, int style) {
        return UIControlsFactory.registerConstruction(new Browser(parent, style));
    }

    public static Browser createBrowser(Composite parent, int style, String bindingId) {
        return UIControlsFactory.bind(UIControlsFactory.createBrowser(parent, style), bindingId);
    }

    public static Button createButton(Composite parent) {
        return UIControlsFactory.registerConstruction(new Button(parent, 8));
    }

    public static Button createButton(Composite parent, String text) {
        Button result = UIControlsFactory.createButton(parent);
        result.setText(text);
        return result;
    }

    public static Button createButton(Composite parent, String text, String bindingId) {
        return UIControlsFactory.bind(UIControlsFactory.createButton(parent, text), bindingId);
    }

    public static Button createButtonCheck(Composite parent) {
        return UIControlsFactory.registerConstruction(new Button(parent, 32));
    }

    @Deprecated
    public static Button createButtonCheck(Composite parent, String bindingId) {
        return UIControlsFactory.bind(UIControlsFactory.createButtonCheck(parent), bindingId);
    }

    public static Button createButtonCheck(Composite parent, String text, String bindingId) {
        Button result = UIControlsFactory.createButtonCheck(parent);
        result.setText(text);
        return UIControlsFactory.bind(result, bindingId);
    }

    public static Button createButtonRadio(Composite parent) {
        return UIControlsFactory.registerConstruction(new Button(parent, 16));
    }

    @Deprecated
    public static Button createButtonRadio(Composite parent, String bindingId) {
        return UIControlsFactory.bind(UIControlsFactory.createButtonRadio(parent), bindingId);
    }

    public static Button createButtonRadio(Composite parent, String text, String bindingId) {
        Button result = UIControlsFactory.createButtonRadio(parent);
        result.setText(text);
        return UIControlsFactory.bind(result, bindingId);
    }

    public static Button createButtonToggle(Composite parent) {
        return UIControlsFactory.registerConstruction(new Button(parent, 2));
    }

    @Deprecated
    public static Button createButtonToggle(Composite parent, String bindingId) {
        return UIControlsFactory.bind(UIControlsFactory.createButtonToggle(parent), bindingId);
    }

    public static Button createButtonToggle(Composite parent, String text, String bindingId) {
        Button result = UIControlsFactory.createButtonToggle(parent);
        result.setText(text);
        return UIControlsFactory.bind(result, bindingId);
    }

    public static DateTime createCalendar(Composite parent) {
        DateTime result = new DateTime(parent, 1024);
        UIControlsFactory.registerConstruction(result);
        return result;
    }

    public static DateTime createCalendar(Composite parent, String bindingId) {
        return UIControlsFactory.bind(UIControlsFactory.createCalendar(parent), bindingId);
    }

    public static CCombo createCCombo(Composite parent) {
        return UIControlsFactory.registerConstruction(new CCombo(parent, 2056));
    }

    public static CCombo createCCombo(Composite parent, String bindingId) {
        return UIControlsFactory.bind(UIControlsFactory.createCCombo(parent), bindingId);
    }

    public static CompletionCombo createCompletionCombo(Composite parent) {
        return UIControlsFactory.createCompletionCombo(parent, 2048);
    }

    public static CompletionCombo createCompletionCombo(Composite parent, int style) {
        return UIControlsFactory.registerConstruction(SWTFacade.getDefault().createCompletionCombo(parent, style));
    }

    public static CompletionCombo createCompletionCombo(Composite parent, String bindingId) {
        return UIControlsFactory.bind(UIControlsFactory.createCompletionCombo(parent, 2048), bindingId);
    }

    public static CompletionCombo createCompletionComboWithImage(Composite parent) {
        return UIControlsFactory.createCompletionComboWithImage(parent, 2048);
    }

    public static CompletionCombo createCompletionComboWithImage(Composite parent, int style) {
        return UIControlsFactory.registerConstruction(SWTFacade.getDefault().createCompletionComboWithImage(parent, style));
    }

    public static CompletionCombo createCompletionComboWithImage(Composite parent, String bindingId) {
        return UIControlsFactory.bind(UIControlsFactory.createCompletionComboWithImage(parent, 2048), bindingId);
    }

    public static ChoiceComposite createChoiceComposite(Composite parent, int style, boolean multipleSelection) {
        return UIControlsFactory.registerConstruction(new ChoiceComposite(parent, style, multipleSelection));
    }

    public static ChoiceComposite createChoiceComposite(Composite parent, int style, boolean multipleSelection, String bindingId) {
        return UIControlsFactory.bind(UIControlsFactory.createChoiceComposite(parent, style, multipleSelection), bindingId);
    }

    public static Combo createCombo(Composite parent) {
        return UIControlsFactory.registerConstruction(new Combo(parent, 2060));
    }

    public static Combo createCombo(Composite parent, String bindingId) {
        return UIControlsFactory.bind(UIControlsFactory.createCombo(parent), bindingId);
    }

    public static Composite createComposite(Composite parent) {
        return UIControlsFactory.createComposite(parent, 0);
    }

    public static Composite createComposite(Composite parent, int style) {
        return UIControlsFactory.registerConstruction(new Composite(parent, style));
    }

    public static Composite createComposite(Composite parent, int style, String bindingId) {
        return UIControlsFactory.bind(UIControlsFactory.createComposite(parent, style), bindingId);
    }

    public static DateTime createDate(Composite parent, int style) {
        return UIControlsFactory.registerConstruction(new DateTime(parent, 0x24 | style));
    }

    public static DateTime createDate(Composite parent, int style, String bindingId) {
        return UIControlsFactory.bind(UIControlsFactory.createDate(parent, style), bindingId);
    }

    public static DatePickerComposite createDatePickerComposite(Composite parent) {
        DatePickerComposite result = new DatePickerComposite(parent, 131076);
        result.setData(KEY_TYPE, TYPE_DATE);
        return UIControlsFactory.registerConstruction(result);
    }

    public static DatePickerComposite createDatePickerComposite(Composite parent, String bindingId) {
        return UIControlsFactory.bind(UIControlsFactory.createDatePickerComposite(parent), bindingId);
    }

    public static Group createGroup(Composite parent, String text) {
        Group result = new Group(parent, 0);
        result.setText(text);
        return UIControlsFactory.registerConstruction(result);
    }

    public static Group createGroup(Composite parent, String text, String bindingId) {
        return UIControlsFactory.bind(UIControlsFactory.createGroup(parent, text), bindingId);
    }

    public static ImageButton createImageButton(Composite parent, Image image, int style, String bindingId) {
        ImageButton btn = UIControlsFactory.createImageButton(parent, style, bindingId);
        btn.setImage(image);
        return btn;
    }

    public static ImageButton createImageButton(Composite parent, int style) {
        return UIControlsFactory.registerConstruction(new ImageButton(parent, style));
    }

    public static ImageButton createImageButton(Composite parent, int style, String bindingId) {
        return UIControlsFactory.bind(UIControlsFactory.createImageButton(parent, style), bindingId);
    }

    public static InfoFlyout createInfoFlyout(Composite parent) {
        return UIControlsFactory.registerConstruction(SWTFacade.getDefault().createInfoFlyout(parent));
    }

    public static Label createLabel(Composite parent, String text) {
        return UIControlsFactory.createLabel(parent, text, 0);
    }

    public static Label createLabel(Composite parent, String text, int style) {
        Label label = new Label(parent, style);
        label.setText(text);
        return UIControlsFactory.registerConstruction(label);
    }

    public static Label createLabel(Composite parent, String text, int style, String bindingId) {
        return UIControlsFactory.bind(UIControlsFactory.createLabel(parent, text, style), bindingId);
    }

    public static Label createLabel(Composite parent, String text, String bindingId) {
        return UIControlsFactory.createLabel(parent, text, 0, bindingId);
    }

    public static Link createLink(Composite parent) {
        return UIControlsFactory.createLink(parent, 0);
    }

    public static Link createLink(Composite parent, int style) {
        return UIControlsFactory.registerConstruction(new Link(parent, style));
    }

    public static Link createLink(Composite parent, int style, String bindingId) {
        return UIControlsFactory.bind(UIControlsFactory.createLink(parent, style), bindingId);
    }

    public static List createList(Composite parent, boolean hScroll, boolean vScroll) {
        int style = 2050;
        if (hScroll) {
            style |= 0x100;
        }
        if (vScroll) {
            style |= 0x200;
        }
        return UIControlsFactory.registerConstruction(new List(parent, style));
    }

    public static List createList(Composite parent, boolean hScroll, boolean vScroll, String bindingId) {
        return UIControlsFactory.bind(UIControlsFactory.createList(parent, hScroll, vScroll), bindingId);
    }

    public static MasterDetailsComposite createMasterDetails(Composite parent) {
        return UIControlsFactory.registerConstruction(new MasterDetailsComposite(parent, 0));
    }

    public static MasterDetailsComposite createMasterDetails(Composite parent, String bindingId) {
        return UIControlsFactory.bind(UIControlsFactory.registerConstruction(new MasterDetailsComposite(parent, 0)), bindingId);
    }

    public static Menu createMenu(Control parent) {
        return UIControlsFactory.registerConstruction(new Menu(parent));
    }

    public static Menu createMenu(MenuItem parent) {
        return UIControlsFactory.registerConstruction(new Menu(parent));
    }

    public static MenuItem createMenuItem(Menu parent, String text) {
        MenuItem item = new MenuItem(parent, 0);
        item.setText(text);
        return UIControlsFactory.registerConstruction(item);
    }

    public static MenuItem createMenuItem(Menu parent, String text, int style) {
        MenuItem item = new MenuItem(parent, style);
        item.setText(text);
        return UIControlsFactory.registerConstruction(item);
    }

    public static MenuItem createMenuItem(Menu parent, String text, String bindingId) {
        MenuItem item = new MenuItem(parent, 0);
        item.setText(text);
        return UIControlsFactory.bind(UIControlsFactory.registerConstruction(item), bindingId);
    }

    public static MessageBox createMessageBox(Composite parent) {
        return UIControlsFactory.registerConstruction(new MessageBox(parent));
    }

    public static Shell createShell(Display display) {
        Assert.isNotNull((Object)display);
        return UIControlsFactory.registerConstruction(new Shell(display));
    }

    public static Table createTable(Composite parent, int style) {
        return UIControlsFactory.registerConstruction(new Table(parent, style));
    }

    public static Table createTable(Composite parent, int style, String bindingId) {
        return UIControlsFactory.bind(UIControlsFactory.createTable(parent, style), bindingId);
    }

    public static Text createText(Composite parent) {
        return UIControlsFactory.registerConstruction(new Text(parent, 2052));
    }

    public static Text createText(Composite parent, int style) {
        return UIControlsFactory.registerConstruction(new Text(parent, style | 0x800));
    }

    public static Text createText(Composite parent, int style, String bindingId) {
        return UIControlsFactory.bind(UIControlsFactory.createText(parent, style), bindingId);
    }

    public static Text createTextDate(Composite parent) {
        Text result = new Text(parent, 133124);
        result.setData(KEY_TYPE, (Object)TYPE_DATE);
        return UIControlsFactory.registerConstruction(result);
    }

    public static Text createTextDate(Composite parent, String bindingId) {
        return UIControlsFactory.bind(UIControlsFactory.createTextDate(parent), bindingId);
    }

    public static Text createTextDecimal(Composite parent) {
        Text result = new Text(parent, 133124);
        result.setData(KEY_TYPE, (Object)TYPE_DECIMAL);
        return UIControlsFactory.registerConstruction(result);
    }

    public static Text createTextDecimal(Composite parent, String bindingId) {
        return UIControlsFactory.bind(UIControlsFactory.createTextDecimal(parent), bindingId);
    }

    public static Text createTextMulti(Composite parent, boolean hScroll, boolean vScroll) {
        return UIControlsFactory.createTextMulti(parent, 0, hScroll, vScroll);
    }

    public static Text createTextMulti(Composite parent, boolean hScroll, boolean vScroll, String bindingId) {
        return UIControlsFactory.bind(UIControlsFactory.createTextMulti(parent, hScroll, vScroll), bindingId);
    }

    public static Text createTextMulti(Composite parent, int style, boolean hScroll, boolean vScroll) {
        int txStyle = style | 2 | 0x800;
        if (hScroll) {
            txStyle |= 0x100;
        }
        if (vScroll) {
            txStyle |= 0x200;
        }
        return UIControlsFactory.registerConstruction(new Text(parent, txStyle));
    }

    public static Text createTextMultiWrap(Composite parent, boolean hScroll, boolean vScroll) {
        return UIControlsFactory.createTextMulti(parent, 64, hScroll, vScroll);
    }

    public static Text createTextNumeric(Composite parent) {
        Text result = new Text(parent, 133124);
        result.setData(KEY_TYPE, (Object)TYPE_NUMERIC);
        return UIControlsFactory.registerConstruction(result);
    }

    public static Text createTextNumeric(Composite parent, String bindingId) {
        return UIControlsFactory.bind(UIControlsFactory.createTextNumeric(parent), bindingId);
    }

    public static DateTime createTime(Composite parent, int style) {
        return UIControlsFactory.registerConstruction(new DateTime(parent, 0x80 | style));
    }

    public static DateTime createTime(Composite parent, int style, String bindingId) {
        return UIControlsFactory.bind(UIControlsFactory.createTime(parent, style), bindingId);
    }

    public static Tree createTree(Composite parent, int style) {
        return UIControlsFactory.registerConstruction(new Tree(parent, style));
    }

    public static Tree createTree(Composite parent, int style, String bindingId) {
        return UIControlsFactory.bind(UIControlsFactory.createTree(parent, style), bindingId);
    }

    public static Spinner createSpinner(Composite parent, int style, String bindingId) {
        return UIControlsFactory.bind(UIControlsFactory.createSpinner(parent, style), bindingId);
    }

    public static Spinner createSpinner(Composite parent, int style) {
        return UIControlsFactory.registerConstruction(new Spinner(parent, style));
    }

    public static Spinner createSpinner(Composite parent) {
        return UIControlsFactory.createSpinner(parent, 2048);
    }

    public static Scale createScale(Composite parent, int style, String bindingId) {
        return UIControlsFactory.bind(UIControlsFactory.createScale(parent, style), bindingId);
    }

    public static Scale createScale(Composite parent, int style) {
        return UIControlsFactory.registerConstruction(new Scale(parent, style));
    }

    public static Scale createScale(Composite parent) {
        return UIControlsFactory.createScale(parent, 0);
    }

    public static ProgressBar createProgressBar(Composite parent, int style, String bindingId) {
        return UIControlsFactory.bind(UIControlsFactory.createProgressBar(parent, style), bindingId);
    }

    public static ProgressBar createProgressBar(Composite parent, int style) {
        return UIControlsFactory.registerConstruction(new ProgressBar(parent, style));
    }

    public static ProgressBar createProgressBar(Composite parent) {
        return UIControlsFactory.createProgressBar(parent, 256);
    }

    public static StatusMeterWidget createStatusMeter(Composite parent) {
        return UIControlsFactory.registerConstruction(new StatusMeterWidget(parent));
    }

    public static StatusMeterWidget createStatusMeter(Composite parent, String bindingId) {
        return UIControlsFactory.bind(UIControlsFactory.createStatusMeter(parent), bindingId);
    }

    public static Slider createSlider(Composite parent, int style, String bindingId) {
        return UIControlsFactory.bind(UIControlsFactory.createSlider(parent, style), bindingId);
    }

    public static Slider createSlider(Composite parent, int style) {
        return UIControlsFactory.registerConstruction(new Slider(parent, style));
    }

    public static Slider createSlider(Composite parent) {
        return UIControlsFactory.createSlider(parent, 256);
    }

    public static Separator createSeparator(Composite parent, int style) {
        return UIControlsFactory.createSeparatorTwoLine(parent, 256, "titlebar.separator.firstline.color", "titlebar.separator.secondtline.color");
    }

    private static Separator createSeparatorTwoLine(Composite parent, int style, String firstLineColor, String secondLineColor) {
        if (Beans.isDesignTime()) {
            Display display = parent.getDisplay();
            Separator result = new Separator(parent, style, display.getSystemColor(2), display.getSystemColor(1));
            return UIControlsFactory.registerConstruction(result);
        }
        Separator result = new Separator(parent, style, LnfManager.getLnf().getColor(firstLineColor), LnfManager.getLnf().getColor(secondLineColor));
        return UIControlsFactory.registerConstruction(result);
    }

    public static int getHeightHint(List list, int numItems) {
        Assert.isLegal((numItems > 0 ? 1 : 0) != 0, (String)"numItems must be greater than 0");
        int items = list.getItemHeight() * numItems;
        return items;
    }

    public static int getWidthHint(Button button) {
        GC gc = new GC((Drawable)button.getDisplay());
        try {
            FontMetrics fm = gc.getFontMetrics();
            int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fm, (int)61);
            Point minSize = button.computeSize(-1, -1, true);
            int n = Math.max(widthHint, minSize.x);
            return n;
        }
        finally {
            gc.dispose();
        }
    }

    public static int getWidthHint(Text text, int numChars) {
        Assert.isLegal((numChars > 0 ? 1 : 0) != 0, (String)"numChars must be greater than 0");
        GC gc = new GC((Drawable)text.getDisplay());
        try {
            FontMetrics fm = gc.getFontMetrics();
            int widthHint = fm.getAverageCharWidth() * numChars;
            Point minSize = text.computeSize(-1, -1, true);
            int n = Math.max(widthHint, minSize.x);
            return n;
        }
        finally {
            gc.dispose();
        }
    }

    protected UIControlsFactory() {
    }
}

