/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.presentation.ui;

import org.eclipse.rmf.reqif10.AttributeDefinitionString;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.AttributeValueString;
import org.eclipse.rmf.reqif10.DatatypeDefinition;
import org.eclipse.rmf.reqif10.DatatypeDefinitionString;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;
import org.eclipse.rmf.reqif10.pror.configuration.ProrPresentationConfiguration;
import org.eclipse.rmf.reqif10.pror.editor.presentation.service.IProrCellRenderer;
import org.eclipse.rmf.reqif10.pror.presentation.id.IdConfiguration;
import org.eclipse.rmf.reqif10.pror.presentation.id.IdVerticalAlign;
import org.eclipse.rmf.reqif10.pror.util.ConfigurationUtil;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class IdLabelCellRenderer
implements IProrCellRenderer {
    IdConfiguration config;

    public IdLabelCellRenderer() {
    }

    public IdLabelCellRenderer(IdConfiguration config) {
        this.config = config;
    }

    public int doDrawCellContent(GC gc, Rectangle rect, Object value) {
        Object text;
        if (value instanceof AttributeValueString && (text = ReqIF10Util.getTheValue((AttributeValue)((AttributeValue)value))) != null) {
            IdVerticalAlign align = this.getAlignment((AttributeValueString)value);
            Point extend = gc.textExtent(value.toString());
            int y = rect.y + 1;
            if (IdVerticalAlign.CENTER.equals((Object)align)) {
                y = rect.y + rect.height / 2 - extend.y / 2;
            }
            gc.drawText(text.toString(), rect.x + 1, y);
            return extend.y + 2;
        }
        return 16;
    }

    private IdVerticalAlign getAlignment(AttributeValueString av) {
        ProrPresentationConfiguration config;
        DatatypeDefinitionString dd;
        AttributeDefinitionString ad = av.getDefinition();
        if (ad != null && (dd = ad.getType()) != null && (config = ConfigurationUtil.getPresentationConfiguration((DatatypeDefinition)dd)) instanceof IdConfiguration) {
            return ((IdConfiguration)config).getVerticalAlign();
        }
        return IdVerticalAlign.CENTER;
    }

    public String doDrawHtmlContent(AttributeValue value) {
        AttributeValueString av = (AttributeValueString)value;
        return av.getTheValue();
    }
}

