/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.index.TermFreqVector;

public class QueryTermVector
implements TermFreqVector {
    private String[] terms = new String[0];
    private int[] termFreqs = new int[0];

    public String getField() {
        return null;
    }

    public QueryTermVector(String[] queryTerms) {
        this.processTerms(queryTerms);
    }

    public QueryTermVector(String queryString, Analyzer analyzer) {
        TokenStream stream;
        if (analyzer != null && (stream = analyzer.tokenStream("", new StringReader(queryString))) != null) {
            ArrayList<String> terms = new ArrayList<String>();
            try {
                boolean hasMoreTokens = false;
                stream.reset();
                TermAttribute termAtt = (TermAttribute)stream.addAttribute(TermAttribute.class);
                hasMoreTokens = stream.incrementToken();
                while (hasMoreTokens) {
                    terms.add(termAtt.term());
                    hasMoreTokens = stream.incrementToken();
                }
                this.processTerms(terms.toArray(new String[terms.size()]));
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private void processTerms(String[] queryTerms) {
        if (queryTerms != null) {
            int i;
            Arrays.sort(queryTerms);
            HashMap<String, Integer> tmpSet = new HashMap<String, Integer>(queryTerms.length);
            ArrayList<String> tmpList = new ArrayList<String>(queryTerms.length);
            ArrayList<Integer> tmpFreqs = new ArrayList<Integer>(queryTerms.length);
            int j = 0;
            for (i = 0; i < queryTerms.length; ++i) {
                String term = queryTerms[i];
                Integer position = (Integer)tmpSet.get(term);
                if (position == null) {
                    tmpSet.put(term, new Integer(j++));
                    tmpList.add(term);
                    tmpFreqs.add(new Integer(1));
                    continue;
                }
                Integer integer = (Integer)tmpFreqs.get(position);
                tmpFreqs.set(position, new Integer(integer + 1));
            }
            this.terms = tmpList.toArray(this.terms);
            this.termFreqs = new int[tmpFreqs.size()];
            i = 0;
            Iterator iter = tmpFreqs.iterator();
            while (iter.hasNext()) {
                Integer integer = (Integer)iter.next();
                this.termFreqs[i++] = integer;
            }
        }
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('{');
        for (int i = 0; i < this.terms.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.terms[i]).append('/').append(this.termFreqs[i]);
        }
        sb.append('}');
        return sb.toString();
    }

    public int size() {
        return this.terms.length;
    }

    public String[] getTerms() {
        return this.terms;
    }

    public int[] getTermFrequencies() {
        return this.termFreqs;
    }

    public int indexOf(String term) {
        int res = Arrays.binarySearch(this.terms, term);
        return res >= 0 ? res : -1;
    }

    public int[] indexesOf(String[] terms, int start, int len) {
        int[] res = new int[len];
        for (int i = 0; i < len; ++i) {
            res[i] = this.indexOf(terms[i]);
        }
        return res;
    }
}

