/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.editor.actions;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.rmf.reqif10.Specification;
import org.eclipse.rmf.reqif10.pror.editor.util.ProrEditorUtil;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SpecificationWebPrintAction
extends Action {
    private final Specification spec;
    private EditingDomain editingDomain;
    private AdapterFactory adapterFactory;

    public SpecificationWebPrintAction(Specification spec, EditingDomain editingDomain, AdapterFactory adapterFactory) {
        this.spec = spec;
        this.editingDomain = editingDomain;
        this.adapterFactory = adapterFactory;
    }

    public void run() {
        try {
            File folder = File.createTempFile("pror-", "");
            folder.delete();
            folder = new File(String.valueOf(folder.getAbsolutePath()) + "/");
            folder.mkdir();
            String createHtmlContent = ProrEditorUtil.createHtmlContent(this.spec, this.editingDomain, this.adapterFactory);
            File htmlFile = new File(folder, "pror.html");
            FileWriter writer = new FileWriter(htmlFile);
            writer.write(createHtmlContent);
            writer.close();
            htmlFile.deleteOnExit();
            Program.launch((String)htmlFile.toURI().toString());
            System.out.println("Launched: " + htmlFile.toURI());
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Output produced", (String)"Switch to your web browser to see the output.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

