/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.editor.agilegrid;

import java.util.ArrayList;
import java.util.Collection;
import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.CellEditor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.rmf.reqif10.AttributeValueEnumeration;
import org.eclipse.rmf.reqif10.DatatypeDefinitionEnumeration;
import org.eclipse.rmf.reqif10.EnumValue;
import org.eclipse.rmf.reqif10.ReqIF10Package;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ProrEnumerationSingleValueCellEditor
extends CellEditor {
    private final AdapterFactory adapterFactory;
    private ArrayList<EnumValue> itemList;
    private final EditingDomain editingDomain;
    private AttributeValueEnumeration attributeValue;
    private SpecElementWithAttributes parent;

    public ProrEnumerationSingleValueCellEditor(AgileGrid agileGrid, DatatypeDefinitionEnumeration dde, SpecElementWithAttributes parent, EditingDomain editingDomain, AdapterFactory adapterFactory) {
        super(agileGrid);
        this.editingDomain = editingDomain;
        this.adapterFactory = adapterFactory;
        this.parent = parent;
        Combo combo = (Combo)this.getControl();
        String[] items = this.populateItemList(dde);
        combo.setItems(items);
    }

    public Control createControl(AgileGrid agileGrid) {
        return new Combo((Composite)agileGrid, 12);
    }

    private String[] populateItemList(DatatypeDefinitionEnumeration dde) {
        this.itemList = new ArrayList();
        String[] list = new String[dde.getSpecifiedValues().size()];
        int i = 0;
        while (i < dde.getSpecifiedValues().size()) {
            EnumValue enumValue = (EnumValue)dde.getSpecifiedValues().get(i);
            this.itemList.add(enumValue);
            IItemLabelProvider itemProvider = (IItemLabelProvider)this.adapterFactory.adapt((Notifier)enumValue, IItemLabelProvider.class);
            list[i] = itemProvider.getText((Object)enumValue);
            ++i;
        }
        return list;
    }

    protected Object doGetValue() {
        int selectedIndex = ((Combo)this.getControl()).getSelectionIndex();
        CompoundCommand cmd = new CompoundCommand("Set Enumeration"){

            public Collection<?> getAffectedObjects() {
                ArrayList<SpecElementWithAttributes> list = new ArrayList<SpecElementWithAttributes>();
                list.add(ProrEnumerationSingleValueCellEditor.this.parent);
                return list;
            }
        };
        if (this.attributeValue.eContainer() == null) {
            cmd.append(AddCommand.create((EditingDomain)this.editingDomain, (Object)this.parent, (Object)ReqIF10Package.Literals.SPEC_ELEMENT_WITH_ATTRIBUTES__VALUES, (Object)this.attributeValue));
        }
        cmd.append(RemoveCommand.create((EditingDomain)this.editingDomain, (Object)this.attributeValue, (Object)ReqIF10Package.Literals.ATTRIBUTE_VALUE_ENUMERATION__VALUES, (Collection)this.attributeValue.getValues()));
        if (selectedIndex != -1) {
            cmd.append(AddCommand.create((EditingDomain)this.editingDomain, (Object)this.attributeValue, (Object)ReqIF10Package.Literals.ATTRIBUTE_VALUE_ENUMERATION__VALUES, (Object)this.itemList.get(selectedIndex)));
        }
        this.editingDomain.getCommandStack().execute((Command)cmd);
        return this.attributeValue;
    }

    protected void doSetValue(Object value) {
        if (value instanceof AttributeValueEnumeration) {
            this.attributeValue = (AttributeValueEnumeration)value;
            EList list = ((AttributeValueEnumeration)value).getValues();
            if (list.size() > 0) {
                int index = this.itemList.indexOf(list.get(0));
                ((Combo)this.getControl()).select(index);
            }
        }
    }
}

