/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.editor.agilegrid;

import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.SpecRelation;

public abstract class ProrRow {
    final int level;
    final int row;

    private ProrRow(int row, int level) {
        this.row = row;
        this.level = level;
    }

    public abstract SpecElementWithAttributes getSpecElement();

    public String toString() {
        return "Row " + this.row + " Level " + this.level + " : " + this.getSpecElement();
    }

    public int getLevel() {
        return this.level;
    }

    public int getRow() {
        return this.row;
    }

    public static ProrRow createProrRow(Object element, int row, int level) {
        if (row < 0 || level < 0) {
            throw new IndexOutOfBoundsException("row : " + row + " and level: " + level + " have to be >= 0");
        }
        if (element instanceof SpecRelation) {
            return new ProrRowSpecRelation((SpecRelation)element, row, level);
        }
        if (element instanceof SpecHierarchy) {
            return new ProrRowSpecHierarchy((SpecHierarchy)element, row, level);
        }
        if (element == null) {
            throw new NullPointerException();
        }
        throw new IllegalArgumentException(element + " have to be a SpecHierarchy object or a SpecRelation object ");
    }

    /* synthetic */ ProrRow(int n, int n2, ProrRow prorRow) {
        this(n, n2);
    }

    public static class ProrRowSpecHierarchy
    extends ProrRow {
        SpecHierarchy element;

        private ProrRowSpecHierarchy(SpecHierarchy element, int row, int level) {
            super(row, level, null);
            this.element = element;
        }

        public SpecHierarchy getSpecHierarchy() {
            return this.element;
        }

        public SpecElementWithAttributes getSpecElement() {
            return this.element.getObject();
        }
    }

    public static class ProrRowSpecRelation
    extends ProrRow {
        SpecRelation element;

        private ProrRowSpecRelation(SpecRelation element, int row, int level) {
            super(row, level, null);
            this.element = element;
        }

        public SpecElementWithAttributes getSpecElement() {
            return this.element;
        }
    }
}

