/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.ReqIF10Factory;
import org.eclipse.rmf.reqif10.ReqIFToolExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReqIFToolExtensionUtil {
    public static List<ReqIFToolExtension> getReqIFToolExtensions(ReqIF reqIF) {
        Object reqIFToolExtensions = reqIF != null ? reqIF.getToolExtensions() : new ArrayList();
        return reqIFToolExtensions;
    }

    public static List<EObject> getToolExtensionsByNsURI(ReqIF reqIF, String nsURI) {
        List<ReqIFToolExtension> reqIFToolExtensions = ReqIFToolExtensionUtil.getReqIFToolExtensions(reqIF);
        ArrayList<EObject> toolExtensions = new ArrayList<EObject>();
        for (ReqIFToolExtension reqIFToolExtension : reqIFToolExtensions) {
            FeatureMap featureMap = reqIFToolExtension.getAny();
            FeatureMap.ValueListIterator iterator = featureMap.valueListIterator();
            while (iterator.hasNext()) {
                EObject eObject;
                Object value = iterator.next();
                if (value == null || !(value instanceof EObject) || !(eObject = (EObject)value).eClass().getEPackage().getNsURI().equals(nsURI)) continue;
                toolExtensions.add(eObject);
            }
        }
        return toolExtensions;
    }

    public static <T> List<T> getToolExtensionsByType(ReqIF reqIF, EClassifier type) {
        List<ReqIFToolExtension> reqIFToolExtensions = ReqIFToolExtensionUtil.getReqIFToolExtensions(reqIF);
        ArrayList toolExtensions = new ArrayList();
        for (ReqIFToolExtension reqIFToolExtension : reqIFToolExtensions) {
            FeatureMap featureMap = reqIFToolExtension.getAny();
            FeatureMap.ValueListIterator iterator = featureMap.valueListIterator();
            while (iterator.hasNext()) {
                Object value = iterator.next();
                if (value == null || !type.isInstance(value)) continue;
                toolExtensions.add(value);
            }
        }
        return toolExtensions;
    }

    public static void addToolExtension(ReqIF reqIF, EObject toolExtension) {
        if (reqIF != null && toolExtension != null) {
            ReqIFToolExtension reqIFToolExtension = ReqIF10Factory.eINSTANCE.createReqIFToolExtension();
            reqIF.getToolExtensions().add((Object)reqIFToolExtension);
            BasicExtendedMetaData extendedMetaData = new BasicExtendedMetaData();
            EStructuralFeature toolExtensionFeature = extendedMetaData.demandFeature(toolExtension.eClass().getEPackage().getNsURI(), "root", true, true);
            reqIFToolExtension.eSet(toolExtensionFeature, (Object)toolExtension);
        }
    }

    public static Command getAddToolExtensionCommand(final ReqIF reqIF, final EObject toolExtension) {
        AbstractCommand command = new AbstractCommand(){
            ReqIFToolExtension reqIFToolExtension;
            EStructuralFeature toolExtensionFeature;

            public void execute() {
                this.reqIFToolExtension = ReqIF10Factory.eINSTANCE.createReqIFToolExtension();
                reqIF.getToolExtensions().add((Object)this.reqIFToolExtension);
                this.reqIFToolExtension.eSet(this.toolExtensionFeature, (Object)toolExtension);
            }

            public void redo() {
                reqIF.getToolExtensions().add((Object)this.reqIFToolExtension);
                this.reqIFToolExtension.eSet(this.toolExtensionFeature, (Object)toolExtension);
            }

            public void undo() {
                reqIF.getToolExtensions().remove((Object)this.reqIFToolExtension);
            }

            public Collection<?> getAffectedObjects() {
                return Arrays.asList(this.reqIFToolExtension, toolExtension);
            }

            protected boolean prepare() {
                boolean prepare;
                if (reqIF != null && toolExtension != null) {
                    BasicExtendedMetaData extendedMetaData = new BasicExtendedMetaData();
                    this.toolExtensionFeature = extendedMetaData.demandFeature(toolExtension.eClass().getEPackage().getNsURI(), "root", true, true);
                    prepare = true;
                } else {
                    prepare = false;
                }
                return prepare;
            }
        };
        return command;
    }
}

