/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.editor.agilegrid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.agilemore.agilegrid.AbstractContentProvider;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.reqif10.SpecRelation;
import org.eclipse.rmf.reqif10.Specification;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;
import org.eclipse.rmf.reqif10.pror.configuration.Column;
import org.eclipse.rmf.reqif10.pror.configuration.ProrSpecViewConfiguration;
import org.eclipse.rmf.reqif10.pror.editor.agilegrid.ProrRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProrAgileGridContentProvider
extends AbstractContentProvider {
    private final Specification root;
    private final ProrSpecViewConfiguration specViewConfig;
    private ArrayList<ProrRow> cache = null;
    private boolean showSpecRelations;

    public ProrAgileGridContentProvider(Specification specification, ProrSpecViewConfiguration specViewConfig) {
        this.root = specification;
        this.specViewConfig = specViewConfig;
        specification.eAdapters().add((Object)new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                if (notification.getEventType() == 3 || notification.getEventType() == 5 || notification.getEventType() == 7 || notification.getEventType() == 4 || notification.getEventType() == 6 || notification.getEventType() == 1 || notification.getEventType() == 2) {
                    ProrAgileGridContentProvider.this.flushCache();
                }
            }
        });
    }

    public Object doGetContentAt(int row, int col) throws IndexOutOfBoundsException {
        if (row >= this.getCache().size()) {
            throw new IndexOutOfBoundsException("Row does not exist: " + row);
        }
        SpecElementWithAttributes element = this.getCache().get(row).getSpecElement();
        if (col == this.specViewConfig.getColumns().size()) {
            return element instanceof SpecElementWithAttributes ? element : null;
        }
        if (col <= this.specViewConfig.getColumns().size()) {
            return this.getValueForColumn(element, row, col);
        }
        throw new IndexOutOfBoundsException("Column does not exist: " + col);
    }

    public void doSetContentAt(int row, int col, Object newValue) {
    }

    public void setShowSpecRelations(boolean status) {
        this.showSpecRelations = status;
        this.flushCache();
    }

    public boolean getShowSpecRelations() {
        return this.showSpecRelations;
    }

    ProrRow getProrRow(int row) {
        return this.getCache().get(row);
    }

    private void flushCache() {
        this.cache = null;
    }

    private ArrayList<ProrRow> getCache() {
        if (this.cache == null) {
            ArrayList<ProrRow> tmpCache = new ArrayList<ProrRow>();
            this.recurseSpecHierarchyForRow(0, 0, (List<SpecHierarchy>)this.root.getChildren(), tmpCache);
            this.cache = tmpCache;
        }
        return this.cache;
    }

    private int recurseSpecHierarchyForRow(int current, int depth, List<SpecHierarchy> elements, ArrayList<ProrRow> tmpCache) {
        for (SpecHierarchy element : elements) {
            int result;
            tmpCache.add(current, ProrRow.createProrRow(element, current, depth));
            for (SpecRelation specRelation : this.getSpecRelationsFor(element)) {
                tmpCache.add(++current, ProrRow.createProrRow(specRelation, current, depth + 1));
            }
            ++current;
            current = result = this.recurseSpecHierarchyForRow(current, depth + 1, (List<SpecHierarchy>)element.getChildren(), tmpCache);
        }
        return current;
    }

    AttributeValue getValueForColumn(SpecElementWithAttributes element, int row, int col) {
        if (element == null) {
            return null;
        }
        if (col >= this.specViewConfig.getColumns().size()) {
            return null;
        }
        String label = ((Column)this.specViewConfig.getColumns().get(col)).getLabel();
        return ReqIF10Util.getAttributeValueForLabel((SpecElementWithAttributes)element, (String)label);
    }

    private List<SpecRelation> getSpecRelationsFor(SpecHierarchy specHierarchy) {
        if (!this.showSpecRelations || specHierarchy.getObject() == null) {
            return Collections.emptyList();
        }
        SpecObject source = specHierarchy.getObject();
        ReqIF reqif = ReqIF10Util.getReqIF((Object)source);
        if (reqif == null) {
            return Collections.emptyList();
        }
        ArrayList<SpecRelation> list = new ArrayList<SpecRelation>();
        for (SpecRelation relation : reqif.getCoreContent().getSpecRelations()) {
            if (!source.equals(relation.getSource())) continue;
            list.add(relation);
        }
        return list;
    }

    void updateElement(SpecElementWithAttributes element) {
        this.recurseUpdateElement(0, element, (List)this.root.getChildren());
        this.flushCache();
    }

    private int recurseUpdateElement(int row, SpecElementWithAttributes element, List list) {
        for (Object entry : list) {
            ArrayList<SpecRelation> children = new ArrayList<SpecRelation>();
            boolean refresh = false;
            if (element instanceof SpecRelation && element.equals(entry)) {
                refresh = true;
            } else if (entry instanceof SpecHierarchy) {
                SpecHierarchy specHierarchy = (SpecHierarchy)entry;
                children.addAll((Collection<SpecRelation>)specHierarchy.getChildren());
                if (this.showSpecRelations) {
                    children.addAll(this.getSpecRelationsFor(specHierarchy));
                }
                if (element.equals(specHierarchy.getObject())) {
                    refresh = true;
                }
            }
            if (refresh) {
                this.firePropertyChange("content", row, 0, null, entry);
            }
            ++row;
            row = this.recurseUpdateElement(row, element, children);
        }
        return row;
    }

    public int getRowCount() {
        return this.getCache().size();
    }
}

