/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.editor.agilegrid;

import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.CellEditor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.Identifiable;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.pror.configuration.ProrPresentationConfiguration;
import org.eclipse.rmf.reqif10.pror.editor.agilegrid.AbstractProrCellEditorProvider;
import org.eclipse.rmf.reqif10.pror.editor.agilegrid.AgileCellEditorActionHandler;
import org.eclipse.rmf.reqif10.pror.editor.agilegrid.ProrAgileGridContentProvider;
import org.eclipse.rmf.reqif10.pror.editor.agilegrid.ProrRow;
import org.eclipse.rmf.reqif10.pror.editor.presentation.service.PresentationEditorInterface;
import org.eclipse.rmf.reqif10.pror.editor.presentation.service.PresentationServiceManager;
import org.eclipse.rmf.reqif10.pror.util.ConfigurationUtil;
import org.eclipse.rmf.reqif10.pror.util.ProrUtil;

public class ProrCellEditorProvider
extends AbstractProrCellEditorProvider {
    private final ProrAgileGridContentProvider contentProvider;
    private final AgileCellEditorActionHandler agileCellEditorActionHandler;

    public ProrCellEditorProvider(AgileGrid agileGrid, EditingDomain editingDomain, AdapterFactory adapterFactory, AgileCellEditorActionHandler agileCellEditorActionHandler) {
        super(agileGrid, adapterFactory, editingDomain);
        this.contentProvider = (ProrAgileGridContentProvider)agileGrid.getContentProvider();
        this.agileCellEditorActionHandler = agileCellEditorActionHandler;
    }

    protected AttributeValue getAttributeValue(int row, int col) {
        SpecElementWithAttributes specElement = this.contentProvider.getProrRow(row).getSpecElement();
        return this.contentProvider.getValueForColumn(specElement, row, col);
    }

    public Identifiable getAffectedElement(int row, int col) {
        ProrAgileGridContentProvider provider = (ProrAgileGridContentProvider)this.getAgileGrid().getContentProvider();
        ProrRow prorRow = provider.getProrRow(row);
        if (prorRow instanceof ProrRow.ProrRowSpecHierarchy) {
            return ((ProrRow.ProrRowSpecHierarchy)prorRow).getSpecHierarchy();
        }
        return prorRow.getSpecElement();
    }

    public CellEditor getCellEditor(int row, int col, Object hint) {
        ItemProviderAdapter ip;
        SpecElementWithAttributes specElement = this.contentProvider.getProrRow(row).getSpecElement();
        CellEditor cellEditor = null;
        AttributeValue av = this.getAttributeValue(row, col);
        ProrPresentationConfiguration config = ConfigurationUtil.getPresentationConfiguration((AttributeValue)av);
        if (config != null && (ip = ProrUtil.getItemProvider((AdapterFactory)this.adapterFactory, (Object)config)) instanceof PresentationEditorInterface) {
            cellEditor = ((PresentationEditorInterface)ip).getCellEditor(this.agileGrid, this.editingDomain, av, specElement, this.getAffectedElement(row, col));
        }
        if (cellEditor == null) {
            cellEditor = PresentationServiceManager.getDefaultCellEditor(this.agileGrid, this.editingDomain, this.adapterFactory, av, specElement, this.getAffectedElement(row, col));
        }
        if (cellEditor == null) {
            cellEditor = this.getDefaultCellEditor(av, specElement, this.getAffectedElement(row, col));
        }
        if (cellEditor != null) {
            this.agileCellEditorActionHandler.setActiveCellEditor(cellEditor);
        }
        return cellEditor;
    }

    public boolean canEdit(int row, int col) {
        ItemProviderAdapter ip;
        AttributeValue attrValue = this.getAttributeValue(row, col);
        if (attrValue == null) {
            return false;
        }
        ProrPresentationConfiguration config = ConfigurationUtil.getPresentationConfiguration((AttributeValue)attrValue);
        if (config != null && (ip = ProrUtil.getItemProvider((AdapterFactory)this.adapterFactory, (Object)config)) instanceof PresentationEditorInterface) {
            return ((PresentationEditorInterface)ip).canEdit();
        }
        return true;
    }
}

