/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.editor.agilegrid;

import java.math.BigInteger;
import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.ICellEditorValidator;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.pror.editor.agilegrid.ProrCellEditor;
import org.eclipse.rmf.reqif10.pror.util.ProrUtil;

public class ProrIntegerCellEditor
extends ProrCellEditor {
    private BigInteger min;
    private BigInteger max;

    public ProrIntegerCellEditor(AgileGrid agileGrid, SpecElementWithAttributes parent, EditingDomain editingDomain, Object affectedObject) {
        super(agileGrid, editingDomain, parent, affectedObject);
        this.setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                if (!(value instanceof String)) {
                    return null;
                }
                try {
                    BigInteger num = new BigInteger(value.toString());
                    if (ProrIntegerCellEditor.this.min != null && num.compareTo(ProrIntegerCellEditor.this.min) < 0 || ProrIntegerCellEditor.this.max != null && num.compareTo(ProrIntegerCellEditor.this.max) > 0) {
                        return "Value must be in [" + ProrIntegerCellEditor.this.min + ".." + ProrIntegerCellEditor.this.max + "]";
                    }
                }
                catch (NumberFormatException e) {
                    return e.getLocalizedMessage();
                }
                return null;
            }
        });
    }

    protected Object doGetValue() {
        try {
            BigInteger value = new BigInteger(this.text.getText());
            ProrUtil.setTheValue((AttributeValue)this.attributeValue, (Object)value, (SpecElementWithAttributes)this.parent, (Object)this.affectedObject, (EditingDomain)this.editingDomain);
        }
        catch (NumberFormatException numberFormatException) {}
        return this.attributeValue;
    }

    public void setRange(BigInteger min, BigInteger max) {
        this.min = min;
        this.max = max;
    }
}

