/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core.connection;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.connection.AbstractResponse;
import org.eclipse.update.internal.core.connection.TooManyOpenConnectionsException;

public class HttpResponse
extends AbstractResponse {
    protected URL url;
    protected InputStream in;
    protected long lastModified;
    protected long offset;

    protected HttpResponse(URL url) {
        this.url = url;
    }

    public InputStream getInputStream() throws IOException {
        if (this.in == null && this.url != null) {
            if (this.connection == null || this.offset > 0L) {
                this.connection = this.url.openConnection();
            }
            if (this.offset > 0L) {
                this.connection.setRequestProperty("Range", "bytes=" + this.offset + "-");
            }
            try {
                this.in = new MonitoringInputStream(this.connection.getInputStream(), this.connection);
            }
            catch (IOException ioe) {
                this.connection = null;
                throw ioe;
            }
            this.checkOffset();
        }
        return this.in;
    }

    public void close() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {}
            this.in = null;
        }
        if (this.connection != null) {
            ((HttpURLConnection)this.connection).disconnect();
            this.connection = null;
        }
    }

    public InputStream getInputStream(IProgressMonitor monitor) throws IOException, CoreException, TooManyOpenConnectionsException {
        if (this.in == null && this.url != null) {
            if (this.connection == null || this.offset > 0L) {
                this.connection = this.url.openConnection();
            }
            if (this.offset > 0L) {
                this.connection.setRequestProperty("Range", "bytes=" + this.offset + "-");
            }
            if (monitor != null) {
                try {
                    this.in = new MonitoringInputStream(this.openStreamWithCancel(this.connection, monitor), this.connection);
                }
                catch (IOException ioe) {
                    this.connection = null;
                    throw ioe;
                }
            }
            try {
                this.in = new MonitoringInputStream(this.connection.getInputStream(), this.connection);
            }
            catch (IOException ioe) {
                this.connection = null;
                throw ioe;
            }
            this.checkOffset();
            if (this.connection != null) {
                this.lastModified = this.connection.getLastModified();
            }
        }
        return this.in;
    }

    public long getContentLength() {
        if (this.connection != null) {
            return this.connection.getContentLength();
        }
        return 0L;
    }

    public int getStatusCode() {
        if (this.connection == null) {
            try {
                this.connection = this.url.openConnection();
            }
            catch (IOException iOException) {}
        }
        if (this.connection != null) {
            try {
                return ((HttpURLConnection)this.connection).getResponseCode();
            }
            catch (IOException e) {
                UpdateCore.warn("", e);
            }
        }
        return 200;
    }

    public String getStatusMessage() {
        if (this.connection != null) {
            try {
                return ((HttpURLConnection)this.connection).getResponseMessage();
            }
            catch (IOException e) {
                UpdateCore.warn("", e);
            }
        }
        return "";
    }

    public long getLastModified() {
        if (this.lastModified == 0L) {
            if (this.connection == null) {
                try {
                    this.connection = this.url.openConnection();
                }
                catch (IOException iOException) {}
            }
            if (this.connection != null) {
                this.lastModified = this.connection.getLastModified();
            }
        }
        return this.lastModified;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    private void checkOffset() throws IOException {
        if (this.offset == 0L) {
            return;
        }
        String range = this.connection.getHeaderField("Content-Range");
        if (range == null) {
            throw new IOException(Messages.HttpResponse_rangeExpected);
        }
        if (!range.startsWith("bytes " + this.offset + "-")) {
            throw new IOException(Messages.HttpResponse_wrongRange);
        }
    }

    private class MonitoringInputStream
    extends FilterInputStream {
        private URLConnection connection;

        public MonitoringInputStream(InputStream in, URLConnection connection) {
            super(in);
            this.connection = connection;
        }

        public int available() throws IOException {
            try {
                return this.in != null ? super.available() : 0;
            }
            catch (IOException ioe) {
                this.connection = null;
                throw ioe;
            }
        }

        public void close() throws IOException {
            try {
                if (this.in != null) {
                    super.close();
                }
                if (this.connection instanceof HttpURLConnection) {
                    ((HttpURLConnection)this.connection).disconnect();
                }
            }
            catch (IOException ioe) {
                this.connection = null;
                throw ioe;
            }
        }

        public int read() throws IOException {
            try {
                return this.in != null ? super.read() : -1;
            }
            catch (IOException ioe) {
                this.connection = null;
                throw ioe;
            }
        }

        public synchronized void reset() throws IOException {
            try {
                if (this.in != null) {
                    super.reset();
                }
            }
            catch (IOException ioe) {
                this.connection = null;
                throw ioe;
            }
        }

        public int read(byte[] b) throws IOException {
            try {
                return this.in != null ? super.read(b) : -1;
            }
            catch (IOException ioe) {
                this.connection = null;
                throw ioe;
            }
        }

        public int read(byte[] b, int off, int len) throws IOException {
            try {
                return this.in != null ? super.read(b, off, len) : -1;
            }
            catch (IOException ioe) {
                this.connection = null;
                throw ioe;
            }
        }

        public long skip(long n) throws IOException {
            try {
                return this.in != null ? super.skip(n) : 0L;
            }
            catch (IOException ioe) {
                this.connection = null;
                throw ioe;
            }
        }
    }
}

