/*
 * Decompiled with CFR 0.152.
 */
package org.agilemore.agilegrid;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.agilemore.agilegrid.AgileGridEditor;
import org.agilemore.agilegrid.Cell;
import org.agilemore.agilegrid.CellColumn;
import org.agilemore.agilegrid.CellDoubleClickEvent;
import org.agilemore.agilegrid.CellNavigationStrategy;
import org.agilemore.agilegrid.CellRow;
import org.agilemore.agilegrid.CellSelectionManager;
import org.agilemore.agilegrid.DefaultCellRendererProvider;
import org.agilemore.agilegrid.DefaultContentProvider;
import org.agilemore.agilegrid.DefaultLayoutAdvisor;
import org.agilemore.agilegrid.EditorActivationEvent;
import org.agilemore.agilegrid.EditorActivationStrategy;
import org.agilemore.agilegrid.ICellDoubleClickListener;
import org.agilemore.agilegrid.ICellEditorProvider;
import org.agilemore.agilegrid.ICellNavigationStrategy;
import org.agilemore.agilegrid.ICellRenderer;
import org.agilemore.agilegrid.ICellRendererProvider;
import org.agilemore.agilegrid.ICellResizeListener;
import org.agilemore.agilegrid.ICompositorStrategy;
import org.agilemore.agilegrid.IContentProvider;
import org.agilemore.agilegrid.IEditorActivationListener;
import org.agilemore.agilegrid.IFocusCellChangedListener;
import org.agilemore.agilegrid.ILayoutAdvisor;
import org.agilemore.agilegrid.ISelectionChangedListener;
import org.agilemore.agilegrid.SWTResourceManager;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;

public class AgileGrid
extends Canvas {
    public static final int ABOVE = 1;
    public static final int BELOW = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    private AgileGridEditor agileGridEditor;
    private CellSelectionManager cellSelectionManager;
    private ICellRendererProvider cellRendererProvider;
    private ILayoutAdvisor layoutAdvisor;
    private IContentProvider contentProvider;
    protected int topRow;
    protected int leftColumn;
    private Cell pressedCell;
    private boolean isCaptured;
    private Point mousePoint;
    private int style = 0;
    private int rowsVisible;
    private int rowsFullyVisible;
    private int columnsVisible;
    private int columnsFullyVisible;
    private int linePixels = 1;
    private int resizeRowIndex;
    private int resizeRowTop;
    private int resizeColumnIndex;
    private int resizeColumnLeft;
    private int resizeAreaSize = 4;
    private ArrayList<ICellDoubleClickListener> cellDoubleClickListeners;
    private ArrayList<ICellResizeListener> cellResizeListeners;
    private PropertyChangeListener propertyChangeListener;
    private Point defaultCursorSize;
    private Cursor defaultCursor;
    private Cursor defaultRowResizeCursor;
    private Cursor defaultColumnResizeCursor;
    private Cursor rowResizeCursor;
    private Cursor columnResizeCursor;
    private String nativeTooltip;

    public AgileGrid(Composite parent, int style) {
        super(parent, 0x140000 | style);
        this.style = style;
        this.topRow = 0;
        this.leftColumn = 0;
        this.rowsVisible = 0;
        this.rowsFullyVisible = 0;
        this.columnsVisible = 0;
        this.columnsFullyVisible = 0;
        this.resizeColumnIndex = Integer.MIN_VALUE;
        this.resizeRowIndex = Integer.MIN_VALUE;
        this.resizeRowTop = Integer.MIN_VALUE;
        this.resizeColumnLeft = Integer.MIN_VALUE;
        this.pressedCell = Cell.NULLCELL;
        this.isCaptured = false;
        this.mousePoint = null;
        this.cellSelectionManager = this.createFocusCellManager();
        this.cellRendererProvider = this.createCellRendererProvider();
        this.agileGridEditor = this.createAgileGridEditor();
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if (propertyName == "columnCount") {
                    int columnCount = (Integer)evt.getNewValue();
                    Cell focusCell = AgileGrid.this.getFocusCell();
                    if (focusCell != null && focusCell.column >= columnCount) {
                        AgileGrid.this.focusCell(new Cell(AgileGrid.this, focusCell.row, columnCount - 1));
                    }
                    AgileGrid.this.redraw();
                } else if (propertyName == "columnWidth") {
                    Map map = (Map)evt.getNewValue();
                    Iterator keyIter = map.keySet().iterator();
                    int columnIndex = Integer.MIN_VALUE;
                    while (keyIter.hasNext()) {
                        columnIndex = (Integer)keyIter.next();
                        if (columnIndex < AgileGrid.this.leftColumn || columnIndex >= AgileGrid.this.leftColumn + AgileGrid.this.columnsVisible) continue;
                        AgileGrid.this.redraw();
                        break;
                    }
                } else if (propertyName == "leftHeaderLabel") {
                    Map map = (Map)evt.getNewValue();
                    Iterator keyIter = map.keySet().iterator();
                    int rowIndex = Integer.MIN_VALUE;
                    while (keyIter.hasNext()) {
                        rowIndex = (Integer)keyIter.next();
                        if (rowIndex < AgileGrid.this.topRow || rowIndex >= AgileGrid.this.topRow + AgileGrid.this.rowsVisible) continue;
                        Rectangle rect = AgileGrid.this.getLeftHeaderArea();
                        AgileGrid.this.redraw(rect.x, rect.y, rect.width, rect.height, true);
                        break;
                    }
                } else if (propertyName == "leftHeaderVisible") {
                    AgileGrid.this.redraw();
                } else if (propertyName == "leftHeaderWidth") {
                    AgileGrid.this.redraw();
                } else if (propertyName == "rowCount") {
                    int rowCount = (Integer)evt.getNewValue();
                    Cell focusCell = AgileGrid.this.getFocusCell();
                    if (focusCell != null && focusCell.row >= rowCount) {
                        AgileGrid.this.focusCell(new Cell(AgileGrid.this, rowCount - 1, focusCell.column));
                    }
                    AgileGrid.this.redraw();
                } else if (propertyName == "rowHeight") {
                    Map map = (Map)evt.getNewValue();
                    Iterator keyIter = map.keySet().iterator();
                    int rowIndex = Integer.MIN_VALUE;
                    while (keyIter.hasNext()) {
                        rowIndex = (Integer)keyIter.next();
                        if (rowIndex < AgileGrid.this.topRow || rowIndex >= AgileGrid.this.topRow + AgileGrid.this.rowsVisible) continue;
                        AgileGrid.this.redraw();
                        break;
                    }
                } else if (propertyName == "topHeaderHeight") {
                    AgileGrid.this.redraw();
                } else if (propertyName == "topHeaderLabel") {
                    Map map = (Map)evt.getNewValue();
                    Iterator keyIter = map.keySet().iterator();
                    int columnIndex = Integer.MIN_VALUE;
                    while (keyIter.hasNext()) {
                        columnIndex = (Integer)keyIter.next();
                        if (columnIndex < AgileGrid.this.leftColumn || columnIndex >= AgileGrid.this.leftColumn + AgileGrid.this.columnsVisible) continue;
                        Rectangle rect = AgileGrid.this.getTopHeaderArea();
                        AgileGrid.this.redraw(rect.x, rect.y, rect.width, rect.height, true);
                        break;
                    }
                } else if (propertyName == "topHeaderVisible") {
                    AgileGrid.this.redraw();
                } else if (propertyName == "content") {
                    Map map = (Map)evt.getNewValue();
                    Iterator keyIter = map.keySet().iterator();
                    ArrayList<Cell> cellList = new ArrayList<Cell>();
                    while (keyIter.hasNext()) {
                        cellList.add((Cell)keyIter.next());
                    }
                    if (cellList.size() > 0) {
                        AgileGrid.this.redrawCells(cellList.toArray(new Cell[0]));
                    }
                }
            }
        };
        this.layoutAdvisor = this.createLayoutAdvisor();
        this.layoutAdvisor.addPropertyChangeListener(this.propertyChangeListener);
        this.contentProvider = this.createContentProvider();
        this.contentProvider.addPropertyChangeListener(this.propertyChangeListener);
        this.cellDoubleClickListeners = new ArrayList(7);
        this.cellResizeListeners = new ArrayList(7);
        this.hookListeners();
        this.nativeTooltip = super.getToolTipText();
        super.setToolTipText("");
        Display display = this.getDisplay();
        this.defaultRowResizeCursor = new Cursor((Device)display, 7);
        this.defaultColumnResizeCursor = new Cursor((Device)display, 9);
        if ((this.style & 0x700) == 1792) {
            this.addListener(11, new Listener(){

                public void handleEvent(Event event) {
                    AgileGrid.this.updateScrollbarVisibility();
                }
            });
            this.addCellResizeListener(new ICellResizeListener(){

                @Override
                public void rowResized(int row, int newHeight) {
                    AgileGrid.this.updateScrollbarVisibility();
                }

                @Override
                public void columnResized(int col, int newWidth) {
                    AgileGrid.this.updateScrollbarVisibility();
                }
            });
        }
    }

    public void dispose() {
        this.checkWidget();
        if (this.defaultCursor != null) {
            this.defaultCursor.dispose();
        }
        if (this.defaultRowResizeCursor != null) {
            this.defaultRowResizeCursor.dispose();
        }
        if (this.defaultColumnResizeCursor != null) {
            this.defaultColumnResizeCursor.dispose();
        }
        if (this.rowResizeCursor != null) {
            this.rowResizeCursor.dispose();
        }
        if (this.columnResizeCursor != null) {
            this.columnResizeCursor.dispose();
        }
        SWTResourceManager.dispose();
        super.dispose();
    }

    protected void hookListeners() {
        ScrollBar horizontalBar;
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                AgileGrid.this.onPaint(event);
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                AgileGrid.this.redraw();
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                AgileGrid.this.onMouseDown(e);
            }

            public void mouseUp(MouseEvent e) {
                AgileGrid.this.onMouseUp(e);
            }

            public void mouseDoubleClick(MouseEvent e) {
                AgileGrid.this.onMouseDoubleClick(e);
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                AgileGrid.this.onMouseMove(e);
            }
        });
        this.addFocusListener(new FocusListener(){
            private Cell[] oldSelection;

            public void focusGained(FocusEvent e) {
                if (!AgileGrid.this.isShowSelectionWithoutFocus() && this.oldSelection != null) {
                    AgileGrid.this.cellSelectionManager.selectCells(this.oldSelection);
                    AgileGrid.this.redrawCells(this.oldSelection);
                    this.oldSelection = null;
                }
            }

            public void focusLost(FocusEvent e) {
                if (!AgileGrid.this.isShowSelectionWithoutFocus()) {
                    this.oldSelection = AgileGrid.this.cellSelectionManager.getCellSelection();
                    AgileGrid.this.cellSelectionManager.clearSelection();
                    if (this.oldSelection != null) {
                        AgileGrid.this.redrawCells(this.oldSelection);
                    }
                }
            }
        });
        TooltipListener tooltipListener = new TooltipListener();
        this.addListener(12, tooltipListener);
        this.addListener(1, tooltipListener);
        this.addListener(3, tooltipListener);
        this.addListener(8, tooltipListener);
        this.addListener(5, tooltipListener);
        this.addListener(32, tooltipListener);
        this.addListener(7, tooltipListener);
        final ScrollBar verticalBar = this.getVerticalBar();
        if (verticalBar != null) {
            verticalBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int oldTopRow = AgileGrid.this.topRow;
                    AgileGrid.this.topRow = verticalBar.getSelection();
                    int totalRowCount = AgileGrid.this.layoutAdvisor.getRowCount();
                    if (AgileGrid.this.topRow + AgileGrid.this.rowsFullyVisible - 1 >= totalRowCount) {
                        AgileGrid.this.topRow = totalRowCount - AgileGrid.this.columnsFullyVisible;
                    }
                    if (oldTopRow != AgileGrid.this.topRow) {
                        AgileGrid.this.redraw();
                    }
                }
            });
            verticalBar.addListener(13, (Listener)tooltipListener);
        }
        if ((horizontalBar = this.getHorizontalBar()) != null) {
            horizontalBar.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int oldLeftCol = AgileGrid.this.leftColumn;
                    AgileGrid.this.leftColumn = horizontalBar.getSelection();
                    int totalColumnCount = AgileGrid.this.layoutAdvisor.getColumnCount();
                    if (AgileGrid.this.leftColumn + AgileGrid.this.columnsFullyVisible - 1 >= totalColumnCount) {
                        AgileGrid.this.leftColumn = totalColumnCount - AgileGrid.this.columnsFullyVisible;
                    }
                    if (oldLeftCol != AgileGrid.this.leftColumn) {
                        AgileGrid.this.redraw();
                    }
                }
            });
            horizontalBar.addListener(13, (Listener)tooltipListener);
        }
    }

    private Rectangle getContentArea() {
        Rectangle clientArea = this.getClientArea();
        Rectangle rightMargin = this.getRightMargin();
        Rectangle bottomMargin = this.getBottomMargin();
        if (rightMargin.width > 0) {
            clientArea.width -= rightMargin.width;
        }
        if (bottomMargin.height > 0) {
            clientArea.height -= bottomMargin.height;
        }
        int x = this.getFixedWidth();
        int y = this.getFixedHeight();
        int width = clientArea.x + clientArea.width - x;
        int height = clientArea.x + clientArea.height - y;
        return new Rectangle(x, y, width, height);
    }

    private Rectangle getTopHeaderArea() {
        Rectangle clientArea = this.getClientArea();
        Rectangle rightMargin = this.getRightMargin();
        if (rightMargin.width > 0) {
            clientArea.width -= rightMargin.width;
        }
        int x = this.linePixels;
        if (this.layoutAdvisor.isLeftHeaderVisible()) {
            x += this.layoutAdvisor.getLeftHeaderWidth();
            x += this.linePixels;
        }
        int y = this.linePixels;
        int width = clientArea.x + clientArea.width - x;
        int height = this.layoutAdvisor.getTopHeaderHeight();
        return new Rectangle(x, y, width += this.linePixels, height += this.linePixels);
    }

    private Rectangle getLeftHeaderArea() {
        Rectangle clientArea = this.getClientArea();
        Rectangle bottomMargin = this.getBottomMargin();
        if (bottomMargin.height > 0) {
            clientArea.height -= bottomMargin.height;
        }
        int x = this.linePixels;
        int y = this.linePixels;
        if (this.layoutAdvisor.isTopHeaderVisible()) {
            y += this.layoutAdvisor.getTopHeaderHeight();
            y += this.linePixels;
        }
        int width = this.layoutAdvisor.getLeftHeaderWidth();
        int height = clientArea.y + clientArea.height - y;
        return new Rectangle(x, y, width += this.linePixels, height += this.linePixels);
    }

    private Rectangle getFixedRowScrollableArea() {
        if (this.layoutAdvisor.getFixedRowCount() <= 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle clientArea = this.getClientArea();
        Rectangle rightMargin = this.getRightMargin();
        if (rightMargin.width > 0) {
            clientArea.width -= rightMargin.width;
        }
        int x = this.linePixels;
        if (this.layoutAdvisor.isLeftHeaderVisible()) {
            x += this.layoutAdvisor.getLeftHeaderWidth();
            x += this.linePixels;
        }
        int i = 0;
        while (i < this.layoutAdvisor.getFixedColumnCount()) {
            x += this.getColumnWidth(i);
            x += this.linePixels;
            ++i;
        }
        int y = this.linePixels;
        if (this.layoutAdvisor.isTopHeaderVisible()) {
            y += this.layoutAdvisor.getTopHeaderHeight();
            y += this.linePixels;
        }
        int width = clientArea.x + clientArea.width - x;
        int height = 0;
        int i2 = 0;
        while (i2 < this.layoutAdvisor.getFixedRowCount()) {
            height += this.layoutAdvisor.getRowHeight(i2);
            height += this.linePixels;
            ++i2;
        }
        return new Rectangle(x, y, width, height);
    }

    private Rectangle getFixedColumnScrollableArea() {
        if (this.layoutAdvisor.getFixedColumnCount() <= 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle clientArea = this.getClientArea();
        Rectangle bottomMargin = this.getBottomMargin();
        if (bottomMargin.width > 0) {
            clientArea.height -= bottomMargin.height;
        }
        int y = this.linePixels;
        if (this.layoutAdvisor.isTopHeaderVisible()) {
            y += this.layoutAdvisor.getTopHeaderHeight();
            y += this.linePixels;
        }
        int i = 0;
        while (i < this.layoutAdvisor.getFixedRowCount()) {
            y += this.layoutAdvisor.getRowHeight(i);
            y += this.linePixels;
            ++i;
        }
        int x = this.linePixels;
        if (this.layoutAdvisor.isLeftHeaderVisible()) {
            x += this.layoutAdvisor.getLeftHeaderWidth();
            x += this.linePixels;
        }
        int height = clientArea.y + clientArea.height - y;
        int width = 0;
        int i2 = 0;
        while (i2 < this.layoutAdvisor.getFixedColumnCount()) {
            width += this.getColumnWidth(i2);
            width += this.linePixels;
            ++i2;
        }
        return new Rectangle(x, y, width, height);
    }

    private Rectangle getRightMargin() {
        int lastCol = this.layoutAdvisor.getColumnCount() - 1;
        if (this.leftColumn + this.columnsFullyVisible - 1 == lastCol) {
            Rectangle clientArea = this.getClientArea();
            int x = this.getColumnRight(lastCol);
            if (x + 1 + this.linePixels >= clientArea.x + clientArea.width) {
                return new Rectangle(0, 0, -1, -1);
            }
            int y = 0;
            int width = clientArea.x + clientArea.width - 1 - this.linePixels - x;
            int height = clientArea.height;
            return new Rectangle(x, y, width, height);
        }
        return new Rectangle(0, 0, -1, -1);
    }

    private Rectangle getBottomMargin() {
        int lastRow = this.layoutAdvisor.getRowCount() - 1;
        if (this.topRow + this.rowsFullyVisible - 1 == lastRow) {
            Rectangle clientArea = this.getClientArea();
            int y = this.getRowBottom(lastRow);
            if (y + 1 + this.linePixels >= clientArea.y + clientArea.height - 1) {
                return new Rectangle(0, 0, -1, -1);
            }
            int x = 0;
            int width = clientArea.width;
            int height = clientArea.y + clientArea.height - y - 1 - this.linePixels;
            return new Rectangle(x, y, width, height);
        }
        return new Rectangle(0, 0, -1, -1);
    }

    public void redrawCells(Cell[] cells) {
        if (cells.length <= 0) {
            return;
        }
        int style = this.getStyle();
        int startRow = Integer.MAX_VALUE;
        int startCol = Integer.MAX_VALUE;
        int endRow = Integer.MIN_VALUE;
        int endCol = Integer.MIN_VALUE;
        int lastRow = this.topRow + this.rowsVisible - 1;
        int lastCol = this.leftColumn + this.columnsVisible - 1;
        int fixedRowCount = this.layoutAdvisor.getFixedRowCount();
        int fixedColumnCount = this.layoutAdvisor.getFixedColumnCount();
        int i = 0;
        while (i < cells.length) {
            int k;
            startRow = Math.min(startRow, cells[i].row);
            startCol = Math.min(startCol, cells[i].column);
            endRow = Math.max(endRow, cells[i].row);
            endCol = Math.max(endCol, cells[i].column);
            if (cells[i] instanceof CellRow) {
                Cell[] overlappedCells;
                int j = 0;
                while (j < fixedColumnCount) {
                    overlappedCells = this.getOverlappedCell(new Cell(this, cells[i].row, j));
                    k = 0;
                    while (k < overlappedCells.length) {
                        endRow = Math.max(endRow, overlappedCells[k].row);
                        endCol = Math.max(endCol, overlappedCells[k].column);
                        ++k;
                    }
                    ++j;
                }
                j = this.leftColumn;
                while (j <= lastCol) {
                    overlappedCells = this.getOverlappedCell(new Cell(this, cells[i].row, j));
                    k = 0;
                    while (k < overlappedCells.length) {
                        endRow = Math.max(endRow, overlappedCells[k].row);
                        endCol = Math.max(endCol, overlappedCells[k].column);
                        ++k;
                    }
                    ++j;
                }
            } else if (cells[i] instanceof CellColumn) {
                int j = 0;
                while (j < fixedRowCount) {
                    Cell[] overlappedCells = this.getOverlappedCell(new Cell(this, j, cells[i].column));
                    k = 0;
                    while (k < overlappedCells.length) {
                        endRow = Math.max(endRow, overlappedCells[k].row);
                        endCol = Math.max(endCol, overlappedCells[k].column);
                        ++k;
                    }
                    ++j;
                }
                j = this.topRow;
                while (j <= lastRow) {
                    Cell[] overlappedCells = this.getOverlappedCell(new Cell(this, j, cells[i].column));
                    k = 0;
                    while (k < overlappedCells.length) {
                        endRow = Math.max(endRow, overlappedCells[k].row);
                        endCol = Math.max(endCol, overlappedCells[k].column);
                        ++k;
                    }
                    ++j;
                }
            } else {
                Cell[] overlappedCells = this.getOverlappedCell(cells[i]);
                int j = 0;
                while (j < overlappedCells.length) {
                    endRow = Math.max(endRow, overlappedCells[j].row);
                    endCol = Math.max(endCol, overlappedCells[j].column);
                    ++j;
                }
            }
            ++i;
        }
        if ((style & 0x10000000) != 0) {
            startRow = 0;
            endRow = lastRow;
        } else {
            if (startRow < 0) {
                startRow = 0;
            }
            if (startRow >= fixedRowCount && startRow < this.topRow) {
                startRow = this.topRow;
            }
            if (startRow > lastRow) {
                startRow = lastRow;
            }
            if (endRow < 0) {
                endRow = 0;
            }
            if (endRow > lastRow) {
                endRow = lastRow;
            }
            if (endRow >= fixedRowCount && endRow < this.topRow) {
                endRow = fixedRowCount - 1;
            }
        }
        if ((style & 0x8000000) != 0) {
            startCol = 0;
            endCol = lastCol;
        } else {
            if (startCol < 0) {
                startCol = 0;
            }
            if (startCol >= fixedColumnCount && startCol < this.leftColumn) {
                startCol = this.leftColumn;
            }
            if (startCol > lastCol) {
                startCol = lastCol;
            }
            if (endCol < 0) {
                endCol = 0;
            }
            if (endCol > lastCol) {
                endCol = lastCol;
            }
            if (endCol >= fixedColumnCount && endCol < this.leftColumn) {
                endCol = fixedColumnCount - 1;
            }
        }
        Cell validCell = this.getValidCell(startRow, startCol);
        Rectangle startRect = this.getCellRect(validCell.row, validCell.column);
        validCell = this.getValidCell(endRow, endCol);
        Rectangle endRect = this.getCellRect(validCell.row, validCell.column);
        Rectangle unionRect = startRect.union(endRect);
        this.redraw(unionRect.x, unionRect.y, unionRect.width, unionRect.height, true);
    }

    Cell[] getOverlappedCell(Cell cell) {
        Cell validCell = this.layoutAdvisor.mergeInto(cell.row, cell.column);
        if (!validCell.equals(cell)) {
            return new Cell[0];
        }
        int row = cell.row;
        int col = cell.column;
        int totalRowCount = this.layoutAdvisor.getRowCount();
        int totalColumnCount = this.layoutAdvisor.getColumnCount();
        HashSet<Cell> overlappedCells = new HashSet<Cell>();
        int spanRow = row + 1;
        while (this.getValidCell(spanRow, col).equals(cell) && spanRow < totalRowCount) {
            overlappedCells.add(new Cell(this, spanRow, col));
            ++spanRow;
        }
        int spanCol = col + 1;
        while (this.getValidCell(row, spanCol).equals(cell) && spanCol < totalColumnCount) {
            overlappedCells.add(new Cell(this, row, spanCol));
            ++spanCol;
        }
        return overlappedCells.toArray(new Cell[0]);
    }

    protected int getFixedWidth() {
        int width = this.linePixels;
        if (this.layoutAdvisor.isLeftHeaderVisible()) {
            width += this.layoutAdvisor.getLeftHeaderWidth();
            width += this.linePixels;
        }
        int i = 0;
        while (i < this.layoutAdvisor.getFixedColumnCount()) {
            width += this.getColumnWidth(i);
            width += this.linePixels;
            ++i;
        }
        return width;
    }

    protected int getColumnLeft(int column) {
        int x = this.linePixels;
        if (this.layoutAdvisor.isLeftHeaderVisible()) {
            if (column == -1) {
                return x;
            }
            x += this.layoutAdvisor.getLeftHeaderWidth();
            x += this.linePixels;
        } else if (column == -1) {
            return Integer.MIN_VALUE;
        }
        int fixedColumnCount = this.layoutAdvisor.getFixedColumnCount();
        if (column < fixedColumnCount) {
            int i = 0;
            while (i < column) {
                x += this.getColumnWidth(i);
                x += this.linePixels;
                ++i;
            }
            return x;
        }
        x = this.getFixedWidth();
        if (column >= fixedColumnCount && column < this.leftColumn) {
            int i = this.leftColumn - 1;
            while (i >= column) {
                x -= this.linePixels;
                x -= this.getColumnWidth(i);
                --i;
            }
            return x;
        }
        int i = this.leftColumn;
        while (i < column) {
            x += this.getColumnWidth(i);
            x += this.linePixels;
            ++i;
        }
        return x;
    }

    protected int getColumnRight(int column) {
        if (column < -1) {
            return Integer.MIN_VALUE;
        }
        int columnLeft = this.getColumnLeft(column);
        if (column == -1) {
            return columnLeft + this.layoutAdvisor.getLeftHeaderWidth() - 1;
        }
        return columnLeft + this.getColumnWidth(column) - 1;
    }

    protected int getRowBottom(int row) {
        if (row < -1) {
            return Integer.MIN_VALUE;
        }
        int rowTop = this.getRowTop(row);
        if (row == -1) {
            return rowTop + this.layoutAdvisor.getTopHeaderHeight() - 1;
        }
        return rowTop + this.layoutAdvisor.getRowHeight(row) - 1;
    }

    private int getFixedHeight() {
        int height = this.linePixels;
        if (this.layoutAdvisor.isTopHeaderVisible()) {
            height += this.layoutAdvisor.getTopHeaderHeight();
            height += this.linePixels;
        }
        int i = 0;
        while (i < this.layoutAdvisor.getFixedRowCount()) {
            height += this.layoutAdvisor.getRowHeight(i);
            height += this.linePixels;
            ++i;
        }
        return height;
    }

    public void calculateMetrics() {
        ScrollBar sb;
        Rectangle clientArea = this.getClientArea();
        if (clientArea.isEmpty()) {
            return;
        }
        if (this.layoutAdvisor == null) {
            ScrollBar sb2 = this.getHorizontalBar();
            if (sb2 != null) {
                sb2.setMinimum(0);
                sb2.setMaximum(1);
                sb2.setPageIncrement(1);
                sb2.setThumb(1);
                sb2.setSelection(1);
            }
            if ((sb2 = this.getVerticalBar()) != null) {
                sb2.setMinimum(0);
                sb2.setMaximum(1);
                sb2.setPageIncrement(1);
                sb2.setThumb(1);
                sb2.setSelection(1);
            }
            return;
        }
        int fixedRowCount = this.layoutAdvisor.getFixedRowCount();
        int fixedColumnCount = this.layoutAdvisor.getFixedColumnCount();
        int totalRowCount = this.layoutAdvisor.getRowCount();
        int totalColumnCount = this.layoutAdvisor.getColumnCount();
        this.topRow = Math.max(this.topRow, fixedRowCount);
        if (this.topRow >= totalRowCount) {
            this.topRow = 0;
        }
        this.leftColumn = Math.max(this.leftColumn, fixedColumnCount);
        if (this.leftColumn >= totalColumnCount) {
            this.leftColumn = 0;
        }
        this.columnsVisible = 0;
        this.columnsFullyVisible = 0;
        if (totalColumnCount > fixedColumnCount) {
            int rightBoundary = clientArea.x + clientArea.width;
            int width = this.getColumnLeft(this.leftColumn);
            int col = this.leftColumn;
            while (col < totalColumnCount) {
                if (width < rightBoundary) {
                    ++this.columnsVisible;
                }
                width += this.getColumnWidth(col);
                if ((width += this.linePixels) > rightBoundary) break;
                ++this.columnsFullyVisible;
                ++col;
            }
        }
        if ((sb = this.getHorizontalBar()) != null) {
            if (fixedColumnCount >= totalColumnCount) {
                sb.setMinimum(0);
                sb.setMaximum(1);
                sb.setPageIncrement(1);
                sb.setThumb(1);
                sb.setSelection(1);
            } else {
                sb.setMinimum(fixedColumnCount);
                sb.setMaximum(totalColumnCount);
                sb.setIncrement(1);
                sb.setPageIncrement(this.columnsVisible - fixedColumnCount);
                sb.setThumb(this.columnsFullyVisible);
                sb.setSelection(this.leftColumn);
            }
        }
        this.rowsVisible = 0;
        this.rowsFullyVisible = 0;
        if (totalRowCount > fixedRowCount) {
            int bottomBoundary = clientArea.y + clientArea.height;
            int height = this.getRowTop(this.topRow);
            int row = this.topRow;
            while (row < totalRowCount) {
                if (height < bottomBoundary) {
                    ++this.rowsVisible;
                }
                height += this.layoutAdvisor.getRowHeight(row);
                if ((height += this.linePixels) > bottomBoundary) break;
                ++this.rowsFullyVisible;
                ++row;
            }
        }
        if ((sb = this.getVerticalBar()) != null) {
            if (totalRowCount <= fixedRowCount) {
                sb.setMinimum(0);
                sb.setMaximum(1);
                sb.setPageIncrement(1);
                sb.setThumb(1);
                sb.setSelection(1);
            } else {
                sb.setMinimum(fixedRowCount);
                sb.setMaximum(totalRowCount);
                sb.setPageIncrement(this.rowsVisible - fixedRowCount);
                sb.setIncrement(1);
                sb.setThumb(this.rowsFullyVisible);
                sb.setSelection(this.topRow);
            }
        }
    }

    protected Rectangle getCellRectIgnoreSpan(int row, int col) {
        return this.getCellRectIgnoreSpan(row, col, this.getColumnLeft(col), this.getRowTop(row));
    }

    protected Rectangle getCellRectIgnoreSpan(int row, int col, int startX, int startY) {
        if (col < 0 || col >= this.layoutAdvisor.getColumnCount()) {
            return new Rectangle(-1, -1, 0, 0);
        }
        int x = startX;
        int y = startY;
        int width = this.getColumnWidth(col);
        int height = this.layoutAdvisor.getRowHeight(row);
        return new Rectangle(x, y, width, height);
    }

    protected Rectangle getHeaderRowCellRect(int col) {
        return this.getTopHeaderCellRect(col, this.getColumnLeft(col));
    }

    protected Rectangle getTopHeaderCellRect(int col, int startX) {
        int x = startX;
        int y = this.linePixels;
        int width = this.getColumnWidth(col);
        int height = this.layoutAdvisor.getTopHeaderHeight();
        return new Rectangle(x, y, width, height);
    }

    protected Rectangle getHeaderColumnCellRect(int row) {
        return this.getLeftHeaderCellRect(row, this.getRowTop(row));
    }

    protected Rectangle getLeftHeaderCellRect(int row, int startY) {
        int x = this.linePixels;
        int y = startY;
        int width = this.layoutAdvisor.getLeftHeaderWidth();
        int height = this.layoutAdvisor.getRowHeight(row);
        return new Rectangle(x, y, width, height);
    }

    public Rectangle getCellRect(int row, int col) {
        this.checkWidget();
        Cell valid = this.getValidCell(row, col);
        if (valid == Cell.NULLCELL || valid.row != row || valid.column != col) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle bound = this.getCellRectIgnoreSpan(row, col);
        int fixedRowCount = this.layoutAdvisor.getFixedRowCount();
        int totalRowCount = this.layoutAdvisor.getRowCount();
        int spanRow = row + 1;
        while (this.getValidCell(spanRow, col).equals(valid) && spanRow < totalRowCount) {
            if (row < fixedRowCount && spanRow >= fixedRowCount && spanRow < this.topRow) {
                ++spanRow;
                continue;
            }
            bound.height += this.layoutAdvisor.getRowHeight(spanRow);
            bound.height += this.linePixels;
            ++spanRow;
        }
        int spanCol = col + 1;
        int fixedColumnCount = this.layoutAdvisor.getFixedColumnCount();
        int totalColumnCount = this.layoutAdvisor.getColumnCount();
        while (this.getValidCell(row, spanCol).equals(valid) && spanCol < totalColumnCount) {
            if (col < fixedColumnCount && spanCol >= fixedColumnCount && spanCol < this.leftColumn) {
                ++spanCol;
                continue;
            }
            bound.width += this.getColumnWidth(spanCol);
            bound.width += this.linePixels;
            ++spanCol;
        }
        return bound;
    }

    private void onPaint(PaintEvent event) {
        this.calculateMetrics();
        GC gc = event.gc;
        if (this.layoutAdvisor != null) {
            Rectangle contentArea;
            Rectangle fixedColumnScrollableArea;
            Rectangle fixedRowScrollableArea;
            GC headerGC;
            int fixedRowCount = this.layoutAdvisor.getFixedRowCount();
            int fixedColumnCount = this.layoutAdvisor.getFixedColumnCount();
            boolean isTopHeaderVisible = this.layoutAdvisor.isTopHeaderVisible();
            boolean isLeftHeaderVisible = this.layoutAdvisor.isLeftHeaderVisible();
            boolean hasFixedRow = fixedRowCount > 0;
            boolean hasFixedColumn = fixedColumnCount > 0;
            Rectangle intersection = null;
            int style = this.getStyle();
            Rectangle clipping = gc.getClipping();
            if (isTopHeaderVisible) {
                Rectangle topHeaderArea = this.getTopHeaderArea();
                intersection = topHeaderArea.intersection(clipping);
                if (!intersection.isEmpty()) {
                    gc.setClipping(intersection);
                    if (hasFixedColumn) {
                        this.drawTopHeaderCells(gc, intersection, 0, fixedColumnCount - 1);
                    }
                    this.drawTopHeaderCells(gc, intersection, this.leftColumn, this.leftColumn + this.columnsVisible - 1);
                    gc.setClipping(clipping);
                } else if ((style & 0x40000000) == 0x40000000 || (style & 0x20000000) == 0x20000000) {
                    headerGC = new GC((Drawable)this);
                    headerGC.setClipping(topHeaderArea);
                    if (hasFixedColumn) {
                        this.drawTopHeaderCells(headerGC, headerGC.getClipping(), 0, fixedColumnCount - 1);
                    }
                    this.drawTopHeaderCells(headerGC, headerGC.getClipping(), this.leftColumn, this.leftColumn + this.columnsVisible - 1);
                    headerGC.dispose();
                }
            }
            if (isLeftHeaderVisible) {
                Rectangle leftHeaderArea = this.getLeftHeaderArea();
                intersection = leftHeaderArea.intersection(clipping);
                if (!intersection.isEmpty()) {
                    gc.setClipping(intersection);
                    if (hasFixedRow) {
                        this.drawLeftHeaderCells(gc, intersection, 0, fixedRowCount - 1);
                    }
                    this.drawLeftHeaderCells(gc, intersection, this.topRow, this.topRow + this.rowsVisible - 1);
                    gc.setClipping(clipping);
                } else if ((style & 0x40000000) == 0x40000000 || (style & 0x20000000) == 0x20000000) {
                    headerGC = new GC((Drawable)this);
                    headerGC.setClipping(leftHeaderArea);
                    if (hasFixedRow) {
                        this.drawLeftHeaderCells(headerGC, headerGC.getClipping(), 0, fixedRowCount - 1);
                    }
                    this.drawLeftHeaderCells(headerGC, headerGC.getClipping(), this.topRow, this.topRow + this.rowsVisible - 1);
                    headerGC.dispose();
                }
            }
            if (isTopHeaderVisible && isLeftHeaderVisible) {
                this.drawTopLeftCell(gc);
            }
            if (hasFixedRow && !(intersection = (fixedRowScrollableArea = this.getFixedRowScrollableArea()).intersection(clipping)).isEmpty()) {
                gc.setClipping(intersection);
                this.drawCells(gc, intersection, 0, fixedRowCount - 1, this.leftColumn, this.leftColumn + this.columnsVisible - 1);
                gc.setClipping(clipping);
            }
            if (hasFixedColumn && !(intersection = (fixedColumnScrollableArea = this.getFixedColumnScrollableArea()).intersection(clipping)).isEmpty()) {
                gc.setClipping(intersection);
                this.drawCells(gc, intersection, this.topRow, this.topRow + this.rowsVisible - 1, 0, fixedColumnCount - 1);
                gc.setClipping(clipping);
            }
            if (hasFixedRow && hasFixedColumn) {
                this.drawCells(gc, clipping, 0, fixedRowCount - 1, 0, fixedColumnCount - 1);
            }
            if (!(intersection = (contentArea = this.getContentArea()).intersection(clipping)).isEmpty()) {
                gc.setClipping(intersection);
                this.drawCells(gc, intersection, this.topRow, this.topRow + this.rowsVisible - 1, this.leftColumn, this.leftColumn + this.columnsVisible - 1);
                gc.setClipping(clipping);
            }
            int totalRowCount = this.layoutAdvisor.getRowCount();
            int totalColumnCount = this.layoutAdvisor.getColumnCount();
            if (!isTopHeaderVisible && totalRowCount == 0 || !isLeftHeaderVisible && totalColumnCount == 0) {
                Rectangle rect = this.getClientArea();
                gc.fillRectangle(rect);
            } else {
                this.drawRightMargin(gc);
                this.drawBottomMargin(gc);
                this.drawBorderLine(gc);
            }
        } else {
            Rectangle rect = this.getClientArea();
            gc.fillRectangle(rect);
        }
    }

    protected void drawTopLeftCell(GC gc) {
        int width = this.layoutAdvisor.getLeftHeaderWidth();
        int height = this.layoutAdvisor.getTopHeaderHeight();
        Rectangle rect = new Rectangle(this.linePixels, this.linePixels, width, height);
        ICellRenderer cellRenderer = this.cellRendererProvider.getTopHeadRenderer(0);
        cellRenderer.drawCell(gc, rect, -1, -1);
        int x = this.linePixels + width - 1;
        int y = this.linePixels + height - 1;
        gc.setBackground(this.getDisplay().getSystemColor(16));
        gc.fillPolygon(new int[]{x, y, x, y - 8, x - 8, y, x, y});
    }

    private void drawRightMargin(GC gc) {
        int lastCol = this.layoutAdvisor.getColumnCount() - 1;
        if (this.leftColumn + this.columnsFullyVisible - 1 == lastCol) {
            Rectangle clientArea = this.getClientArea();
            int x = this.getColumnRight(this.leftColumn + this.columnsFullyVisible - 1) + 1 + this.linePixels;
            if (x >= clientArea.x + clientArea.width - 1 - this.linePixels) {
                return;
            }
            int y = this.linePixels;
            int width = clientArea.x + clientArea.width - this.linePixels - x + 1;
            int height = this.layoutAdvisor.getTopHeaderHeight();
            if ((this.getStyle() & 0x40000) != 0) {
                Rectangle rect = null;
                if (this.layoutAdvisor.isTopHeaderVisible()) {
                    rect = new Rectangle(x, y, width - 1, height);
                    ICellRenderer headerCellRenderer = this.cellRendererProvider.getTopHeadRenderer(lastCol);
                    headerCellRenderer.drawCell(gc, rect, -1, lastCol + 1);
                    y += this.layoutAdvisor.getTopHeaderHeight();
                    y += this.linePixels;
                }
                int row = 0;
                while (row < this.layoutAdvisor.getFixedRowCount()) {
                    height = this.layoutAdvisor.getRowHeight(row);
                    ICellRenderer fixedCellRenderer = this.cellRendererProvider.getCellRenderer(row, lastCol);
                    rect = new Rectangle(x, y, width - 1, height);
                    fixedCellRenderer.drawCell(gc, rect, row, lastCol + 1);
                    y += height;
                    y += this.linePixels;
                    ++row;
                }
                row = this.topRow;
                while (row <= this.topRow + this.rowsVisible) {
                    height = this.layoutAdvisor.getRowHeight(row);
                    ICellRenderer defaultRenderer = this.cellRendererProvider.getCellRenderer(row, lastCol);
                    rect = new Rectangle(x, y, width - 1, height);
                    defaultRenderer.drawCell(gc, rect, row, lastCol + 1);
                    y += height;
                    y += this.linePixels;
                    ++row;
                }
            } else {
                y = 0;
                height = clientArea.height;
                gc.setBackground(this.getBackground());
                gc.fillRectangle(x, y, width, height);
            }
        }
    }

    private void drawBottomMargin(GC gc) {
        int lastRow = this.layoutAdvisor.getRowCount() - 1;
        if (this.topRow + this.rowsFullyVisible - 1 == lastRow) {
            Rectangle clientArea = this.getClientArea();
            int y = this.getRowBottom(lastRow) + 1 + this.linePixels;
            if (y >= clientArea.height - 1) {
                return;
            }
            int x = 0;
            int width = clientArea.width;
            int height = clientArea.height - y;
            gc.setBackground(this.getBackground());
            gc.fillRectangle(x, y, width, height);
        }
    }

    private void drawBorderLine(GC gc) {
        int y;
        if (this.layoutAdvisor.getRowCount() > 0) {
            Display display = this.getDisplay();
            if ((this.getStyle() & 0x800000) == 0) {
                gc.setForeground(display.getSystemColor(17));
            } else {
                gc.setForeground(display.getSystemColor(25));
            }
        }
        boolean drawRightLine = false;
        boolean drawBottomLine = false;
        Rectangle rect = this.getClientArea();
        int lastRow = this.layoutAdvisor.getRowCount() - 1;
        int lastCol = this.layoutAdvisor.getColumnCount() - 1;
        if (this.topRow + this.rowsFullyVisible - 1 == lastRow && (y = this.getRowBottom(lastRow) + 1) <= rect.height - 1) {
            rect.height = y + 1;
            drawBottomLine = true;
        }
        if (this.leftColumn + this.columnsFullyVisible - 1 == lastCol) {
            int x = this.getColumnRight(lastCol) + 1;
            int style = this.getStyle();
            if (x <= rect.width - 1) {
                if ((style & 0x40000) == 0) {
                    rect.width = x + 1;
                }
                drawRightLine = true;
            }
        }
        gc.drawLine(rect.x, rect.y, rect.x + rect.width - 1, rect.y);
        gc.drawLine(rect.x, rect.y, rect.x, rect.y + rect.height - 1);
        if (drawBottomLine) {
            gc.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width - 1, rect.y + rect.height - 1);
        }
        if (drawRightLine) {
            gc.drawLine(rect.x + rect.width - 1, rect.y, rect.x + rect.width - 1, rect.y + rect.height - 1);
        }
    }

    protected void drawTopHeaderCells(GC gc, Rectangle clipRect, int fromCol, int toCol) {
        int startX = this.getColumnLeft(fromCol);
        int rightBorder = clipRect.x + clipRect.width;
        int col = fromCol;
        while (col <= toCol) {
            if (startX >= rightBorder) break;
            Rectangle rect = this.getTopHeaderCellRect(col, startX);
            startX += rect.width;
            startX += this.linePixels;
            Rectangle intersection = rect.intersection(clipRect);
            if (!intersection.isEmpty()) {
                ICellRenderer cellRenderer = this.cellRendererProvider.getTopHeadRenderer(col);
                cellRenderer.drawCell(gc, rect, -1, col);
            }
            ++col;
        }
    }

    protected void drawLeftHeaderCells(GC gc, Rectangle clipRect, int fromRow, int toRow) {
        int startY = this.getRowTop(fromRow);
        int bottomBorder = clipRect.y + clipRect.height;
        int row = fromRow;
        while (row <= toRow) {
            if (startY >= bottomBorder) break;
            Rectangle rect = this.getLeftHeaderCellRect(row, startY);
            startY += rect.height;
            startY += this.linePixels;
            Rectangle intersection = rect.intersection(clipRect);
            if (!intersection.isEmpty()) {
                ICellRenderer cellRenderer = this.cellRendererProvider.getLeftHeadRenderer(row);
                cellRenderer.drawCell(gc, rect, row, -1);
            }
            ++row;
        }
    }

    Cell getTopHeaderCell(int x, int y) {
        if (y < this.linePixels || y > this.linePixels + this.layoutAdvisor.getTopHeaderHeight() - 1) {
            return Cell.NULLCELL;
        }
        int width = this.linePixels;
        if (this.layoutAdvisor.isLeftHeaderVisible()) {
            width += this.layoutAdvisor.getLeftHeaderWidth();
            width += this.linePixels;
        }
        if (x <= width) {
            return Cell.NULLCELL;
        }
        int i = 0;
        while (i < this.layoutAdvisor.getFixedColumnCount()) {
            if (x <= (width += this.getColumnWidth(i))) {
                return new Cell(this, -1, i);
            }
            width += this.linePixels;
            ++i;
        }
        i = this.leftColumn;
        while (i < this.layoutAdvisor.getColumnCount()) {
            if (x <= (width += this.getColumnWidth(i))) {
                return new Cell(this, -1, i);
            }
            width += this.linePixels;
            ++i;
        }
        return Cell.NULLCELL;
    }

    Cell getLeftHeaderCell(int x, int y) {
        if (x < this.linePixels || x > this.linePixels + this.layoutAdvisor.getLeftHeaderWidth() - 1) {
            return Cell.NULLCELL;
        }
        int height = this.linePixels;
        if (this.layoutAdvisor.isTopHeaderVisible()) {
            height += this.layoutAdvisor.getTopHeaderHeight();
            height += this.linePixels;
        }
        if (y <= height) {
            return Cell.NULLCELL;
        }
        int i = 0;
        while (i < this.layoutAdvisor.getFixedRowCount()) {
            if (y <= (height += this.layoutAdvisor.getRowHeight(i))) {
                return new Cell(this, i, -1);
            }
            height += this.linePixels;
            ++i;
        }
        i = this.leftColumn;
        while (i < this.layoutAdvisor.getColumnCount()) {
            if (y <= (height += this.layoutAdvisor.getRowHeight(i))) {
                return new Cell(this, i, -1);
            }
            height += this.linePixels;
            ++i;
        }
        return Cell.NULLCELL;
    }

    public Cell getHeaderCell(int x, int y) {
        this.checkWidget();
        int headerColumnWidth = this.layoutAdvisor.getLeftHeaderWidth();
        int headerRowHeight = this.layoutAdvisor.getTopHeaderHeight();
        if (x >= this.linePixels && x <= this.linePixels + headerColumnWidth && y >= this.linePixels && y <= this.linePixels + headerRowHeight) {
            return new Cell(this, -1, -1);
        }
        if (x >= this.linePixels && x <= this.linePixels + headerColumnWidth) {
            return this.getLeftHeaderCell(x, y);
        }
        if (y >= this.linePixels && y <= this.linePixels + headerRowHeight) {
            return this.getTopHeaderCell(x, y);
        }
        return Cell.NULLCELL;
    }

    public Rectangle getHeaderCellRect(int row, int col) {
        this.checkWidget();
        int headerColumnWidth = this.layoutAdvisor.getLeftHeaderWidth();
        int headerRowHeight = this.layoutAdvisor.getTopHeaderHeight();
        if (row == -1 && col == -1) {
            return new Rectangle(this.linePixels, this.linePixels, headerColumnWidth, headerRowHeight);
        }
        if (col == -1 && row >= 0 && row <= this.layoutAdvisor.getRowCount() - 1) {
            return this.getHeaderColumnCellRect(row);
        }
        if (row == -1 && col >= 0 && col <= this.layoutAdvisor.getColumnCount() - 1) {
            return this.getHeaderRowCellRect(col);
        }
        return new Rectangle(0, 0, -1, -1);
    }

    private void drawCells(GC gc, Rectangle clipRect, int fromRow, int toRow, int fromCol, int toCol) {
        this.agileGridEditor.updateCellEditorBounds();
        int rightBorder = clipRect.x + clipRect.width;
        int bottomBorder = clipRect.y + clipRect.height;
        int startY = this.getRowTop(fromRow);
        int row = fromRow;
        while (row <= toRow) {
            int startX = this.getColumnLeft(fromCol);
            int col = fromCol;
            while (col <= toCol) {
                Rectangle rect = this.getCellRect(row, col, startX, startY);
                startX += this.getColumnWidth(col);
                startX += this.linePixels;
                if (rect.x >= rightBorder) break;
                if (rect.y >= bottomBorder) {
                    return;
                }
                if (rect.isEmpty()) {
                    Cell valid = this.getValidCell(row, col);
                    if ((valid.row < this.topRow && row >= this.topRow || valid.column < this.leftColumn && col >= this.leftColumn) && !(rect = this.getCellRect(valid.row, valid.column)).intersection(clipRect).isEmpty()) {
                        this.drawCell(gc, valid.row, valid.column, rect);
                    }
                } else if (!rect.intersection(clipRect).isEmpty()) {
                    this.drawCell(gc, row, col, rect);
                }
                ++col;
            }
            startY += this.layoutAdvisor.getRowHeight(row);
            startY += this.linePixels;
            ++row;
        }
    }

    public Cell getValidCell(int rowToCheck, int colToCheck) {
        this.checkWidget();
        if (rowToCheck < -1 || rowToCheck >= this.layoutAdvisor.getRowCount() || colToCheck < -1 || colToCheck >= this.layoutAdvisor.getColumnCount()) {
            return Cell.NULLCELL;
        }
        Cell found = new Cell(this, rowToCheck, colToCheck);
        Cell lastFound = Cell.NULLCELL;
        while (!found.equals(lastFound)) {
            lastFound = found;
            found = this.layoutAdvisor.mergeInto(found.row, found.column);
            if (found != null && found != Cell.NULLCELL && (found.column > lastFound.column || found.row > lastFound.row)) {
                throw new IllegalArgumentException("When spanning over several cells, supercells that determine the content of the large cell must always be in the left upper corner!");
            }
            if (found != null && found != Cell.NULLCELL) continue;
            return lastFound;
        }
        return found;
    }

    protected void drawCell(GC gc, int row, int col, Rectangle rect) {
        if (row < 0 || row >= this.layoutAdvisor.getRowCount() || col < 0 || col >= this.layoutAdvisor.getColumnCount() || rect.isEmpty()) {
            return;
        }
        ICellRenderer cellRenderer = this.cellRendererProvider.getCellRenderer(row, col);
        cellRenderer.drawCell(gc, rect, row, col);
    }

    public boolean isHeaderHighlighted(int row, int col) {
        this.checkWidget();
        int style = this.getStyle();
        if ((style & 0x40000000) != 0x40000000 && (style & 0x20000000) != 0x20000000) {
            return false;
        }
        if ((style & 0x40000000) == 0x40000000) {
            Cell[] sel = this.getCellSelection();
            if (sel != null && sel.length > 0) {
                ILayoutAdvisor layoutAdvisor = this.getLayoutAdvisor();
                if ((style & 0x8000000) != 0) {
                    if (row == -1 && col >= 0 && col < layoutAdvisor.getColumnCount()) {
                        return true;
                    }
                    int i = 0;
                    while (i < sel.length) {
                        if (row == sel[i].row) {
                            return true;
                        }
                        ++i;
                    }
                } else if ((style & 0x10000000) != 0) {
                    if (col == -1 && row >= 0 && row < layoutAdvisor.getRowCount()) {
                        return true;
                    }
                    int i = 0;
                    while (i < sel.length) {
                        if (col == sel[i].column) {
                            return true;
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < sel.length) {
                        if (row == sel[i].row || col == sel[i].column) {
                            return true;
                        }
                        Cell valid = this.getValidCell(sel[i].row, col);
                        if (valid.column == sel[i].column) {
                            return true;
                        }
                        valid = this.getValidCell(row, sel[i].column);
                        if (valid.row == sel[i].row) {
                            return true;
                        }
                        ++i;
                    }
                }
            }
        } else {
            Cell focusCell = this.getFocusCell();
            if (focusCell == Cell.NULLCELL) {
                return false;
            }
            if (row == focusCell.row || col == focusCell.column) {
                return true;
            }
            Cell valid = this.getValidCell(focusCell.row, col);
            if (valid.column == focusCell.column) {
                return true;
            }
            valid = this.getValidCell(row, focusCell.column);
            if (valid.row == focusCell.row) {
                return true;
            }
        }
        return false;
    }

    public boolean isCellPressed(int row, int col) {
        this.checkWidget();
        Rectangle rect = null;
        if (row >= 0 && col >= 0) {
            rect = this.getCellRect(row, col);
        } else if (row == -1 || col == -1) {
            rect = this.getHeaderCellRect(row, col);
        }
        boolean isPressed = this.mousePoint != null && rect.contains(this.mousePoint) && this.isCaptured && row == this.pressedCell.row && col == this.pressedCell.column;
        return isPressed;
    }

    public boolean isFocusCell(int row, int col) {
        this.checkWidget();
        return this.cellSelectionManager.isFocusCell(row, col);
    }

    public boolean isCellEditorActive() {
        this.checkWidget();
        return this.agileGridEditor.isCellEditorActive();
    }

    protected boolean showAsSelected(int row, int col) {
        if (this.agileGridEditor.isActiveCell(row, col)) {
            return false;
        }
        return this.cellSelectionManager.isCellSelected(row, col) && (this.isFocusControl() || this.isShowSelectionWithoutFocus());
    }

    public boolean isCellSelected(int row, int col) {
        this.checkWidget();
        return this.cellSelectionManager.isCellSelected(row, col);
    }

    public void setDefaultCursor(Cursor cursor, Point size_below_hotspot) {
        this.checkWidget();
        if (this.defaultCursor != null) {
            this.defaultCursor.dispose();
        }
        this.defaultCursor = cursor;
        this.defaultCursorSize = size_below_hotspot;
        this.setCursor(cursor);
    }

    public Cursor getRowResizeCursor() {
        this.checkWidget();
        if (this.rowResizeCursor == null) {
            return this.defaultRowResizeCursor;
        }
        return this.rowResizeCursor;
    }

    public void setRowResizeCursor(Cursor rowResizeCursor) {
        this.checkWidget();
        if (this.rowResizeCursor != null) {
            this.rowResizeCursor.dispose();
        }
        this.rowResizeCursor = rowResizeCursor;
    }

    public Cursor getColumnResizeCursor() {
        this.checkWidget();
        if (this.columnResizeCursor == null) {
            return this.defaultColumnResizeCursor;
        }
        return this.columnResizeCursor;
    }

    public void setColumnResizeCursor(Cursor columnResizeCursor) {
        this.checkWidget();
        if (this.columnResizeCursor != null) {
            this.columnResizeCursor.dispose();
        }
        this.columnResizeCursor = columnResizeCursor;
    }

    public void setDefaultRowResizeCursor(Cursor cursor) {
        this.checkWidget();
        if (this.defaultRowResizeCursor != null) {
            this.defaultRowResizeCursor.dispose();
        }
        this.defaultRowResizeCursor = cursor;
    }

    public void setDefaultColumnResizeCursor(Cursor cursor) {
        this.checkWidget();
        if (this.defaultColumnResizeCursor != null) {
            this.defaultColumnResizeCursor.dispose();
        }
        this.defaultColumnResizeCursor = cursor;
    }

    private int getColumnForResize(int x, int y) {
        if (!this.layoutAdvisor.isTopHeaderVisible() || y <= this.linePixels || y >= this.layoutAdvisor.getTopHeaderHeight() + this.linePixels) {
            return Integer.MIN_VALUE;
        }
        int left = 0;
        int right = 0;
        int pad = this.resizeAreaSize / 2;
        if (x <= this.linePixels + this.layoutAdvisor.getLeftHeaderWidth() + pad) {
            left = this.getColumnLeft(-1);
            right = left + this.layoutAdvisor.getLeftHeaderWidth() - 1;
            if (x > right - pad && x < right + 1 + this.linePixels + pad && this.layoutAdvisor.isColumnResizable(-1)) {
                return -1;
            }
        } else {
            if (x <= this.linePixels + this.getFixedWidth() + pad) {
                int fixedColumnCount = this.layoutAdvisor.getFixedColumnCount();
                left = this.getColumnLeft(0);
                int i = 0;
                while (i < fixedColumnCount) {
                    right = left + this.getColumnWidth(i) - 1;
                    if (x > right - pad && x < right + 1 + this.linePixels + pad && this.layoutAdvisor.isColumnResizable(i)) {
                        return i;
                    }
                    if (x >= left && x <= right) break;
                    left = right + 1 + this.linePixels;
                    ++i;
                }
                return Integer.MIN_VALUE;
            }
            int totalColumnCount = this.layoutAdvisor.getColumnCount();
            left = this.getColumnLeft(this.leftColumn);
            int i = this.leftColumn;
            while (i <= this.leftColumn + this.columnsVisible - 1 && i < totalColumnCount) {
                right = left + this.getColumnWidth(i) - 1;
                if (x > right - pad && x < right + 1 + this.linePixels + pad && this.layoutAdvisor.isColumnResizable(i)) {
                    return i;
                }
                if (x >= left && x <= right) break;
                left = right + 1 + this.linePixels;
                ++i;
            }
        }
        return Integer.MIN_VALUE;
    }

    private int getRowForResize(int x, int y) {
        if (!this.layoutAdvisor.isLeftHeaderVisible() || x <= this.linePixels || x >= this.layoutAdvisor.getLeftHeaderWidth() + this.linePixels) {
            return Integer.MIN_VALUE;
        }
        int top = 0;
        int bottom = 0;
        int pad = this.resizeAreaSize / 2;
        if (y <= this.linePixels + this.layoutAdvisor.getTopHeaderHeight() + pad) {
            top = this.getRowTop(-1);
            bottom = top + this.layoutAdvisor.getTopHeaderHeight() - 1;
            if (y > bottom - pad && y < bottom + 1 + this.linePixels + pad && this.layoutAdvisor.isRowResizable(-1)) {
                return -1;
            }
        } else {
            if (y <= this.linePixels + this.getFixedHeight() + pad) {
                int fixedRowCount = this.layoutAdvisor.getFixedRowCount();
                top = this.getRowTop(0);
                int i = 0;
                while (i < fixedRowCount) {
                    bottom = top + this.layoutAdvisor.getRowHeight(i) - 1;
                    if (y > bottom - pad && y < bottom + 1 + this.linePixels + pad && this.layoutAdvisor.isRowResizable(i)) {
                        return i;
                    }
                    if (y >= top && y <= bottom) break;
                    top = bottom + 1 + this.linePixels;
                    ++i;
                }
                return Integer.MIN_VALUE;
            }
            int totalRowCount = this.layoutAdvisor.getRowCount();
            top = this.getRowTop(this.topRow);
            int i = this.topRow;
            while (i <= this.topRow + this.rowsVisible - 1 && i < totalRowCount) {
                bottom = top + this.layoutAdvisor.getRowHeight(i) - 1;
                if (y > bottom - pad && y < bottom + 1 + this.linePixels + pad && this.layoutAdvisor.isRowResizable(i)) {
                    return i;
                }
                if (y >= top && y <= bottom) break;
                top = bottom + 1 + this.linePixels;
                ++i;
            }
        }
        return Integer.MIN_VALUE;
    }

    private int getRowForY(int y) {
        if (y < 0) {
            return Integer.MIN_VALUE;
        }
        int height = this.linePixels;
        if (this.layoutAdvisor.isTopHeaderVisible()) {
            height += this.layoutAdvisor.getTopHeaderHeight();
            if (y <= (height += this.linePixels)) {
                return -1;
            }
        }
        int fixedRowCount = this.layoutAdvisor.getFixedRowCount();
        int i = 0;
        while (i < fixedRowCount) {
            height += this.layoutAdvisor.getRowHeight(i);
            if (y <= (height += this.linePixels)) {
                return i;
            }
            ++i;
        }
        i = this.topRow;
        while (i <= this.topRow + this.rowsVisible - 1) {
            height += this.layoutAdvisor.getRowHeight(i);
            if (y <= (height += this.linePixels)) {
                return i;
            }
            ++i;
        }
        return Integer.MIN_VALUE;
    }

    private int getColumnForX(int x) {
        if (x < 0) {
            return Integer.MIN_VALUE;
        }
        int width = this.linePixels;
        if (this.layoutAdvisor.isLeftHeaderVisible()) {
            width += this.layoutAdvisor.getLeftHeaderWidth();
            if (x <= (width += this.linePixels)) {
                return -1;
            }
        }
        int fixedColumnCount = this.layoutAdvisor.getFixedColumnCount();
        int i = 0;
        while (i < fixedColumnCount) {
            width += this.getColumnWidth(i);
            if (x <= (width += this.linePixels)) {
                return i;
            }
            ++i;
        }
        i = this.leftColumn;
        while (i <= this.leftColumn + this.columnsVisible - 1) {
            width += this.getColumnWidth(i);
            if (x <= (width += this.linePixels)) {
                return i;
            }
            ++i;
        }
        return Integer.MIN_VALUE;
    }

    public Cell getCell(int x, int y) {
        this.checkWidget();
        if (this.layoutAdvisor == null) {
            return Cell.NULLCELL;
        }
        int row = this.getRowForY(y);
        int column = this.getColumnForX(x);
        if (row != Integer.MIN_VALUE && column != Integer.MIN_VALUE) {
            return new Cell(this, row, column);
        }
        return Cell.NULLCELL;
    }

    public boolean isCellVisible(int row, int col) {
        this.checkWidget();
        if (this.layoutAdvisor == null) {
            return false;
        }
        return row >= -1 && row < this.topRow + this.rowsVisible && (row < this.layoutAdvisor.getFixedRowCount() || row >= this.topRow) && col >= -1 && col < this.leftColumn + this.columnsVisible && (col < this.layoutAdvisor.getFixedColumnCount() || col >= this.leftColumn);
    }

    public boolean isCellFullyVisible(int row, int col) {
        this.checkWidget();
        if (this.layoutAdvisor == null) {
            return false;
        }
        return col >= this.leftColumn && col < this.leftColumn + this.columnsFullyVisible && row >= this.topRow && row < this.topRow + this.rowsFullyVisible || col < this.layoutAdvisor.getFixedColumnCount() && row < this.layoutAdvisor.getFixedRowCount();
    }

    public boolean isRowVisible(int row) {
        this.checkWidget();
        if (this.layoutAdvisor == null) {
            return false;
        }
        return row >= this.topRow && row < this.topRow + this.rowsVisible || row < this.layoutAdvisor.getFixedRowCount();
    }

    public boolean isRowFullyVisible(int row) {
        this.checkWidget();
        if (this.layoutAdvisor == null) {
            return false;
        }
        return row >= this.topRow && row < this.topRow + this.rowsFullyVisible || row < this.layoutAdvisor.getFixedRowCount();
    }

    protected void onMouseDown(MouseEvent e) {
        if (e.button == 1) {
            this.setCapture(true);
            this.isCaptured = true;
            int columnIndex = this.getColumnForResize(e.x, e.y);
            if (columnIndex >= -1) {
                this.resizeColumnIndex = columnIndex;
                this.resizeColumnLeft = this.getColumnLeft(columnIndex);
                return;
            }
            int rowIndex = this.getRowForResize(e.x, e.y);
            if (rowIndex >= -1) {
                this.resizeRowIndex = rowIndex;
                this.resizeRowTop = this.getRowTop(rowIndex);
                return;
            }
        }
        if (e.button == 1) {
            this.mousePoint = new Point(e.x, e.y);
            Cell cell = this.getCell(e.x, e.y);
            if (cell == Cell.NULLCELL && (cell = this.getHeaderCell(e.x, e.y)) == Cell.NULLCELL) {
                return;
            }
            this.pressedCell = cell;
            if (this.pressedCell.row == -1 || this.pressedCell.column == -1) {
                Rectangle rect = this.getHeaderCellRect(cell.row, cell.column);
                rect.width += this.linePixels;
                rect.height += this.linePixels;
                this.redraw(rect.x, rect.y, rect.width, rect.height, true);
            }
        }
    }

    protected void onMouseDoubleClick(MouseEvent e) {
        if (this.layoutAdvisor == null) {
            return;
        }
        if (e.button == 1) {
            int columnIndex;
            Cell cell = this.getCell(e.x, e.y);
            if (cell == Cell.NULLCELL) {
                return;
            }
            if (e.y < this.linePixels + this.layoutAdvisor.getTopHeaderHeight() && (columnIndex = this.getColumnForResize(e.x, e.y)) != Integer.MIN_VALUE) {
                this.resizeColumnOptimal(columnIndex);
                this.resizeColumnIndex = Integer.MIN_VALUE;
            }
            CellDoubleClickEvent event = new CellDoubleClickEvent(cell, e);
            this.fireCellDoubleClicked(event);
        }
    }

    protected void onMouseMove(MouseEvent e) {
        Rectangle rect;
        if (this.layoutAdvisor == null) {
            return;
        }
        if (this.resizeColumnIndex != Integer.MIN_VALUE || this.getColumnForResize(e.x, e.y) >= -1) {
            this.setCursor(this.getColumnResizeCursor());
        } else if (this.resizeRowIndex != Integer.MIN_VALUE || this.getRowForResize(e.x, e.y) >= -1) {
            this.setCursor(this.getRowResizeCursor());
        } else {
            this.setCursor(this.defaultCursor);
        }
        if (this.pressedCell.row == -1 || this.pressedCell.column == -1) {
            this.mousePoint = new Point(e.x, e.y);
            rect = this.getHeaderCellRect(this.pressedCell.row, this.pressedCell.column);
            rect.width += this.linePixels;
            rect.height += this.linePixels;
            this.redraw(rect.x, rect.y, rect.width, rect.height, true);
        }
        if (e.stateMask == 524288 && this.isMultiSelectMode() && !this.agileGridEditor.isCellEditorActive() && this.pressedCell.row >= 0 && this.pressedCell.column >= 0) {
            Cell cell = this.getCell(e.x, e.y);
            if (cell.row >= 0 && cell.column >= 0) {
                this.cellSelectionManager.focusCell(cell, e.stateMask | 0x20000);
            }
        }
        if (this.resizeColumnIndex != Integer.MIN_VALUE) {
            int newWidth;
            if (this.resizeColumnIndex == -1) {
                rect = this.getClientArea();
                int oldWidth = this.layoutAdvisor.getLeftHeaderWidth();
                int n = newWidth = e.x > rect.width - 5 ? rect.width - this.resizeColumnLeft - 5 : e.x - this.resizeColumnLeft;
                if (newWidth < 5) {
                    newWidth = 5;
                }
                this.layoutAdvisor.setLeftHeaderWidth(newWidth);
                newWidth = this.layoutAdvisor.getLeftHeaderWidth();
                if (oldWidth != newWidth) {
                    this.fireColumnResize(this.resizeColumnIndex, newWidth);
                }
            } else if (this.resizeColumnIndex >= 0) {
                int oldWidth = this.getColumnWidth(this.resizeColumnIndex);
                int newColumnSize = e.x - this.resizeColumnLeft;
                if (newColumnSize < 5) {
                    newColumnSize = 5;
                }
                this.layoutAdvisor.setColumnWidth(this.resizeColumnIndex, newColumnSize);
                newWidth = this.getColumnWidth(this.resizeColumnIndex);
                if (oldWidth != newWidth) {
                    this.fireColumnResize(this.resizeColumnIndex, newWidth);
                }
            }
        }
        if (this.resizeRowIndex != Integer.MIN_VALUE) {
            int newHeight;
            if (this.resizeRowIndex == -1) {
                Rectangle rect2 = this.getClientArea();
                int oldHeight = this.layoutAdvisor.getTopHeaderHeight();
                int n = newHeight = e.y > rect2.height - 5 ? rect2.height - 5 - this.resizeRowTop : e.y - this.resizeRowTop;
                if (newHeight < 5) {
                    newHeight = 5;
                }
                this.layoutAdvisor.setTopHeaderHeight(newHeight);
                newHeight = this.layoutAdvisor.getTopHeaderHeight();
                if (oldHeight != newHeight) {
                    this.fireRowResize(this.resizeRowIndex, newHeight);
                }
            } else if (this.resizeRowIndex >= 0) {
                int oldHeight = this.layoutAdvisor.getRowHeight(this.resizeRowIndex);
                int newRowSize = e.y - this.resizeRowTop;
                if (newRowSize < this.layoutAdvisor.getRowHeightMinimum()) {
                    newRowSize = this.layoutAdvisor.getRowHeightMinimum();
                }
                this.layoutAdvisor.setRowHeight(this.resizeRowIndex, newRowSize);
                newHeight = this.layoutAdvisor.getRowHeight(this.resizeRowIndex);
                if (oldHeight != newHeight) {
                    this.fireRowResize(this.resizeRowIndex, newRowSize);
                }
            }
        }
    }

    protected void onMouseUp(MouseEvent e) {
        if (this.layoutAdvisor == null) {
            return;
        }
        this.setCapture(false);
        this.isCaptured = false;
        if (this.pressedCell != Cell.NULLCELL) {
            int row = this.pressedCell.row;
            int col = this.pressedCell.column;
            this.pressedCell = Cell.NULLCELL;
            this.mousePoint = null;
            if (row == -1 || col == -1) {
                Rectangle rect = this.getHeaderCellRect(row, col);
                rect.width += this.linePixels;
                rect.height += this.linePixels;
                this.redraw(rect.x, rect.y, rect.width, rect.height, true);
            } else {
                Cell valid = this.getValidCell(row, col);
                this.redrawCells(new Cell[]{valid});
            }
        }
        this.resizeColumnIndex = Integer.MIN_VALUE;
        this.resizeRowIndex = Integer.MIN_VALUE;
    }

    public void setToolTipText(String tooltip) {
        this.checkWidget();
        this.nativeTooltip = tooltip;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.nativeTooltip;
    }

    public int resizeColumnOptimal(int column) {
        this.checkWidget();
        int optWidth = 5;
        int width = 0;
        if (column >= 0 && column < this.layoutAdvisor.getColumnCount()) {
            GC gc = new GC((Drawable)this);
            if (this.layoutAdvisor.isTopHeaderVisible() && (width = this.cellRendererProvider.getTopHeadRenderer(column).getOptimalWidth(gc, -1, column)) > optWidth) {
                optWidth = width;
            }
            int i = 0;
            while (i < this.layoutAdvisor.getFixedRowCount()) {
                width = this.cellRendererProvider.getCellRenderer(i, column).getOptimalWidth(gc, i, column);
                if (width > optWidth) {
                    optWidth = width;
                }
                ++i;
            }
            i = this.topRow;
            while (i < this.topRow + this.rowsVisible) {
                width = this.cellRendererProvider.getCellRenderer(i, column).getOptimalWidth(gc, i, column);
                if (width > optWidth) {
                    optWidth = width;
                }
                ++i;
            }
            gc.dispose();
            this.layoutAdvisor.setColumnWidth(column, optWidth);
            return optWidth;
        }
        if (column == -1) {
            GC gc = new GC((Drawable)this);
            int i = 0;
            while (i < this.layoutAdvisor.getFixedRowCount()) {
                width = this.cellRendererProvider.getLeftHeadRenderer(i).getOptimalWidth(gc, i, column);
                if (width > optWidth) {
                    optWidth = width;
                }
                ++i;
            }
            i = this.topRow;
            while (i < this.topRow + this.rowsVisible) {
                width = this.cellRendererProvider.getLeftHeadRenderer(i).getOptimalWidth(gc, i, column);
                if (width > optWidth) {
                    optWidth = width;
                }
                ++i;
            }
            gc.dispose();
            this.layoutAdvisor.setLeftHeaderWidth(optWidth);
            return optWidth;
        }
        return Integer.MIN_VALUE;
    }

    public void scroll(int row, int col) {
        this.checkWidget();
        if (col < 0 || col >= this.layoutAdvisor.getColumnCount() || row < 0 || row >= this.layoutAdvisor.getRowCount()) {
            return;
        }
        int oldTopRow = this.topRow;
        int oldLeftColumn = this.leftColumn;
        this.topRow = row;
        this.leftColumn = col;
        if (oldTopRow != this.topRow || oldLeftColumn != this.leftColumn) {
            this.redraw();
        }
    }

    public void scrollToFocus(boolean needRecalculate) {
        Cell focusCell;
        boolean change = false;
        if (needRecalculate) {
            this.calculateMetrics();
        }
        if ((focusCell = this.cellSelectionManager.getFocusCell()) == null || focusCell == Cell.NULLCELL) {
            return;
        }
        if (this.getVerticalBar() != null) {
            if (focusCell.row < this.topRow && focusCell.row >= this.layoutAdvisor.getFixedRowCount()) {
                this.topRow = focusCell.row;
                change = true;
            }
            if (this.rowsFullyVisible > 0 && focusCell.row >= this.topRow + this.rowsFullyVisible) {
                this.topRow = focusCell.row - this.rowsFullyVisible + 1;
                change = true;
            }
        }
        if (this.getHorizontalBar() != null) {
            if (focusCell.column < this.leftColumn && focusCell.column >= this.layoutAdvisor.getFixedColumnCount()) {
                this.leftColumn = focusCell.column;
                change = true;
            }
            if (this.columnsFullyVisible > 0 && focusCell.column >= this.leftColumn + this.columnsFullyVisible) {
                this.leftColumn = focusCell.column - this.columnsFullyVisible + 1;
                change = true;
            }
        }
        if (change) {
            this.redraw();
        }
    }

    public void scrollToFocus() {
        this.scrollToFocus(false);
    }

    protected void fireCellDoubleClicked(CellDoubleClickEvent event) {
        int i = 0;
        while (i < this.cellDoubleClickListeners.size()) {
            this.cellDoubleClickListeners.get(i).cellDoubleClicked(event);
            ++i;
        }
    }

    protected void fireColumnResize(int col, int newSize) {
        int i = 0;
        while (i < this.cellResizeListeners.size()) {
            this.cellResizeListeners.get(i).columnResized(col, newSize);
            ++i;
        }
    }

    protected void fireRowResize(int row, int newSize) {
        int i = 0;
        while (i < this.cellResizeListeners.size()) {
            this.cellResizeListeners.get(i).rowResized(row, newSize);
            ++i;
        }
    }

    public void addCellResizeListener(ICellResizeListener listener) {
        this.checkWidget();
        this.cellResizeListeners.add(listener);
    }

    public void addCellDoubleClickListener(ICellDoubleClickListener listener) {
        this.checkWidget();
        this.cellDoubleClickListeners.add(listener);
    }

    public boolean removeCellResizeListener(ICellResizeListener listener) {
        this.checkWidget();
        return this.cellResizeListeners.remove(listener);
    }

    public boolean removeDoubleClickListener(ICellDoubleClickListener listener) {
        this.checkWidget();
        return this.cellDoubleClickListeners.remove(listener);
    }

    public boolean isMultiSelectMode() {
        this.checkWidget();
        return (this.getStyle() & 2) == 2;
    }

    protected boolean isShowSelectionWithoutFocus() {
        return (this.getStyle() & 0x8000) != 32768;
    }

    public void setContentProvider(IContentProvider contentProvider) {
        this.checkWidget();
        if (this.contentProvider != null) {
            this.contentProvider.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.contentProvider = contentProvider;
        this.contentProvider.addPropertyChangeListener(this.propertyChangeListener);
        Cell focusCell = this.cellSelectionManager.getFocusCell();
        focusCell.column = Integer.MIN_VALUE;
        focusCell.row = Integer.MIN_VALUE;
        this.cellSelectionManager.clearSelectionWithoutRedraw();
        if ((this.getStyle() & 0x700) == 1792) {
            this.updateScrollbarVisibility();
        }
        this.redraw();
    }

    public IContentProvider getContentProvider() {
        return this.contentProvider;
    }

    protected void updateScrollbarVisibility() {
        try {
            Rectangle actualSize = this.getClientArea();
            boolean showVertBar = false;
            int theoreticalHeight = 1;
            int i = 0;
            while (i < this.layoutAdvisor.getRowCount()) {
                if ((theoreticalHeight += this.layoutAdvisor.getRowHeight(i)) > actualSize.height) {
                    showVertBar = true;
                    break;
                }
                ++i;
            }
            this.getVerticalBar().setVisible(showVertBar);
            int theoreticalWidth = 0;
            int i2 = 0;
            while (i2 < this.layoutAdvisor.getColumnCount()) {
                theoreticalWidth += this.getColumnWidth(i2);
                ++i2;
            }
            this.getHorizontalBar().setVisible(actualSize.width < theoreticalWidth);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getColumnWidth(int col) {
        this.checkWidget();
        if (col == this.layoutAdvisor.getColumnCount() - 1 && (this.getStyle() & 0x20000) != 0) {
            Rectangle clientArea = this.getClientArea();
            int remaining = clientArea.x + clientArea.width - this.linePixels - this.getColumnLeft(col);
            return Math.max(remaining, this.layoutAdvisor.getColumnWidth(col));
        }
        return this.layoutAdvisor.getColumnWidth(col);
    }

    public int getStyle() {
        this.checkWidget();
        return this.style;
    }

    public void setStyle(int style) {
        this.checkWidget();
        this.style = style;
    }

    public void editCell(int row, int col) {
        this.editCell(row, col, null);
    }

    public void editCell(int row, int col, Object hint) {
        Cell cell = new Cell(this, row, col);
        Cell focusCell = this.getFocusCell();
        if (focusCell.equals(cell) && this.isCellEditorActive()) {
            return;
        }
        this.cellSelectionManager.focusCell(cell, 0);
        this.scrollToFocus(true);
        EditorActivationEvent acEvent = new EditorActivationEvent(cell, null);
        this.triggerEditorActivationEvent(acEvent, hint);
    }

    public void cancelEditing() {
        this.agileGridEditor.cancelEditing();
    }

    public void applyEditorValue() {
        this.agileGridEditor.applyEditorValue();
    }

    public void triggerEditorActivationEvent(EditorActivationEvent editorActivationEvent, Object hint) {
        this.agileGridEditor.handleEditorActivationEvent(editorActivationEvent, hint);
    }

    public AgileGridEditor getAgileGridEditor() {
        this.checkWidget();
        return this.agileGridEditor;
    }

    public void setAgileGridEditor(AgileGridEditor agileGridEditor) {
        this.checkWidget();
        this.agileGridEditor = agileGridEditor;
    }

    protected AgileGridEditor createAgileGridEditor() {
        AgileGridEditor editor = new AgileGridEditor(this, 16);
        return editor;
    }

    public int getAgileGridEditorFeature() {
        this.checkWidget();
        if (this.agileGridEditor != null) {
            return this.agileGridEditor.getFeature();
        }
        return 0;
    }

    public void setAgileGridEditorFeature(int feature) {
        this.checkWidget();
        if (this.agileGridEditor != null) {
            this.agileGridEditor.setFeature(feature);
        }
    }

    public void setCellEditorProvider(ICellEditorProvider cellEditorProvider) {
        this.checkWidget();
        if (this.agileGridEditor != null) {
            this.agileGridEditor.setCellEditorProvider(cellEditorProvider);
        }
    }

    public ICellEditorProvider getCellEditorProvider() {
        this.checkWidget();
        if (this.agileGridEditor != null) {
            return this.agileGridEditor.getCellEditorProvider();
        }
        return null;
    }

    public Cell getNeighbor(Cell cell, int directionMask, boolean sameLevel) {
        this.checkWidget();
        Cell neighborCell = null;
        Cell ownerCell = this.layoutAdvisor.mergeInto(cell.row, cell.column);
        if (ownerCell != null) {
            cell = ownerCell;
        }
        if ((directionMask & 1) == 1 && cell.row > 0) {
            neighborCell = this.layoutAdvisor.mergeInto(cell.row - 1, cell.column);
            if (neighborCell == null) {
                neighborCell = new Cell(this, cell.row - 1, cell.column);
            }
        } else if ((directionMask & 2) == 2 && cell.row < this.layoutAdvisor.getRowCount() - 1) {
            int incr = 1;
            neighborCell = this.layoutAdvisor.mergeInto(cell.row + incr, cell.column);
            while (cell.equals(neighborCell)) {
                if (cell.row + ++incr >= this.layoutAdvisor.getRowCount()) break;
                neighborCell = this.layoutAdvisor.mergeInto(cell.row + incr, cell.column);
            }
            if (cell.equals(neighborCell)) {
                neighborCell = null;
            }
        } else if ((directionMask & 4) == 4 && cell.column > 0) {
            neighborCell = this.layoutAdvisor.mergeInto(cell.row, cell.column - 1);
        } else if ((directionMask & 8) == 8 && cell.column < this.layoutAdvisor.getColumnCount() - 1) {
            int incr = 1;
            neighborCell = this.layoutAdvisor.mergeInto(cell.row, cell.column + incr);
            while (cell.equals(neighborCell)) {
                if (cell.column + ++incr >= this.layoutAdvisor.getColumnCount()) break;
                neighborCell = this.layoutAdvisor.mergeInto(cell.row, cell.column + incr);
            }
            if (cell.equals(neighborCell)) {
                neighborCell = null;
            }
        }
        return neighborCell;
    }

    public int getRowsVisible() {
        this.checkWidget();
        return this.rowsVisible;
    }

    public int getRowsFullyVisible() {
        this.checkWidget();
        return this.rowsFullyVisible;
    }

    public int getColumnsVisible() {
        this.checkWidget();
        return this.columnsVisible;
    }

    public int getColumnsFullyVisible() {
        this.checkWidget();
        return this.columnsFullyVisible;
    }

    public ICellRendererProvider getCellRendererProvider() {
        this.checkWidget();
        return this.cellRendererProvider;
    }

    public void setCellRendererProvider(ICellRendererProvider cellRendererProvider) {
        this.checkWidget();
        this.cellRendererProvider = cellRendererProvider;
    }

    public ILayoutAdvisor getLayoutAdvisor() {
        this.checkWidget();
        return this.layoutAdvisor;
    }

    public void setLayoutAdvisor(ILayoutAdvisor layoutAdvisor) {
        this.checkWidget();
        if (this.layoutAdvisor != null) {
            this.layoutAdvisor.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.layoutAdvisor = layoutAdvisor;
        this.layoutAdvisor.addPropertyChangeListener(this.propertyChangeListener);
        Cell focusCell = this.cellSelectionManager.getFocusCell();
        focusCell.column = Integer.MIN_VALUE;
        focusCell.row = Integer.MIN_VALUE;
        this.cellSelectionManager.clearSelectionWithoutRedraw();
        if ((this.getStyle() & 0x700) == 1792) {
            this.updateScrollbarVisibility();
        }
        this.redraw();
    }

    public Object getContentAt(int row, int col) {
        this.checkWidget();
        if (this.contentProvider == null) {
            return "";
        }
        ICompositorStrategy compositorStrategy = this.layoutAdvisor.getCompositorStrategy();
        if (compositorStrategy != null) {
            row = compositorStrategy.mapRowIndexToContent(row);
        }
        return this.contentProvider.getContentAt(row, col);
    }

    public void setContentAt(int row, int col, Object content) {
        this.checkWidget();
        ICompositorStrategy compositorStrategy = this.layoutAdvisor.getCompositorStrategy();
        if (compositorStrategy != null) {
            row = compositorStrategy.mapRowIndexToContent(row);
        }
        this.contentProvider.setContentAt(row, col, content);
    }

    private ILayoutAdvisor createLayoutAdvisor() {
        return new DefaultLayoutAdvisor(this);
    }

    private IContentProvider createContentProvider() {
        return new DefaultContentProvider();
    }

    private ICellRendererProvider createCellRendererProvider() {
        return new DefaultCellRendererProvider(this);
    }

    private CellSelectionManager createFocusCellManager() {
        return new CellSelectionManager(this, new CellNavigationStrategy());
    }

    public void setCellNavigationStrategy(ICellNavigationStrategy cellNavigationStrategy) {
        this.cellSelectionManager.setNavigationStrategy(cellNavigationStrategy);
    }

    public ICellNavigationStrategy getCellNavigationStrategy() {
        return this.cellSelectionManager.getNavigationStrategy();
    }

    private int getRowTop(int row) {
        int y = this.linePixels;
        if (this.layoutAdvisor.isTopHeaderVisible()) {
            if (row == -1) {
                return y;
            }
            y += this.layoutAdvisor.getTopHeaderHeight();
            y += this.linePixels;
        } else if (row == -1) {
            return Integer.MIN_VALUE;
        }
        int fixedRowCount = this.layoutAdvisor.getFixedRowCount();
        if (row < fixedRowCount) {
            int i = 0;
            while (i < row) {
                y += this.layoutAdvisor.getRowHeight(i);
                y += this.linePixels;
                ++i;
            }
            return y;
        }
        y = this.getFixedHeight();
        if (row >= fixedRowCount && row < this.topRow) {
            int i = this.topRow - 1;
            while (i >= row) {
                y -= this.linePixels;
                y -= this.layoutAdvisor.getRowHeight(row);
                --i;
            }
            return y;
        }
        int i = this.topRow;
        while (i < row) {
            y += this.layoutAdvisor.getRowHeight(i);
            y += this.linePixels;
            ++i;
        }
        return y;
    }

    private Rectangle getCellRect(int row, int col, int startX, int startY) {
        Cell valid = this.getValidCell(row, col);
        if (valid == Cell.NULLCELL || valid.row != row || valid.column != col) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle bound = this.getCellRectIgnoreSpan(row, col, startX, startY);
        int spanRow = row + 1;
        int fixedRowCount = this.layoutAdvisor.getFixedRowCount();
        int totalRowCount = this.layoutAdvisor.getRowCount();
        while (this.getValidCell(spanRow, col).equals(valid) && spanRow < totalRowCount) {
            if (spanRow >= fixedRowCount && spanRow < this.topRow) {
                ++spanRow;
                continue;
            }
            bound.height += this.layoutAdvisor.getRowHeight(spanRow);
            bound.height += this.linePixels;
            ++spanRow;
        }
        int spanCol = col + 1;
        int fixedColumnCount = this.layoutAdvisor.getFixedColumnCount();
        int totalColumnCount = this.layoutAdvisor.getColumnCount();
        while (this.getValidCell(row, spanCol).equals(valid) && spanCol < totalColumnCount) {
            if (spanCol >= fixedColumnCount && spanCol < this.leftColumn) {
                ++spanCol;
                continue;
            }
            bound.width += this.getColumnWidth(spanCol);
            bound.width += this.linePixels;
            ++spanCol;
        }
        return bound;
    }

    public void addSelectionChangedListener(ISelectionChangedListener selectionChangedListener) {
        this.checkWidget();
        this.cellSelectionManager.addSelectionChangedListener(selectionChangedListener);
    }

    public boolean removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.checkWidget();
        return this.cellSelectionManager.removeSelectionChangedListener(listener);
    }

    public void addFocusCellChangedListener(IFocusCellChangedListener listener) {
        this.checkWidget();
        this.cellSelectionManager.addFocusCellChangedListener(listener);
    }

    public boolean removeFocusCellChangedListener(IFocusCellChangedListener listener) {
        this.checkWidget();
        return this.cellSelectionManager.removeFocusCellChangedListener(listener);
    }

    public void focusCell(Cell cell) {
        this.checkWidget();
        this.cellSelectionManager.focusCell(cell, 0);
    }

    public Cell[] getCellSelection() {
        this.checkWidget();
        return this.cellSelectionManager.getCellSelection();
    }

    public void selectCells(Cell[] cells) {
        this.checkWidget();
        this.cellSelectionManager.selectCells(cells);
    }

    public void clearSelection() {
        this.checkWidget();
        this.cellSelectionManager.clearSelection();
    }

    public Cell getFocusCell() {
        this.checkWidget();
        return this.cellSelectionManager.getFocusCell();
    }

    public int getLinePixels() {
        this.checkWidget();
        return this.linePixels;
    }

    public void setLinePixels(int linePixels) {
        this.checkWidget();
        this.linePixels = linePixels;
    }

    int getResizeAreaSize() {
        return this.resizeAreaSize;
    }

    void setResizeAreaSize(int resizeAreaSize) {
        this.resizeAreaSize = resizeAreaSize;
    }

    public void addEditorActivationListener(IEditorActivationListener listener) {
        this.checkWidget();
        if (this.agileGridEditor != null) {
            this.agileGridEditor.addEditorActivationListener(listener);
        }
    }

    public void removeEditorActivationListener(IEditorActivationListener listener) {
        this.checkWidget();
        if (this.agileGridEditor != null) {
            this.agileGridEditor.removeEditorActivationListener(listener);
        }
    }

    public EditorActivationStrategy getEditorActivationStrategy() {
        this.checkWidget();
        if (this.agileGridEditor != null) {
            this.agileGridEditor.getEditorActivationStrategy();
        }
        return null;
    }

    public void setEditorActivationStrategy(EditorActivationStrategy editorActivationStrategy) {
        this.checkWidget();
        if (this.agileGridEditor != null) {
            this.agileGridEditor.setEditorActivationStrategy(editorActivationStrategy);
        }
    }

    class TooltipListener
    implements Listener {
        private Shell tip = null;
        private Label label = null;
        private Display display;
        final Listener labelListener = new Listener(){

            public void handleEvent(Event event) {
                Label label = (Label)event.widget;
                Shell shell = label.getShell();
                switch (event.type) {
                    case 3: {
                        Event e = new Event();
                        e.item = AgileGrid.this;
                        e.button = event.button;
                        e.stateMask = event.stateMask;
                        AgileGrid.this.notifyListeners(3, e);
                    }
                }
                shell.dispose();
            }
        };

        public TooltipListener() {
            this.display = AgileGrid.this.getDisplay();
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 1: 
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 12: 
                case 13: {
                    if (this.tip == null) break;
                    this.tip.dispose();
                    this.tip = null;
                    this.label = null;
                    break;
                }
                case 32: {
                    if (this.tip != null && !this.tip.isDisposed()) {
                        this.tip.dispose();
                    }
                    Cell cell = AgileGrid.this.getCell(event.x, event.y);
                    String tooltip = AgileGrid.this.layoutAdvisor.getTooltip(cell.row, cell.column);
                    if ((tooltip == null || tooltip.equals("")) && (AgileGrid.this.nativeTooltip == null || AgileGrid.this.nativeTooltip.equals("")) || cell == null || cell.column == Integer.MIN_VALUE || cell.row == Integer.MIN_VALUE) {
                        this.tip = null;
                        this.label = null;
                        return;
                    }
                    this.tip = new Shell(AgileGrid.this.getShell(), 16384);
                    GridLayout gl = new GridLayout();
                    gl.marginWidth = 2;
                    gl.marginHeight = 2;
                    this.tip.setLayout((Layout)gl);
                    this.tip.setBackground(this.display.getSystemColor(29));
                    this.label = new Label((Composite)this.tip, 0);
                    this.label.setLayoutData((Object)new GridData(1808));
                    this.label.setForeground(this.display.getSystemColor(28));
                    this.label.setBackground(this.display.getSystemColor(29));
                    if (tooltip != null && !tooltip.equals("")) {
                        this.label.setText(tooltip);
                    } else {
                        this.label.setText(AgileGrid.this.nativeTooltip);
                    }
                    this.label.addListener(7, this.labelListener);
                    this.label.addListener(3, this.labelListener);
                    this.label.addListener(5, this.labelListener);
                    Point size = this.tip.computeSize(-1, -1);
                    int y = 20;
                    int x = 0;
                    if (AgileGrid.this.defaultCursorSize != null && ((AgileGrid)AgileGrid.this).defaultCursorSize.x >= 0 && ((AgileGrid)AgileGrid.this).defaultCursorSize.y >= 0) {
                        y = ((AgileGrid)AgileGrid.this).defaultCursorSize.y + 1;
                        x = -((AgileGrid)AgileGrid.this).defaultCursorSize.x;
                    }
                    Rectangle agileGridBounds = AgileGrid.this.getBounds();
                    if (event.x + x + size.x > agileGridBounds.x + agileGridBounds.width) {
                        event.x -= event.x + x + size.x - agileGridBounds.x - agileGridBounds.width;
                    }
                    if (event.y + y + size.y > agileGridBounds.y + agileGridBounds.height) {
                        event.y -= event.y + y + size.y - agileGridBounds.y - agileGridBounds.height;
                    }
                    Point pt = AgileGrid.this.toDisplay(event.x + x, event.y + y);
                    this.tip.setBounds(pt.x, pt.y, size.x, size.y);
                    this.tip.setVisible(true);
                }
            }
        }
    }
}

