/*
 * Decompiled with CFR 0.152.
 */
package org.agilemore.agilegrid;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.Cell;
import org.agilemore.agilegrid.EditorActivationEvent;
import org.agilemore.agilegrid.ICellEditorListener;
import org.agilemore.agilegrid.ICellEditorValidator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public abstract class CellEditor {
    private ArrayList<ICellEditorListener> cellEditorListeners = new ArrayList(10);
    private ArrayList<PropertyChangeListener> propertyChangeListeners = new ArrayList(10);
    private boolean valid = false;
    private ICellEditorValidator validator = null;
    private String errorMessage = null;
    private boolean dirty = false;
    private Control control = null;
    private static final int defaultStyle = 0;
    private int style = 0;
    public static final String COPY = "copy";
    public static final String CUT = "cut";
    public static final String DELETE = "delete";
    public static final String FIND = "find";
    public static final String PASTE = "paste";
    public static final String REDO = "redo";
    public static final String SELECT_ALL = "selectall";
    public static final String UNDO = "undo";
    protected Cell cell;
    protected AgileGrid agileGrid;
    protected Rectangle rect;
    protected String toolTip;
    private KeyListener keyListener;
    private TraverseListener travListener;

    protected CellEditor(AgileGrid parent) {
        this(parent, 0);
    }

    protected CellEditor(AgileGrid parent, int style) {
        this.style = style;
        this.agileGrid = parent;
        this.control = this.createControl(parent);
        if (this.control != null && !this.control.isDisposed()) {
            this.keyListener = new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    try {
                        CellEditor.this.onKeyPressed(e);
                    }
                    catch (Exception exception) {}
                }
            };
            this.control.addKeyListener(this.keyListener);
            this.travListener = new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    CellEditor.this.onTraverse(e);
                }
            };
            this.control.addTraverseListener(this.travListener);
            this.control.setVisible(false);
        }
    }

    public void addCellEditorListener(ICellEditorListener listener) {
        this.cellEditorListeners.add(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.add(listener);
    }

    protected abstract Control createControl(AgileGrid var1);

    public void deactivate() {
        if (this.control != null && !this.control.isDisposed()) {
            this.control.setVisible(false);
        }
    }

    public void dispose() {
        if (this.control != null) {
            this.control.removeKeyListener(this.keyListener);
            this.control.removeTraverseListener(this.travListener);
            Control contr = this.control;
            this.control = null;
            contr.dispose();
        }
    }

    protected abstract Object doGetValue();

    protected void doSetFocus() {
        if (this.control != null) {
            this.control.setFocus();
        }
    }

    protected abstract void doSetValue(Object var1);

    protected void fireApplyEditorValue() {
        int i = 0;
        while (i < this.cellEditorListeners.size()) {
            ICellEditorListener l = this.cellEditorListeners.get(i);
            l.applyEditorValue();
            ++i;
        }
    }

    protected void fireCancelEditor() {
        int i = 0;
        while (i < this.cellEditorListeners.size()) {
            ICellEditorListener l = this.cellEditorListeners.get(i);
            l.cancelEditor();
            ++i;
        }
    }

    protected void fireEditorValueChanged(boolean oldValidState, boolean newValidState) {
        int i = 0;
        while (i < this.cellEditorListeners.size()) {
            ICellEditorListener l = this.cellEditorListeners.get(i);
            l.editorValueChanged(oldValidState, newValidState);
            ++i;
        }
    }

    protected void fireEnablementChanged(String actionId) {
        int i = 0;
        while (i < this.propertyChangeListeners.size()) {
            PropertyChangeListener l = this.propertyChangeListeners.get(i);
            l.propertyChange(new PropertyChangeEvent(this, actionId, null, null));
            ++i;
        }
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public int getStyle() {
        return this.style;
    }

    public Control getControl() {
        return this.control;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public LayoutData getLayoutData() {
        LayoutData result = new LayoutData();
        Control control = this.getControl();
        if (control != null) {
            result.minimumWidth = control.computeSize((int)-1, (int)-1, (boolean)true).x;
        }
        return result;
    }

    public ICellEditorValidator getValidator() {
        return this.validator;
    }

    public final Object getValue() {
        if (!this.valid) {
            return null;
        }
        return this.doGetValue();
    }

    public boolean isActivated() {
        return this.control != null && this.control.getVisible();
    }

    public boolean isCopyEnabled() {
        return false;
    }

    protected boolean isCorrect(Object value) {
        this.errorMessage = null;
        if (this.validator == null) {
            return true;
        }
        this.errorMessage = this.validator.isValid(value);
        return this.errorMessage == null || this.errorMessage.equals("");
    }

    public boolean isCutEnabled() {
        return false;
    }

    public boolean isDeleteEnabled() {
        return false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    protected void markDirty() {
        this.dirty = true;
    }

    public boolean isFindEnabled() {
        return false;
    }

    public boolean isPasteEnabled() {
        return false;
    }

    public boolean isRedoEnabled() {
        return false;
    }

    public boolean isSelectAllEnabled() {
        return false;
    }

    public boolean isUndoEnabled() {
        return false;
    }

    public boolean isValueValid() {
        return this.valid;
    }

    protected void focusLost() {
        if (this.isActivated()) {
            this.fireApplyEditorValue();
        }
    }

    public void performCopy() {
    }

    public void performCut() {
    }

    public void performDelete() {
    }

    public void performFind() {
    }

    public void performPaste() {
    }

    public void performRedo() {
    }

    public void performSelectAll() {
    }

    public void performUndo() {
    }

    public void removeListener(ICellEditorListener listener) {
        this.cellEditorListeners.remove(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.remove(listener);
    }

    protected void setErrorMessage(String message) {
        this.errorMessage = message;
    }

    public void setFocus() {
        this.doSetFocus();
    }

    public void setValidator(ICellEditorValidator validator) {
        this.validator = validator;
    }

    public final void setValue(Object value) {
        this.valid = this.isCorrect(value);
        this.dirty = false;
        this.doSetValue(value);
    }

    protected void setValueValid(boolean valid) {
        this.valid = valid;
    }

    protected void valueChanged(boolean oldValidState, boolean newValidState) {
        this.valid = newValidState;
        this.dirty = true;
        this.fireEditorValueChanged(oldValidState, newValidState);
    }

    public void activate(EditorActivationEvent activationEvent) {
        this.cell = (Cell)activationEvent.getSource();
        this.rect = this.getRenderArea(this.cell);
        this.setBounds(this.rect);
        if (this.control != null) {
            this.control.setToolTipText(this.toolTip);
            this.control.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    CellEditor.this.agileGrid.setCursor(null);
                }
            });
            this.control.setVisible(true);
            this.setFocus();
        }
    }

    protected Rectangle getRenderArea(Cell cell) {
        return this.agileGrid.getCellRect(cell.row, cell.column);
    }

    protected boolean dependsOnExternalFocusListener() {
        return true;
    }

    public boolean isFocused() {
        if (this.control == null) {
            return false;
        }
        return this.control.isFocusControl();
    }

    public void updateBounds(Cell cell) {
        Rectangle rect = this.getRenderArea(cell);
        this.setBounds(rect);
    }

    public void setBounds(Rectangle rect) {
        if (this.control != null) {
            this.control.setBounds(rect);
        }
    }

    public Rectangle getBounds() {
        if (this.control != null) {
            Rectangle b = this.control.getBounds();
            return b;
        }
        return new Rectangle(0, 0, 0, 0);
    }

    protected void onKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.character == '\r' && (keyEvent.stateMask & 0x20000) == 0) {
            this.fireApplyEditorValue();
            this.deactivate();
        } else if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        } else {
            this.agileGrid.scrollToFocus(false);
        }
    }

    protected void onTraverse(TraverseEvent traverseEvent) {
        int row = this.cell.row;
        int column = this.cell.column;
        Cell c = null;
        switch (traverseEvent.keyCode) {
            case 0x1000003: {
                --column;
                break;
            }
            case 0x1000004: {
                c = this.agileGrid.getValidCell(row, ++column);
                while (this.cell.equals(c)) {
                    c = this.agileGrid.getValidCell(row, ++column);
                }
                break;
            }
            case 0x1000001: {
                --row;
                break;
            }
            case 0x1000002: {
                c = this.agileGrid.getValidCell(++row, column);
                while (this.cell.equals(c)) {
                    c = this.agileGrid.getValidCell(row, ++column);
                }
                break;
            }
        }
        if (row != this.cell.row || column != this.cell.column) {
            this.fireApplyEditorValue();
            this.agileGrid.focusCell(new Cell(this.agileGrid, row, column));
            this.agileGrid.scrollToFocus(false);
        }
    }

    public void setToolTipText(String toolTip) {
        this.toolTip = toolTip;
    }

    public AgileGrid getAgileGrid() {
        return this.agileGrid;
    }

    public void setAgileGrid(AgileGrid agileGrid) {
        this.agileGrid = agileGrid;
    }

    public static class LayoutData {
        public int horizontalAlignment = 16384;
        public boolean grabHorizontal = true;
        public int minimumWidth = 50;
    }
}

