/*
 * Decompiled with CFR 0.152.
 */
package org.agilemore.agilegrid.editors;

import java.text.MessageFormat;
import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.CellEditor;
import org.agilemore.agilegrid.EditorActivationEvent;
import org.agilemore.agilegrid.SWTResourceManager;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class PopupCellEditor
extends CellEditor {
    private Composite container;
    private Control contents;
    private CLabel label;
    private Shell shell;
    protected Object value = null;
    private static final int defaultStyle = 0;

    public PopupCellEditor(AgileGrid agileGrid) {
        this(agileGrid, 0);
    }

    public PopupCellEditor(AgileGrid agileGrid, int style) {
        super(agileGrid, style);
    }

    @Override
    public void activate(EditorActivationEvent activationEvent) {
        super.activate(activationEvent);
        this.openPopupBox((Control)this.container);
    }

    protected abstract Control createContents(Composite var1);

    protected void createToolBar(Composite parent) {
    }

    @Override
    protected Control createControl(AgileGrid agileGrid) {
        Font font = agileGrid.getFont();
        Color bg = agileGrid.getBackground();
        int style = this.getStyle();
        this.container = new Composite((Composite)agileGrid, style);
        this.container.setFont(font);
        this.container.setBackground(bg);
        this.container.setLayout((Layout)new FillLayout());
        this.label = new CLabel(this.container, 0x804000);
        this.label.setFont(this.container.getFont());
        this.label.setBackground(this.container.getBackground());
        this.label.setImage(SWTResourceManager.getImage(PopupCellEditor.class, "/icons/editor_normal.png"));
        this.updateLabel(this.value);
        this.setValueValid(true);
        return this.container;
    }

    @Override
    protected Object doGetValue() {
        return this.value;
    }

    @Override
    protected void doSetValue(Object value) {
        this.value = value;
        this.updateLabel(value);
    }

    protected CLabel getLabel() {
        return this.label;
    }

    protected void openPopupBox(Control parent) {
        this.shell = new Shell(parent.getShell(), 16400);
        this.shell.setBackground(parent.getBackground());
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u001b') {
                    PopupCellEditor.this.fireCancelEditor();
                }
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellDeactivated(ShellEvent e) {
                boolean validState = PopupCellEditor.this.isCorrect(PopupCellEditor.this.value);
                if (validState) {
                    PopupCellEditor.this.markDirty();
                    PopupCellEditor.this.fireApplyEditorValue();
                } else {
                    PopupCellEditor.this.setErrorMessage(MessageFormat.format(PopupCellEditor.this.getErrorMessage(), PopupCellEditor.this.value.toString()));
                    PopupCellEditor.this.fireCancelEditor();
                }
            }
        });
        Display display = parent.getDisplay();
        Rectangle cellRect = display.map((Control)parent.getParent(), null, parent.getBounds());
        Rectangle clientRect = parent.getMonitor().getClientArea();
        int x = cellRect.x;
        int y = cellRect.y + cellRect.height;
        int width = 300;
        int height = 200;
        if (x + width > clientRect.x + clientRect.width) {
            x = clientRect.x + clientRect.width - width;
        }
        if (y + height > clientRect.y + clientRect.height) {
            y = cellRect.y - height;
        }
        this.shell.setBounds(x, y, width, height);
        Composite popupContainer = new Composite((Composite)this.shell, 0);
        popupContainer.setBackground(popupContainer.getParent().getBackground());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        popupContainer.setLayout((Layout)gridLayout);
        this.contents = this.createContents(popupContainer);
        if (this.contents != null) {
            this.contents.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    if (e.character == '\u001b') {
                        PopupCellEditor.this.fireCancelEditor();
                    }
                }
            });
        }
        this.createToolBar(popupContainer);
        this.shell.open();
        this.shell.layout();
    }

    protected void updateLabel(Object value) {
        if (this.label == null) {
            return;
        }
        String text = "";
        if (value != null) {
            text = value.toString();
        }
        this.label.setText(text);
    }

    @Override
    public void deactivate() {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.dispose();
        }
        super.deactivate();
    }
}

