/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.eclipse.rmf.pror.reqif10.xhtml.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.rmf.reqif10.xhtml.util.XhtmlAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class XhtmlItemProviderAdapterFactory extends XhtmlAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public XhtmlItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlAbbrType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlAbbrTypeItemProvider xhtmlAbbrTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlAbbrType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlAbbrTypeAdapter() {
		if (xhtmlAbbrTypeItemProvider == null) {
			xhtmlAbbrTypeItemProvider = new XhtmlAbbrTypeItemProvider(this);
		}

		return xhtmlAbbrTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlAcronymType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlAcronymTypeItemProvider xhtmlAcronymTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlAcronymType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlAcronymTypeAdapter() {
		if (xhtmlAcronymTypeItemProvider == null) {
			xhtmlAcronymTypeItemProvider = new XhtmlAcronymTypeItemProvider(this);
		}

		return xhtmlAcronymTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlAddressType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlAddressTypeItemProvider xhtmlAddressTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlAddressType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlAddressTypeAdapter() {
		if (xhtmlAddressTypeItemProvider == null) {
			xhtmlAddressTypeItemProvider = new XhtmlAddressTypeItemProvider(this);
		}

		return xhtmlAddressTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlAType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlATypeItemProvider xhtmlATypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlAType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlATypeAdapter() {
		if (xhtmlATypeItemProvider == null) {
			xhtmlATypeItemProvider = new XhtmlATypeItemProvider(this);
		}

		return xhtmlATypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlBlockquoteType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlBlockquoteTypeItemProvider xhtmlBlockquoteTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlBlockquoteType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlBlockquoteTypeAdapter() {
		if (xhtmlBlockquoteTypeItemProvider == null) {
			xhtmlBlockquoteTypeItemProvider = new XhtmlBlockquoteTypeItemProvider(this);
		}

		return xhtmlBlockquoteTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlBrType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlBrTypeItemProvider xhtmlBrTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlBrType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlBrTypeAdapter() {
		if (xhtmlBrTypeItemProvider == null) {
			xhtmlBrTypeItemProvider = new XhtmlBrTypeItemProvider(this);
		}

		return xhtmlBrTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlCaptionType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlCaptionTypeItemProvider xhtmlCaptionTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlCaptionType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlCaptionTypeAdapter() {
		if (xhtmlCaptionTypeItemProvider == null) {
			xhtmlCaptionTypeItemProvider = new XhtmlCaptionTypeItemProvider(this);
		}

		return xhtmlCaptionTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlCiteType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlCiteTypeItemProvider xhtmlCiteTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlCiteType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlCiteTypeAdapter() {
		if (xhtmlCiteTypeItemProvider == null) {
			xhtmlCiteTypeItemProvider = new XhtmlCiteTypeItemProvider(this);
		}

		return xhtmlCiteTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlCodeType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlCodeTypeItemProvider xhtmlCodeTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlCodeType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlCodeTypeAdapter() {
		if (xhtmlCodeTypeItemProvider == null) {
			xhtmlCodeTypeItemProvider = new XhtmlCodeTypeItemProvider(this);
		}

		return xhtmlCodeTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlColgroupType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlColgroupTypeItemProvider xhtmlColgroupTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlColgroupType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlColgroupTypeAdapter() {
		if (xhtmlColgroupTypeItemProvider == null) {
			xhtmlColgroupTypeItemProvider = new XhtmlColgroupTypeItemProvider(this);
		}

		return xhtmlColgroupTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlColType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlColTypeItemProvider xhtmlColTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlColType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlColTypeAdapter() {
		if (xhtmlColTypeItemProvider == null) {
			xhtmlColTypeItemProvider = new XhtmlColTypeItemProvider(this);
		}

		return xhtmlColTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlDdType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlDdTypeItemProvider xhtmlDdTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlDdType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlDdTypeAdapter() {
		if (xhtmlDdTypeItemProvider == null) {
			xhtmlDdTypeItemProvider = new XhtmlDdTypeItemProvider(this);
		}

		return xhtmlDdTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlDfnType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlDfnTypeItemProvider xhtmlDfnTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlDfnType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlDfnTypeAdapter() {
		if (xhtmlDfnTypeItemProvider == null) {
			xhtmlDfnTypeItemProvider = new XhtmlDfnTypeItemProvider(this);
		}

		return xhtmlDfnTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlDivType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlDivTypeItemProvider xhtmlDivTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlDivType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlDivTypeAdapter() {
		if (xhtmlDivTypeItemProvider == null) {
			xhtmlDivTypeItemProvider = new XhtmlDivTypeItemProvider(this);
		}

		return xhtmlDivTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlDlType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlDlTypeItemProvider xhtmlDlTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlDlType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlDlTypeAdapter() {
		if (xhtmlDlTypeItemProvider == null) {
			xhtmlDlTypeItemProvider = new XhtmlDlTypeItemProvider(this);
		}

		return xhtmlDlTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlDtType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlDtTypeItemProvider xhtmlDtTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlDtType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlDtTypeAdapter() {
		if (xhtmlDtTypeItemProvider == null) {
			xhtmlDtTypeItemProvider = new XhtmlDtTypeItemProvider(this);
		}

		return xhtmlDtTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlEditType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlEditTypeItemProvider xhtmlEditTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlEditType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlEditTypeAdapter() {
		if (xhtmlEditTypeItemProvider == null) {
			xhtmlEditTypeItemProvider = new XhtmlEditTypeItemProvider(this);
		}

		return xhtmlEditTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlEmType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlEmTypeItemProvider xhtmlEmTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlEmType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlEmTypeAdapter() {
		if (xhtmlEmTypeItemProvider == null) {
			xhtmlEmTypeItemProvider = new XhtmlEmTypeItemProvider(this);
		}

		return xhtmlEmTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlH1Type} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlH1TypeItemProvider xhtmlH1TypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlH1Type}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlH1TypeAdapter() {
		if (xhtmlH1TypeItemProvider == null) {
			xhtmlH1TypeItemProvider = new XhtmlH1TypeItemProvider(this);
		}

		return xhtmlH1TypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlH2Type} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlH2TypeItemProvider xhtmlH2TypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlH2Type}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlH2TypeAdapter() {
		if (xhtmlH2TypeItemProvider == null) {
			xhtmlH2TypeItemProvider = new XhtmlH2TypeItemProvider(this);
		}

		return xhtmlH2TypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlH3Type} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlH3TypeItemProvider xhtmlH3TypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlH3Type}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlH3TypeAdapter() {
		if (xhtmlH3TypeItemProvider == null) {
			xhtmlH3TypeItemProvider = new XhtmlH3TypeItemProvider(this);
		}

		return xhtmlH3TypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlH4Type} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlH4TypeItemProvider xhtmlH4TypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlH4Type}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlH4TypeAdapter() {
		if (xhtmlH4TypeItemProvider == null) {
			xhtmlH4TypeItemProvider = new XhtmlH4TypeItemProvider(this);
		}

		return xhtmlH4TypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlH5Type} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlH5TypeItemProvider xhtmlH5TypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlH5Type}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlH5TypeAdapter() {
		if (xhtmlH5TypeItemProvider == null) {
			xhtmlH5TypeItemProvider = new XhtmlH5TypeItemProvider(this);
		}

		return xhtmlH5TypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlH6Type} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlH6TypeItemProvider xhtmlH6TypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlH6Type}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlH6TypeAdapter() {
		if (xhtmlH6TypeItemProvider == null) {
			xhtmlH6TypeItemProvider = new XhtmlH6TypeItemProvider(this);
		}

		return xhtmlH6TypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlHeadingType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlHeadingTypeItemProvider xhtmlHeadingTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlHeadingType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlHeadingTypeAdapter() {
		if (xhtmlHeadingTypeItemProvider == null) {
			xhtmlHeadingTypeItemProvider = new XhtmlHeadingTypeItemProvider(this);
		}

		return xhtmlHeadingTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlHrType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlHrTypeItemProvider xhtmlHrTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlHrType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlHrTypeAdapter() {
		if (xhtmlHrTypeItemProvider == null) {
			xhtmlHrTypeItemProvider = new XhtmlHrTypeItemProvider(this);
		}

		return xhtmlHrTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlInlPresType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlInlPresTypeItemProvider xhtmlInlPresTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlInlPresType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlInlPresTypeAdapter() {
		if (xhtmlInlPresTypeItemProvider == null) {
			xhtmlInlPresTypeItemProvider = new XhtmlInlPresTypeItemProvider(this);
		}

		return xhtmlInlPresTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlKbdType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlKbdTypeItemProvider xhtmlKbdTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlKbdType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlKbdTypeAdapter() {
		if (xhtmlKbdTypeItemProvider == null) {
			xhtmlKbdTypeItemProvider = new XhtmlKbdTypeItemProvider(this);
		}

		return xhtmlKbdTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlLiType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlLiTypeItemProvider xhtmlLiTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlLiType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlLiTypeAdapter() {
		if (xhtmlLiTypeItemProvider == null) {
			xhtmlLiTypeItemProvider = new XhtmlLiTypeItemProvider(this);
		}

		return xhtmlLiTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlObjectType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlObjectTypeItemProvider xhtmlObjectTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlObjectType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlObjectTypeAdapter() {
		if (xhtmlObjectTypeItemProvider == null) {
			xhtmlObjectTypeItemProvider = new XhtmlObjectTypeItemProvider(this);
		}

		return xhtmlObjectTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlOlType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlOlTypeItemProvider xhtmlOlTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlOlType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlOlTypeAdapter() {
		if (xhtmlOlTypeItemProvider == null) {
			xhtmlOlTypeItemProvider = new XhtmlOlTypeItemProvider(this);
		}

		return xhtmlOlTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlParamType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlParamTypeItemProvider xhtmlParamTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlParamType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlParamTypeAdapter() {
		if (xhtmlParamTypeItemProvider == null) {
			xhtmlParamTypeItemProvider = new XhtmlParamTypeItemProvider(this);
		}

		return xhtmlParamTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlPreType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlPreTypeItemProvider xhtmlPreTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlPreType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlPreTypeAdapter() {
		if (xhtmlPreTypeItemProvider == null) {
			xhtmlPreTypeItemProvider = new XhtmlPreTypeItemProvider(this);
		}

		return xhtmlPreTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlPType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlPTypeItemProvider xhtmlPTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlPType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlPTypeAdapter() {
		if (xhtmlPTypeItemProvider == null) {
			xhtmlPTypeItemProvider = new XhtmlPTypeItemProvider(this);
		}

		return xhtmlPTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlQType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlQTypeItemProvider xhtmlQTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlQType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlQTypeAdapter() {
		if (xhtmlQTypeItemProvider == null) {
			xhtmlQTypeItemProvider = new XhtmlQTypeItemProvider(this);
		}

		return xhtmlQTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlSampType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlSampTypeItemProvider xhtmlSampTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlSampType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlSampTypeAdapter() {
		if (xhtmlSampTypeItemProvider == null) {
			xhtmlSampTypeItemProvider = new XhtmlSampTypeItemProvider(this);
		}

		return xhtmlSampTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlSpanType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlSpanTypeItemProvider xhtmlSpanTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlSpanType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlSpanTypeAdapter() {
		if (xhtmlSpanTypeItemProvider == null) {
			xhtmlSpanTypeItemProvider = new XhtmlSpanTypeItemProvider(this);
		}

		return xhtmlSpanTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlStrongType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlStrongTypeItemProvider xhtmlStrongTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlStrongType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlStrongTypeAdapter() {
		if (xhtmlStrongTypeItemProvider == null) {
			xhtmlStrongTypeItemProvider = new XhtmlStrongTypeItemProvider(this);
		}

		return xhtmlStrongTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlTableType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlTableTypeItemProvider xhtmlTableTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlTableType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlTableTypeAdapter() {
		if (xhtmlTableTypeItemProvider == null) {
			xhtmlTableTypeItemProvider = new XhtmlTableTypeItemProvider(this);
		}

		return xhtmlTableTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlTbodyType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlTbodyTypeItemProvider xhtmlTbodyTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlTbodyType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlTbodyTypeAdapter() {
		if (xhtmlTbodyTypeItemProvider == null) {
			xhtmlTbodyTypeItemProvider = new XhtmlTbodyTypeItemProvider(this);
		}

		return xhtmlTbodyTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlTdType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlTdTypeItemProvider xhtmlTdTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlTdType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlTdTypeAdapter() {
		if (xhtmlTdTypeItemProvider == null) {
			xhtmlTdTypeItemProvider = new XhtmlTdTypeItemProvider(this);
		}

		return xhtmlTdTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlTfootType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlTfootTypeItemProvider xhtmlTfootTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlTfootType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlTfootTypeAdapter() {
		if (xhtmlTfootTypeItemProvider == null) {
			xhtmlTfootTypeItemProvider = new XhtmlTfootTypeItemProvider(this);
		}

		return xhtmlTfootTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlTheadType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlTheadTypeItemProvider xhtmlTheadTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlTheadType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlTheadTypeAdapter() {
		if (xhtmlTheadTypeItemProvider == null) {
			xhtmlTheadTypeItemProvider = new XhtmlTheadTypeItemProvider(this);
		}

		return xhtmlTheadTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlThType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlThTypeItemProvider xhtmlThTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlThType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlThTypeAdapter() {
		if (xhtmlThTypeItemProvider == null) {
			xhtmlThTypeItemProvider = new XhtmlThTypeItemProvider(this);
		}

		return xhtmlThTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlTrType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlTrTypeItemProvider xhtmlTrTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlTrType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlTrTypeAdapter() {
		if (xhtmlTrTypeItemProvider == null) {
			xhtmlTrTypeItemProvider = new XhtmlTrTypeItemProvider(this);
		}

		return xhtmlTrTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlUlType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlUlTypeItemProvider xhtmlUlTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlUlType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlUlTypeAdapter() {
		if (xhtmlUlTypeItemProvider == null) {
			xhtmlUlTypeItemProvider = new XhtmlUlTypeItemProvider(this);
		}

		return xhtmlUlTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlVarType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected XhtmlVarTypeItemProvider xhtmlVarTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.XhtmlVarType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createXhtmlVarTypeAdapter() {
		if (xhtmlVarTypeItemProvider == null) {
			xhtmlVarTypeItemProvider = new XhtmlVarTypeItemProvider(this);
		}

		return xhtmlVarTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.rmf.pror.reqif10.xhtml.DocumentRoot} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DocumentRootItemProvider documentRootItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.rmf.pror.reqif10.xhtml.DocumentRoot}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDocumentRootAdapter() {
		if (documentRootItemProvider == null) {
			documentRootItemProvider = new DocumentRootItemProvider(this);
		}

		return documentRootItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (xhtmlAbbrTypeItemProvider != null) xhtmlAbbrTypeItemProvider.dispose();
		if (xhtmlAcronymTypeItemProvider != null) xhtmlAcronymTypeItemProvider.dispose();
		if (xhtmlAddressTypeItemProvider != null) xhtmlAddressTypeItemProvider.dispose();
		if (xhtmlATypeItemProvider != null) xhtmlATypeItemProvider.dispose();
		if (xhtmlBlockquoteTypeItemProvider != null) xhtmlBlockquoteTypeItemProvider.dispose();
		if (xhtmlBrTypeItemProvider != null) xhtmlBrTypeItemProvider.dispose();
		if (xhtmlCaptionTypeItemProvider != null) xhtmlCaptionTypeItemProvider.dispose();
		if (xhtmlCiteTypeItemProvider != null) xhtmlCiteTypeItemProvider.dispose();
		if (xhtmlCodeTypeItemProvider != null) xhtmlCodeTypeItemProvider.dispose();
		if (xhtmlColgroupTypeItemProvider != null) xhtmlColgroupTypeItemProvider.dispose();
		if (xhtmlColTypeItemProvider != null) xhtmlColTypeItemProvider.dispose();
		if (xhtmlDdTypeItemProvider != null) xhtmlDdTypeItemProvider.dispose();
		if (xhtmlDfnTypeItemProvider != null) xhtmlDfnTypeItemProvider.dispose();
		if (xhtmlDivTypeItemProvider != null) xhtmlDivTypeItemProvider.dispose();
		if (xhtmlDlTypeItemProvider != null) xhtmlDlTypeItemProvider.dispose();
		if (xhtmlDtTypeItemProvider != null) xhtmlDtTypeItemProvider.dispose();
		if (xhtmlEditTypeItemProvider != null) xhtmlEditTypeItemProvider.dispose();
		if (xhtmlEmTypeItemProvider != null) xhtmlEmTypeItemProvider.dispose();
		if (xhtmlH1TypeItemProvider != null) xhtmlH1TypeItemProvider.dispose();
		if (xhtmlH2TypeItemProvider != null) xhtmlH2TypeItemProvider.dispose();
		if (xhtmlH3TypeItemProvider != null) xhtmlH3TypeItemProvider.dispose();
		if (xhtmlH4TypeItemProvider != null) xhtmlH4TypeItemProvider.dispose();
		if (xhtmlH5TypeItemProvider != null) xhtmlH5TypeItemProvider.dispose();
		if (xhtmlH6TypeItemProvider != null) xhtmlH6TypeItemProvider.dispose();
		if (xhtmlHeadingTypeItemProvider != null) xhtmlHeadingTypeItemProvider.dispose();
		if (xhtmlHrTypeItemProvider != null) xhtmlHrTypeItemProvider.dispose();
		if (xhtmlInlPresTypeItemProvider != null) xhtmlInlPresTypeItemProvider.dispose();
		if (xhtmlKbdTypeItemProvider != null) xhtmlKbdTypeItemProvider.dispose();
		if (xhtmlLiTypeItemProvider != null) xhtmlLiTypeItemProvider.dispose();
		if (xhtmlObjectTypeItemProvider != null) xhtmlObjectTypeItemProvider.dispose();
		if (xhtmlOlTypeItemProvider != null) xhtmlOlTypeItemProvider.dispose();
		if (xhtmlParamTypeItemProvider != null) xhtmlParamTypeItemProvider.dispose();
		if (xhtmlPreTypeItemProvider != null) xhtmlPreTypeItemProvider.dispose();
		if (xhtmlPTypeItemProvider != null) xhtmlPTypeItemProvider.dispose();
		if (xhtmlQTypeItemProvider != null) xhtmlQTypeItemProvider.dispose();
		if (xhtmlSampTypeItemProvider != null) xhtmlSampTypeItemProvider.dispose();
		if (xhtmlSpanTypeItemProvider != null) xhtmlSpanTypeItemProvider.dispose();
		if (xhtmlStrongTypeItemProvider != null) xhtmlStrongTypeItemProvider.dispose();
		if (xhtmlTableTypeItemProvider != null) xhtmlTableTypeItemProvider.dispose();
		if (xhtmlTbodyTypeItemProvider != null) xhtmlTbodyTypeItemProvider.dispose();
		if (xhtmlTdTypeItemProvider != null) xhtmlTdTypeItemProvider.dispose();
		if (xhtmlTfootTypeItemProvider != null) xhtmlTfootTypeItemProvider.dispose();
		if (xhtmlTheadTypeItemProvider != null) xhtmlTheadTypeItemProvider.dispose();
		if (xhtmlThTypeItemProvider != null) xhtmlThTypeItemProvider.dispose();
		if (xhtmlTrTypeItemProvider != null) xhtmlTrTypeItemProvider.dispose();
		if (xhtmlUlTypeItemProvider != null) xhtmlUlTypeItemProvider.dispose();
		if (xhtmlVarTypeItemProvider != null) xhtmlVarTypeItemProvider.dispose();
		if (documentRootItemProvider != null) documentRootItemProvider.dispose();
	}

}
