/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.pror.reqif10.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptorDecorator;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.rmf.pror.reqif10.configuration.ProrPresentationConfiguration;
import org.eclipse.rmf.pror.reqif10.configuration.provider.ProrPresentationConfigurationItemProvider;
import org.eclipse.rmf.pror.reqif10.util.CompoundCommandActionDelegate;
import org.eclipse.rmf.pror.reqif10.util.ConfigurationUtil;
import org.eclipse.rmf.pror.reqif10.util.PresentationEditInterface;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.AttributeDefinitionBoolean;
import org.eclipse.rmf.reqif10.AttributeDefinitionDate;
import org.eclipse.rmf.reqif10.AttributeDefinitionEnumeration;
import org.eclipse.rmf.reqif10.AttributeDefinitionInteger;
import org.eclipse.rmf.reqif10.AttributeDefinitionReal;
import org.eclipse.rmf.reqif10.AttributeDefinitionString;
import org.eclipse.rmf.reqif10.AttributeDefinitionXHTML;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.AttributeValueBoolean;
import org.eclipse.rmf.reqif10.AttributeValueDate;
import org.eclipse.rmf.reqif10.AttributeValueEnumeration;
import org.eclipse.rmf.reqif10.AttributeValueInteger;
import org.eclipse.rmf.reqif10.AttributeValueReal;
import org.eclipse.rmf.reqif10.AttributeValueString;
import org.eclipse.rmf.reqif10.AttributeValueXHTML;
import org.eclipse.rmf.reqif10.DatatypeDefinition;
import org.eclipse.rmf.reqif10.Identifiable;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.ReqIF10Factory;
import org.eclipse.rmf.reqif10.ReqIF10Package;
import org.eclipse.rmf.reqif10.ReqIFContent;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.reqif10.SpecRelation;
import org.eclipse.rmf.reqif10.SpecType;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;
import org.eclipse.rmf.reqif10.util.ReqIF10Switch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProrUtil {
    private ProrUtil() {
        throw new InstantiationError("This class is not designed to be instantiated.");
    }

    public static void addAttributePropertyDescriptor(SpecElementWithAttributes specElement, ItemProviderAdapter provider, List<IItemPropertyDescriptor> itemPropertyDescriptors) {
        for (AttributeValue value : specElement.getValues()) {
            ItemProviderAdapter valueProvider = ProrUtil.getItemProvider(provider.getAdapterFactory(), value);
            IItemPropertyDescriptor descriptor = valueProvider.getPropertyDescriptor((Object)value, (Object)ReqIF10Util.getTheValueFeature((AttributeValue)value));
            AttributeDefinition definition = ReqIF10Util.getAttributeDefinition((AttributeValue)value);
            if (definition == null) continue;
            String label = definition.getLongName() != null ? definition.getLongName() : "UNNAMED (" + definition.getIdentifier() + ")";
            itemPropertyDescriptors.add((IItemPropertyDescriptor)ProrUtil.buildAttributeValueItemPropertyDescriptor(specElement, value, descriptor, label));
        }
    }

    private static ItemPropertyDescriptorDecorator buildAttributeValueItemPropertyDescriptor(final SpecElementWithAttributes specElement, AttributeValue value, IItemPropertyDescriptor descriptor, final String label) {
        if (label == null) {
            throw new NullPointerException("Label must not be null");
        }
        return new ItemPropertyDescriptorDecorator(value, descriptor){

            public String getCategory(Object thisObject) {
                SpecType specType = ReqIF10Util.getSpecType((SpecElementWithAttributes)specElement);
                if (specType != null) {
                    if (specType.getLongName() == null) {
                        return "<UNNAMED TYPE>";
                    }
                    return specType.getLongName();
                }
                return "<NO CATEGORY>";
            }

            public String getDisplayName(Object thisObject) {
                return label;
            }

            public String getId(Object thisObject) {
                return label;
            }
        };
    }

    public static void setTheValue(AttributeValue av, Object value, EditingDomain ed) {
        EStructuralFeature feature = ReqIF10Util.getTheValueFeature((AttributeValue)av);
        Command cmd = SetCommand.create((EditingDomain)ed, (Object)av, (Object)feature, (Object)value);
        ed.getCommandStack().execute(cmd);
    }

    public static void setTheValue(AttributeValue av, Object value, final Object affectedObject, EditingDomain ed) {
        EStructuralFeature feature = ReqIF10Util.getTheValueFeature((AttributeValue)av);
        Command cmd = SetCommand.create((EditingDomain)ed, (Object)av, (Object)feature, (Object)value);
        CommandWrapper cmd2 = new CommandWrapper(cmd){

            public Collection<?> getAffectedObjects() {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(affectedObject);
                return list;
            }
        };
        ed.getCommandStack().execute((Command)cmd2);
    }

    public static boolean setTheValue(SpecObject specObject, DatatypeDefinition definition, Object value, EditingDomain ed) {
        EList list = specObject.getValues();
        for (AttributeValue av : list) {
            if (!definition.equals(ReqIF10Util.getDatatypeDefinition((AttributeValue)av))) continue;
            ProrUtil.setTheValue(av, value, (Object)specObject, ed);
            return true;
        }
        return false;
    }

    public static ItemProviderAdapter getItemProvider(AdapterFactory adapterFactory, Object object) {
        return (ItemProviderAdapter)adapterFactory.adapt(object, IItemLabelProvider.class);
    }

    public static void visitAllSpecElementsWithAttributes(ReqIF reqif, ReqIF10Switch<?> visitor) {
        TreeIterator i = EcoreUtil.getAllContents((EObject)reqif, (boolean)false);
        while (i.hasNext()) {
            Object obj = i.next();
            if (!(obj instanceof SpecElementWithAttributes)) continue;
            visitor.doSwitch((EObject)obj);
        }
    }

    public static void collectNewChildDescriptorsForTypeCreators(Collection<Object> newChildDescriptors, Object object, EStructuralFeature feature, Class<?> specTypeClass) {
        EList specTypes = ReqIF10Util.getReqIF((Object)object).getCoreContent().getSpecTypes();
        for (SpecType specType : specTypes) {
            if (!specTypeClass.isAssignableFrom(specType.getClass())) continue;
            newChildDescriptors.add(new CommandParameter(object, (Object)feature, (Object)specType));
        }
    }

    public static CompoundCommand createAddTypedElementCommand(Object parent, EReference childFeature, Identifiable newSpecElement, EReference typeFeature, SpecType specType, int index, int resultIndex, EditingDomain domain, AdapterFactory adapterFactory) {
        ItemProviderAdapter newElementItemProvider = ProrUtil.getItemProvider(adapterFactory, newSpecElement);
        Object icon = newElementItemProvider.getImage((Object)newSpecElement);
        CompoundCommandActionDelegate cmd = ProrUtil.createCompoundCommandWithAddIcon(icon, resultIndex);
        cmd.append(AddCommand.create((EditingDomain)domain, (Object)parent, (Object)childFeature, (Object)newSpecElement, (int)index));
        HashSet<SpecType> typeCollection = new HashSet<SpecType>();
        typeCollection.add(specType);
        CommandParameter typeParameter = new CommandParameter((Object)newSpecElement, (Object)typeFeature, typeCollection);
        cmd.append(newElementItemProvider.createCommand(parent, domain, AddCommand.class, typeParameter));
        String name = newSpecElement.getClass().getSimpleName();
        name = name.length() > 4 ? name.substring(0, name.length() - 4) : name;
        cmd.setLabel(String.valueOf(name) + " (" + specType.getLongName() + ")");
        return cmd;
    }

    public static CompoundCommandActionDelegate createCompoundCommandWithAddIcon(final Object icon, int resultIndex) {
        return new CompoundCommandActionDelegate(resultIndex){

            public Object getImage() {
                ArrayList<Object> images = new ArrayList<Object>();
                images.add(icon);
                images.add(EMFEditPlugin.INSTANCE.getImage("full/ovr16/CreateChild"));
                return new ComposedImage(images){

                    public List<ComposedImage.Point> getDrawPoints(ComposedImage.Size size) {
                        List result = super.getDrawPoints(size);
                        ((ComposedImage.Point)result.get((int)1)).x = size.width - 7;
                        return result;
                    }
                };
            }
        };
    }

    public static Command getPresentationHandleDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection, AdapterFactory adapterFactory) {
        Set<PresentationEditInterface> ips = ConfigurationUtil.getPresentationEditInterfaces(owner, adapterFactory);
        for (PresentationEditInterface ip : ips) {
            Command cmd = ip.handleDragAndDrop(collection, owner, domain, operation);
            if (cmd == null) continue;
            return cmd;
        }
        return null;
    }

    public static CompoundCommand createValueAdjustCommand(EditingDomain domain, SpecElementWithAttributes specElement, Collection<AttributeDefinition> definitions) {
        HashSet existingObsoleteValues = new HashSet(specElement.getValues());
        HashSet<AttributeDefinition> newDefs = new HashSet<AttributeDefinition>(definitions);
        CompoundCommand cmd = new CompoundCommand("Updating Type (and associated Values)");
        block0: for (AttributeDefinition newDef : newDefs) {
            AttributeValue value2;
            for (AttributeValue value2 : specElement.getValues()) {
                AttributeDefinition def = ReqIF10Util.getAttributeDefinition((AttributeValue)value2);
                if (def == null || !def.equals(newDef)) continue;
                existingObsoleteValues.remove(value2);
                continue block0;
            }
            value2 = ProrUtil.createAttributeValue(newDef);
            if (value2 == null) continue;
            cmd.append(AddCommand.create((EditingDomain)domain, (Object)specElement, (Object)ReqIF10Package.Literals.SPEC_ELEMENT_WITH_ATTRIBUTES__VALUES, (Object)value2));
        }
        for (AttributeValue value : existingObsoleteValues) {
            cmd.append(RemoveCommand.create((EditingDomain)domain, (Object)specElement, (Object)ReqIF10Package.Literals.SPEC_ELEMENT_WITH_ATTRIBUTES__VALUES, (Object)value));
        }
        return cmd;
    }

    private static AttributeValue createAttributeValue(AttributeDefinition attributeDefinition) {
        if (attributeDefinition == null) {
            return null;
        }
        if (attributeDefinition instanceof AttributeDefinitionBoolean) {
            AttributeValueBoolean value = ReqIF10Factory.eINSTANCE.createAttributeValueBoolean();
            value.setDefinition((AttributeDefinitionBoolean)attributeDefinition);
            AttributeValueBoolean defaultValue = ((AttributeDefinitionBoolean)attributeDefinition).getDefaultValue();
            if (defaultValue != null) {
                value.setTheValue(defaultValue.isTheValue());
            }
            return value;
        }
        if (attributeDefinition instanceof AttributeDefinitionDate) {
            AttributeValueDate value = ReqIF10Factory.eINSTANCE.createAttributeValueDate();
            value.setDefinition((AttributeDefinitionDate)attributeDefinition);
            AttributeValueDate defaultValue = ((AttributeDefinitionDate)attributeDefinition).getDefaultValue();
            if (defaultValue != null) {
                value.setTheValue(defaultValue.getTheValue());
            }
            return value;
        }
        if (attributeDefinition instanceof AttributeDefinitionInteger) {
            AttributeValueInteger value = ReqIF10Factory.eINSTANCE.createAttributeValueInteger();
            value.setDefinition((AttributeDefinitionInteger)attributeDefinition);
            AttributeValueInteger defaultValue = ((AttributeDefinitionInteger)attributeDefinition).getDefaultValue();
            if (defaultValue != null) {
                value.setTheValue(defaultValue.getTheValue());
            }
            return value;
        }
        if (attributeDefinition instanceof AttributeDefinitionReal) {
            AttributeValueReal value = ReqIF10Factory.eINSTANCE.createAttributeValueReal();
            value.setDefinition((AttributeDefinitionReal)attributeDefinition);
            AttributeValueReal defaultValue = ((AttributeDefinitionReal)attributeDefinition).getDefaultValue();
            if (defaultValue != null) {
                value.setTheValue(defaultValue.getTheValue());
            }
            return value;
        }
        if (attributeDefinition instanceof AttributeDefinitionString) {
            AttributeValueString value = ReqIF10Factory.eINSTANCE.createAttributeValueString();
            value.setDefinition((AttributeDefinitionString)attributeDefinition);
            AttributeValueString defaultValue = ((AttributeDefinitionString)attributeDefinition).getDefaultValue();
            if (defaultValue != null) {
                value.setTheValue(defaultValue.getTheValue());
            }
            return value;
        }
        if (attributeDefinition instanceof AttributeDefinitionXHTML) {
            AttributeValueXHTML value = ReqIF10Factory.eINSTANCE.createAttributeValueXHTML();
            value.setDefinition((AttributeDefinitionXHTML)attributeDefinition);
            AttributeValueXHTML defaultValue = ((AttributeDefinitionXHTML)attributeDefinition).getDefaultValue();
            if (defaultValue != null) {
                value.setTheValue(defaultValue.getTheValue());
            }
            return value;
        }
        if (attributeDefinition instanceof AttributeDefinitionEnumeration) {
            AttributeValueEnumeration value = ReqIF10Factory.eINSTANCE.createAttributeValueEnumeration();
            value.setDefinition((AttributeDefinitionEnumeration)attributeDefinition);
            AttributeValueEnumeration defaultValue = ((AttributeDefinitionEnumeration)attributeDefinition).getDefaultValue();
            if (defaultValue != null) {
                value.getValues().addAll((Collection)defaultValue.getValues());
            }
            return value;
        }
        throw new IllegalArgumentException("Type not supported: " + attributeDefinition);
    }

    public static Command createCreateSpecRelationsCommand(EditingDomain domain, Collection<?> sources, Object target) {
        SpecObject targetObject = null;
        if (target instanceof SpecObject) {
            targetObject = (SpecObject)target;
        } else if (target instanceof SpecHierarchy) {
            targetObject = ((SpecHierarchy)target).getObject();
        }
        if (targetObject == null) {
            return UnexecutableCommand.INSTANCE;
        }
        ReqIFContent content = ReqIF10Util.getReqIF((Object)targetObject).getCoreContent();
        ArrayList<SpecRelation> relations = new ArrayList<SpecRelation>();
        for (Object source : sources) {
            if (source instanceof SpecHierarchy) {
                source = ((SpecHierarchy)source).getObject();
            }
            if (!(source instanceof SpecObject)) continue;
            SpecObject sourceObject = (SpecObject)source;
            SpecRelation relation = ReqIF10Factory.eINSTANCE.createSpecRelation();
            relation.setSource(sourceObject);
            relation.setTarget(targetObject);
            relations.add(relation);
        }
        return AddCommand.create((EditingDomain)domain, (Object)content, (Object)ReqIF10Package.Literals.REQ_IF_CONTENT__SPEC_RELATIONS, relations);
    }

    public static String substractPrefixPostfix(Object obj, String prefix, String suffix) {
        String className;
        if (obj == null) {
            return "";
        }
        String string = className = obj instanceof Class ? ((Class)obj).getSimpleName() : obj.getClass().getSimpleName();
        if (!className.startsWith(suffix) && !className.endsWith(suffix)) {
            return className;
        }
        String name = className.substring(prefix.length(), className.length() - suffix.length());
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (i != 0 && Character.isUpperCase(c)) {
                sb.append(' ');
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public static void updateValuesForCurrentType(SpecObject specObject) {
        HashSet existingRequiredValues = new HashSet(specObject.getValues());
        if (specObject.getType() != null) {
            block0: for (AttributeDefinition attrDefFromNewType : specObject.getType().getSpecAttributes()) {
                AttributeValue value2;
                for (AttributeValue value2 : specObject.getValues()) {
                    AttributeDefinition definition = ReqIF10Util.getAttributeDefinition((AttributeValue)value2);
                    if (definition == null || !definition.equals(attrDefFromNewType)) continue;
                    existingRequiredValues.remove(value2);
                    continue block0;
                }
                value2 = ProrUtil.createAttributeValue(attrDefFromNewType);
                if (value2 != null) {
                    specObject.getValues().add((Object)value2);
                    if (((EObjectImpl)specObject).eNotificationRequired()) {
                        specObject.eNotify((Notification)new ENotificationImpl((InternalEObject)((EObjectImpl)specObject), 3, null, null, (Object)value2));
                    }
                }
                for (AttributeValue attributeValue : existingRequiredValues) {
                    specObject.getValues().remove((Object)attributeValue);
                }
            }
        }
    }

    public static boolean isValidDrop(SpecHierarchy source, Object target) {
        if (source == target) {
            return false;
        }
        if (source.getChildren().contains(target)) {
            return false;
        }
        for (EObject child : source.getChildren()) {
            if (!(child instanceof SpecHierarchy) || ProrUtil.isValidDrop((SpecHierarchy)child, target)) continue;
            return false;
        }
        return true;
    }

    public static ProrPresentationConfigurationItemProvider getConfigItemProvider(ProrPresentationConfiguration config, AdapterFactory adapterFactory) {
        ProrPresentationConfigurationItemProvider itemprovider = (ProrPresentationConfigurationItemProvider)ProrUtil.getItemProvider(adapterFactory, config);
        return itemprovider;
    }
}

