/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.pror.reqif10.editor.actions;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.rmf.pror.reqif10.configuration.Column;
import org.eclipse.rmf.pror.reqif10.configuration.ConfigurationFactory;
import org.eclipse.rmf.pror.reqif10.configuration.ConfigurationPackage;
import org.eclipse.rmf.pror.reqif10.configuration.ProrSpecViewConfiguration;
import org.eclipse.rmf.pror.reqif10.configuration.ProrToolExtension;
import org.eclipse.rmf.pror.reqif10.editor.actions.SubtreeDialog;
import org.eclipse.rmf.pror.reqif10.editor.presentation.ReqifSpecificationEditorInput;
import org.eclipse.rmf.pror.reqif10.editor.presentation.SpecificationEditor;
import org.eclipse.rmf.pror.reqif10.util.ConfigurationUtil;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.Specification;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ColumnConfigurationActionDelegate
implements IEditorActionDelegate {
    private SpecificationEditor editor;

    public void setActiveEditor(IAction action, IEditorPart editor) {
        this.editor = editor instanceof SpecificationEditor ? (SpecificationEditor)editor : null;
    }

    public void run(IAction action) {
        if (this.editor == null) {
            return;
        }
        ReqIF reqif = (ReqIF)((Resource)this.editor.getEditingDomain().getResourceSet().getResources().get(0)).getContents().get(0);
        IEditorInput input = this.editor.getEditorInput();
        if (input instanceof ReqifSpecificationEditorInput) {
            ProrSpecViewConfiguration config2;
            Specification spec = ((ReqifSpecificationEditorInput)input).getSpec();
            ProrToolExtension toolConfig = ConfigurationUtil.createProrToolExtension((ReqIF)reqif, (EditingDomain)this.editor.getEditingDomain());
            EList configs = toolConfig.getSpecViewConfigurations();
            for (ProrSpecViewConfiguration config2 : configs) {
                if (!spec.equals(config2.getSpecification())) continue;
                this.launchColumnDialog(config2);
                return;
            }
            config2 = ConfigurationFactory.eINSTANCE.createProrSpecViewConfiguration();
            config2.setSpecification(spec);
            toolConfig.getSpecViewConfigurations().add((Object)config2);
            this.launchColumnDialog(config2);
        }
    }

    private void launchColumnDialog(ProrSpecViewConfiguration config) {
        SubtreeDialog dialog = new SubtreeDialog(this.editor.getReqifEditor(), (EObject)config, "Configure columns for " + ConfigurationUtil.getSpecElementLabel((SpecElementWithAttributes)config.getSpecification(), (AdapterFactory)this.editor.getAdapterFactory()), "org.eclipse.rmf.pror.reqif10.editor.columnConfiguration");
        dialog.setActions(new IAction[]{this.buildAddColumnAction(config)}, false);
        dialog.open();
    }

    private IAction buildAddColumnAction(final ProrSpecViewConfiguration config) {
        Action addColumnAction = new Action("Add Column"){

            public void run() {
                CompoundCommand compoundCmd = new CompoundCommand("Add Column");
                int shrink = 0;
                if (config.getColumns().size() > 0) {
                    shrink = 100 / config.getColumns().size();
                }
                for (Column column : config.getColumns()) {
                    int newWidth = column.getWidth() - shrink;
                    if (newWidth < 20) {
                        newWidth = 100;
                    }
                    Command command = SetCommand.create((EditingDomain)ColumnConfigurationActionDelegate.this.editor.getEditingDomain(), (Object)column, (Object)ConfigurationPackage.Literals.COLUMN__WIDTH, (Object)newWidth);
                    compoundCmd.append(command);
                }
                Command command = AddCommand.create((EditingDomain)ColumnConfigurationActionDelegate.this.editor.getEditingDomain(), (Object)config, (Object)ConfigurationPackage.Literals.PROR_SPEC_VIEW_CONFIGURATION__COLUMNS, (Object)ConfigurationFactory.eINSTANCE.createColumn());
                compoundCmd.append(command);
                ColumnConfigurationActionDelegate.this.editor.getEditingDomain().getCommandStack().execute((Command)compoundCmd);
            }
        };
        ImageDescriptor imgDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.rmf.pror.reqif10.editor.editor", (String)"icons/full/obj16/AddColumn.png");
        addColumnAction.setImageDescriptor(imgDescriptor);
        return addColumnAction;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

