/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.pror.reqif10.editor.actions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.rmf.pror.reqif10.configuration.ConfigurationFactory;
import org.eclipse.rmf.pror.reqif10.configuration.ConfigurationPackage;
import org.eclipse.rmf.pror.reqif10.configuration.LabelConfiguration;
import org.eclipse.rmf.pror.reqif10.configuration.ProrGeneralConfiguration;
import org.eclipse.rmf.pror.reqif10.configuration.ProrToolExtension;
import org.eclipse.rmf.pror.reqif10.editor.actions.SubtreeDialog;
import org.eclipse.rmf.pror.reqif10.editor.presentation.Reqif10Editor;
import org.eclipse.rmf.pror.reqif10.editor.presentation.SpecificationEditor;
import org.eclipse.rmf.pror.reqif10.util.ConfigurationUtil;
import org.eclipse.rmf.reqif10.ReqIF;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;

public class GeneralConfigurationActionDelegate
implements IEditorActionDelegate {
    private Reqif10Editor editor;

    public void setActiveEditor(IAction action, IEditorPart editor) {
        this.editor = editor instanceof Reqif10Editor ? (Reqif10Editor)editor : (editor instanceof SpecificationEditor ? ((SpecificationEditor)editor).getReqifEditor() : null);
    }

    public void run(IAction action) {
        if (this.editor == null) {
            return;
        }
        ProrToolExtension uiToolExtension = ConfigurationUtil.createProrToolExtension((ReqIF)this.editor.getReqif(), (EditingDomain)this.editor.getEditingDomain());
        ProrGeneralConfiguration generalConfig = this.createGeneralConfiguration(uiToolExtension);
        this.createLabelConfiguration(generalConfig);
        SubtreeDialog dialog = new SubtreeDialog(this.editor, (EObject)generalConfig, "General Configuration", "org.eclipse.rmf.pror.reqif10.editor.generalConfiguration");
        dialog.open();
    }

    private void createLabelConfiguration(ProrGeneralConfiguration generalConfig) {
        if (generalConfig.getLabelConfiguration() != null) {
            return;
        }
        LabelConfiguration labelConfig = ConfigurationFactory.eINSTANCE.createLabelConfiguration();
        this.editor.getEditingDomain().getCommandStack().execute(SetCommand.create((EditingDomain)this.editor.getEditingDomain(), (Object)generalConfig, (Object)ConfigurationPackage.Literals.PROR_GENERAL_CONFIGURATION__LABEL_CONFIGURATION, (Object)labelConfig));
    }

    private ProrGeneralConfiguration createGeneralConfiguration(ProrToolExtension uiToolExtension) {
        if (uiToolExtension.getGeneralConfiguration() != null) {
            return uiToolExtension.getGeneralConfiguration();
        }
        ProrGeneralConfiguration generalConfig = ConfigurationFactory.eINSTANCE.createProrGeneralConfiguration();
        this.editor.getEditingDomain().getCommandStack().execute(SetCommand.create((EditingDomain)this.editor.getEditingDomain(), (Object)uiToolExtension, (Object)2, (Object)generalConfig));
        return generalConfig;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

