/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.pror.reqif10.editor.agilegrid;

import java.math.BigInteger;
import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.CellEditor;
import org.agilemore.agilegrid.DefaultCellEditorProvider;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.rmf.pror.reqif10.editor.agilegrid.ProrCheckboxCellEditor;
import org.eclipse.rmf.pror.reqif10.editor.agilegrid.ProrDateCellEditor;
import org.eclipse.rmf.pror.reqif10.editor.agilegrid.ProrEnumerationMultiValueCellEditor;
import org.eclipse.rmf.pror.reqif10.editor.agilegrid.ProrEnumerationSingleValueCellEditor;
import org.eclipse.rmf.pror.reqif10.editor.agilegrid.ProrIntegerCellEditor;
import org.eclipse.rmf.pror.reqif10.editor.agilegrid.ProrRealCellEditor;
import org.eclipse.rmf.pror.reqif10.editor.agilegrid.ProrStringCellEditor;
import org.eclipse.rmf.pror.reqif10.editor.agilegrid.ProrXhtmlSimplifiedCellEditor;
import org.eclipse.rmf.reqif10.AttributeDefinitionEnumeration;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.DatatypeDefinition;
import org.eclipse.rmf.reqif10.DatatypeDefinitionBoolean;
import org.eclipse.rmf.reqif10.DatatypeDefinitionDate;
import org.eclipse.rmf.reqif10.DatatypeDefinitionEnumeration;
import org.eclipse.rmf.reqif10.DatatypeDefinitionInteger;
import org.eclipse.rmf.reqif10.DatatypeDefinitionReal;
import org.eclipse.rmf.reqif10.DatatypeDefinitionString;
import org.eclipse.rmf.reqif10.DatatypeDefinitionXHTML;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;

public abstract class AbstractProrCellEditorProvider
extends DefaultCellEditorProvider {
    protected final EditingDomain editingDomain;
    protected final AdapterFactory adapterFactory;

    public AbstractProrCellEditorProvider(AgileGrid agileGrid, AdapterFactory adapterFactory, EditingDomain editingDomain) {
        super(agileGrid);
        this.editingDomain = editingDomain;
        this.adapterFactory = adapterFactory;
    }

    protected CellEditor getDefaultCellEditor(AttributeValue value, Object affectedObject) {
        DatatypeDefinition dd = ReqIF10Util.getDatatypeDefinition((AttributeValue)value);
        if (dd == null) {
            MessageDialog.openInformation(null, (String)"No DatatypeDefinition set", (String)"This attribute cannot be edited, as no Datatype Definition has been set.");
            return null;
        }
        if (dd instanceof DatatypeDefinitionBoolean) {
            return new ProrCheckboxCellEditor(this.agileGrid, this.editingDomain);
        }
        if (dd instanceof DatatypeDefinitionDate) {
            return new ProrDateCellEditor(this.agileGrid, this.editingDomain, affectedObject);
        }
        if (dd instanceof DatatypeDefinitionInteger) {
            DatatypeDefinitionInteger ddi = (DatatypeDefinitionInteger)dd;
            ProrIntegerCellEditor integerCellEditor = new ProrIntegerCellEditor(this.agileGrid, this.editingDomain, affectedObject);
            integerCellEditor.setRange(ddi.getMin(), ddi.getMax());
            return integerCellEditor;
        }
        if (dd instanceof DatatypeDefinitionReal) {
            DatatypeDefinitionReal ddr = (DatatypeDefinitionReal)dd;
            ProrRealCellEditor realCellEditor = new ProrRealCellEditor(this.agileGrid, this.editingDomain, affectedObject);
            realCellEditor.setRange(ddr.getMin(), ddr.getMax());
            return realCellEditor;
        }
        if (dd instanceof DatatypeDefinitionString) {
            DatatypeDefinitionString dds = (DatatypeDefinitionString)dd;
            ProrStringCellEditor stringCellEditor = new ProrStringCellEditor(this.agileGrid, this.editingDomain, affectedObject);
            stringCellEditor.setMaxLength(dds.getMaxLength() != null ? dds.getMaxLength() : new BigInteger("2147483647"));
            return stringCellEditor;
        }
        if (dd instanceof DatatypeDefinitionEnumeration) {
            DatatypeDefinitionEnumeration dde = (DatatypeDefinitionEnumeration)dd;
            Boolean multiValued = ((AttributeDefinitionEnumeration)ReqIF10Util.getAttributeDefinition((AttributeValue)value)).isMultiValued();
            if (multiValued == null || !multiValued.booleanValue()) {
                return new ProrEnumerationSingleValueCellEditor(this.agileGrid, dde, this.editingDomain, this.adapterFactory);
            }
            return new ProrEnumerationMultiValueCellEditor(this.agileGrid, dde, this.editingDomain, this.adapterFactory);
        }
        if (dd instanceof DatatypeDefinitionXHTML) {
            ProrXhtmlSimplifiedCellEditor stringCellEditor = new ProrXhtmlSimplifiedCellEditor(this.agileGrid, this.editingDomain, affectedObject);
            return stringCellEditor;
        }
        throw new IllegalArgumentException("No editor for: " + value);
    }

    protected abstract AttributeValue getAttributeValue(int var1, int var2);

    protected abstract Object getAffectedElement(int var1, int var2);
}

