/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.pror.reqif10.editor.agilegrid;

import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.CellEditor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.rmf.pror.reqif10.configuration.ProrPresentationConfiguration;
import org.eclipse.rmf.pror.reqif10.editor.agilegrid.AbstractProrCellEditorProvider;
import org.eclipse.rmf.pror.reqif10.editor.agilegrid.AgileCellEditorActionHandler;
import org.eclipse.rmf.pror.reqif10.editor.agilegrid.ProrAgileGridContentProvider;
import org.eclipse.rmf.pror.reqif10.editor.presentation.service.PresentationEditorInterface;
import org.eclipse.rmf.pror.reqif10.util.ConfigurationUtil;
import org.eclipse.rmf.pror.reqif10.util.ProrUtil;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.Identifiable;

public class ProrCellEditorProvider
extends AbstractProrCellEditorProvider {
    private final ProrAgileGridContentProvider contentProvider;
    private final AgileCellEditorActionHandler agileCellEditorActionHandler;

    public ProrCellEditorProvider(AgileGrid agileGrid, EditingDomain editingDomain, AdapterFactory adapterFactory, AgileCellEditorActionHandler agileCellEditorActionHandler) {
        super(agileGrid, adapterFactory, editingDomain);
        this.contentProvider = (ProrAgileGridContentProvider)agileGrid.getContentProvider();
        this.agileCellEditorActionHandler = agileCellEditorActionHandler;
    }

    protected AttributeValue getAttributeValue(int row, int col) {
        return this.contentProvider.getValueForColumn(this.contentProvider.getProrRow(row).getSpecElement(), col);
    }

    public Identifiable getAffectedElement(int row, int col) {
        ProrAgileGridContentProvider provider = (ProrAgileGridContentProvider)this.getAgileGrid().getContentProvider();
        return provider.getProrRow(row).getSpecElement();
    }

    public CellEditor getCellEditor(int row, int col, Object hint) {
        ItemProviderAdapter ip;
        CellEditor cellEditor = null;
        AttributeValue av = this.getAttributeValue(row, col);
        ProrPresentationConfiguration config = ConfigurationUtil.getPresentationConfiguration((AttributeValue)av);
        if (config != null && (ip = ProrUtil.getItemProvider((AdapterFactory)this.adapterFactory, (Object)config)) instanceof PresentationEditorInterface) {
            cellEditor = ((PresentationEditorInterface)ip).getCellEditor(this.agileGrid, this.editingDomain, av, this.getAffectedElement(row, col));
        }
        if (cellEditor == null) {
            cellEditor = this.getDefaultCellEditor(av, this.getAffectedElement(row, col));
        }
        if (cellEditor != null) {
            this.agileCellEditorActionHandler.setActiveCellEditor(cellEditor);
        }
        return cellEditor;
    }

    public boolean canEdit(int row, int col) {
        ItemProviderAdapter ip;
        AttributeValue attrValue = this.getAttributeValue(row, col);
        if (attrValue == null) {
            return false;
        }
        ProrPresentationConfiguration config = ConfigurationUtil.getPresentationConfiguration((AttributeValue)attrValue);
        if (config != null && (ip = ProrUtil.getItemProvider((AdapterFactory)this.adapterFactory, (Object)config)) instanceof PresentationEditorInterface) {
            return ((PresentationEditorInterface)ip).canEdit();
        }
        return true;
    }
}

