/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.pror.reqif10.editor.agilegrid;

import org.agilemore.agilegrid.AgileGrid;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.rmf.pror.reqif10.configuration.ProrPresentationConfiguration;
import org.eclipse.rmf.pror.reqif10.editor.agilegrid.AbstractProrCellRenderer;
import org.eclipse.rmf.pror.reqif10.editor.agilegrid.ProrAgileGridContentProvider;
import org.eclipse.rmf.pror.reqif10.editor.agilegrid.ProrLayoutAdvisor;
import org.eclipse.rmf.pror.reqif10.editor.agilegrid.ProrRow;
import org.eclipse.rmf.pror.reqif10.editor.presentation.service.IProrCellRenderer;
import org.eclipse.rmf.pror.reqif10.editor.presentation.service.PresentationEditorInterface;
import org.eclipse.rmf.pror.reqif10.provider.Reqif10EditPlugin;
import org.eclipse.rmf.pror.reqif10.util.ConfigurationUtil;
import org.eclipse.rmf.pror.reqif10.util.ProrUtil;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.SpecObject;
import org.eclipse.rmf.reqif10.SpecRelation;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class ProrCellRenderer
extends AbstractProrCellRenderer {
    private final Image specHierarchyIcon;
    private final Image specObjectIcon;
    private final Image specRelationIcon;
    private EditingDomain editingDomain;

    public ProrCellRenderer(AgileGrid agileGrid, AdapterFactory adapterFactory, EditingDomain editingDomain) {
        super(agileGrid, adapterFactory);
        this.editingDomain = editingDomain;
        this.specObjectIcon = ExtendedImageRegistry.getInstance().getImage(Reqif10EditPlugin.INSTANCE.getImage("full/obj16/SpecObject.png"));
        this.specHierarchyIcon = ExtendedImageRegistry.getInstance().getImage(Reqif10EditPlugin.INSTANCE.getImage("full/obj16/SpecHierarchy.png"));
        this.specRelationIcon = ExtendedImageRegistry.getInstance().getImage(Reqif10EditPlugin.INSTANCE.getImage("full/obj16/SpecRelation.png"));
    }

    protected void doDrawCellContent(GC gc, Rectangle rect, int row, int col) {
        ItemProviderAdapter ip;
        ProrAgileGridContentProvider contentProvider = (ProrAgileGridContentProvider)this.agileGrid.getContentProvider();
        Object content = contentProvider.getContentAt(row, col);
        if (col == 0) {
            rect = this.doIndenting(gc, rect, row);
        }
        IProrCellRenderer renderer = null;
        AttributeValue attrValue = contentProvider.getValueForColumn(contentProvider.getProrRow(row).getSpecElement(), col);
        ProrPresentationConfiguration config = ConfigurationUtil.getPresentationConfiguration((AttributeValue)attrValue);
        if (config != null && (ip = ProrUtil.getItemProvider((AdapterFactory)this.adapterFactory, (Object)config)) instanceof PresentationEditorInterface) {
            renderer = ((PresentationEditorInterface)ip).getCellRenderer(attrValue);
        }
        int rowHeight = renderer != null ? renderer.doDrawCellContent(gc, rect, content) : this.doDrawCellContentDefault(gc, rect, content);
        this.updateCellHeight(row, col, rowHeight);
    }

    private Rectangle doIndenting(GC gc, Rectangle rect, int row) {
        ProrAgileGridContentProvider contentProvider = (ProrAgileGridContentProvider)this.agileGrid.getContentProvider();
        ProrRow prorRow = contentProvider.getProrRow(row);
        int offset = prorRow.getLevel() * 20;
        Image icon = prorRow.getSpecElement() instanceof SpecObject ? this.specObjectIcon : (prorRow.getSpecElement() instanceof SpecRelation ? this.specRelationIcon : this.specHierarchyIcon);
        gc.drawImage(icon, rect.x + offset + 1, rect.y + (rect.height - 16) / 2);
        rect = new Rectangle(rect.x + offset + 18, rect.y, rect.width - offset - 18, rect.height);
        return rect;
    }

    private void updateCellHeight(int row, int col, int height) {
        if (this.agileGrid.getLayoutAdvisor() instanceof ProrLayoutAdvisor) {
            ((ProrLayoutAdvisor)this.agileGrid.getLayoutAdvisor()).setCellHeight(row, col, height + 2);
        }
    }
}

