/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.pror.reqif10.editor.agilegrid;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.ICellEditorValidator;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.rmf.pror.reqif10.editor.agilegrid.ProrCellEditor;
import org.eclipse.rmf.pror.reqif10.util.ProrUtil;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;

public class ProrDateCellEditor
extends ProrCellEditor {
    public ProrDateCellEditor(AgileGrid agileGrid, EditingDomain editingDomain, Object affectedObject) {
        super(agileGrid, editingDomain, affectedObject);
        this.setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                if (value == null) {
                    return null;
                }
                try {
                    ProrDateCellEditor.this.stingToCalendar(value.toString());
                }
                catch (ParseException parseException) {
                    return "Required Format: " + DateFormat.getDateInstance().format(new Date());
                }
                catch (DatatypeConfigurationException e) {
                    return "Parsing Problem: " + e.toString();
                }
                return null;
            }
        });
    }

    protected Object doGetValue() {
        try {
            XMLGregorianCalendar value = this.stingToCalendar(this.text.getText());
            ProrUtil.setTheValue((AttributeValue)this.attributeValue, (Object)value, (Object)this.affectedObject, (EditingDomain)this.editingDomain);
        }
        catch (ParseException e) {
            e.toString();
        }
        catch (DatatypeConfigurationException e) {
            e.toString();
        }
        return this.attributeValue;
    }

    protected void doSetValue(Object value) {
        if (value instanceof AttributeValue) {
            this.attributeValue = (AttributeValue)value;
            Object cal = ReqIF10Util.getTheValue((AttributeValue)this.attributeValue);
            if (cal instanceof XMLGregorianCalendar) {
                this.text.setText(DateFormat.getDateInstance().format(((XMLGregorianCalendar)cal).toGregorianCalendar().getTime()));
            }
        }
    }

    private XMLGregorianCalendar stingToCalendar(String value) throws ParseException, DatatypeConfigurationException {
        Date date = DateFormat.getDateInstance().parse(value.toString());
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return DatatypeFactory.newInstance().newXMLGregorianCalendar(cal);
    }
}

