/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.pror.reqif10.editor.agilegrid;

import java.util.ArrayList;
import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.editors.PopupCellEditor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.rmf.reqif10.AttributeValueEnumeration;
import org.eclipse.rmf.reqif10.DatatypeDefinitionEnumeration;
import org.eclipse.rmf.reqif10.EnumValue;
import org.eclipse.rmf.reqif10.ReqIF10Package;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class ProrEnumerationMultiValueCellEditor
extends PopupCellEditor {
    private final AdapterFactory adapterFactory;
    private ArrayList<EnumValue> itemList;
    private final DatatypeDefinitionEnumeration dde;
    private List list;
    private Shell shell;
    private AttributeValueEnumeration attributeValue;
    private final EditingDomain editingDomain;

    public ProrEnumerationMultiValueCellEditor(AgileGrid agileGrid, DatatypeDefinitionEnumeration dde, EditingDomain editingDomain, AdapterFactory adapterFactory) {
        super(agileGrid);
        this.dde = dde;
        this.editingDomain = editingDomain;
        this.adapterFactory = adapterFactory;
        this.populateItemList(dde);
    }

    protected Control createContents(Composite parent) {
        String[] items;
        this.list = new List(parent, 2);
        String[] stringArray = items = this.populateItemList(this.dde);
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            this.list.add(item);
            ++n2;
        }
        for (EnumValue value : this.attributeValue.getValues()) {
            int index = this.itemList.indexOf(value);
            if (index == -1) continue;
            this.list.select(index);
        }
        return this.list;
    }

    private String[] populateItemList(DatatypeDefinitionEnumeration dde) {
        this.itemList = new ArrayList();
        String[] list = new String[dde.getSpecifiedValues().size()];
        int i = 0;
        while (i < dde.getSpecifiedValues().size()) {
            EnumValue enumValue = (EnumValue)dde.getSpecifiedValues().get(i);
            this.itemList.add(enumValue);
            IItemLabelProvider itemProvider = (IItemLabelProvider)this.adapterFactory.adapt((Notifier)enumValue, IItemLabelProvider.class);
            list[i] = itemProvider.getText((Object)enumValue);
            ++i;
        }
        return list;
    }

    protected Object doGetValue() {
        ArrayList current = new ArrayList(this.attributeValue.getValues());
        CompoundCommand cmd = new CompoundCommand("Updating Enumeration");
        int[] nArray = this.list.getSelectionIndices();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            EnumValue item = this.itemList.get(index);
            if (current.contains(item)) {
                current.remove(item);
            } else {
                cmd.append(AddCommand.create((EditingDomain)this.editingDomain, (Object)this.attributeValue, (Object)ReqIF10Package.Literals.ATTRIBUTE_VALUE_ENUMERATION__VALUES, (Object)item));
            }
            ++n2;
        }
        for (EnumValue item : current) {
            cmd.append(RemoveCommand.create((EditingDomain)this.editingDomain, (Object)this.attributeValue, (Object)ReqIF10Package.Literals.ATTRIBUTE_VALUE_ENUMERATION__VALUES, (Object)item));
        }
        this.editingDomain.getCommandStack().execute((Command)cmd);
        return this.attributeValue;
    }

    protected void doSetValue(Object value) {
        if (value instanceof AttributeValueEnumeration) {
            this.attributeValue = (AttributeValueEnumeration)value;
        }
        super.doSetValue(value);
    }

    protected void openPopupBox(Control parent) {
        super.openPopupBox(parent);
        Display display = Display.getCurrent();
        Shell shell = display.getActiveShell();
        shell.pack();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void deactivate() {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.dispose();
        }
        super.deactivate();
    }
}

