/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.pror.reqif10.editor.agilegrid;

import java.util.HashMap;
import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.DefaultLayoutAdvisor;
import org.eclipse.rmf.pror.reqif10.editor.agilegrid.ProrAgileGridContentProvider;
import org.eclipse.rmf.pror.reqif10.editor.agilegrid.ProrRow;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.Specification;

public class ProrLayoutAdvisor
extends DefaultLayoutAdvisor {
    private final HashMap<Integer, String> topHeaderLabel = new HashMap();
    private int columnCount;
    private int rowCount;
    private final HashMap<Integer, HashMap<Integer, Integer>> cachedCellHeights = new HashMap();

    public ProrLayoutAdvisor(AgileGrid agileGrid) {
        super(agileGrid);
    }

    public String getTopHeaderLabel(int col) {
        String label = col == this.columnCount - 1 ? "Link" : this.topHeaderLabel.get(col);
        return label != null ? label : "Column " + (col + 1);
    }

    protected void doSetTopHeaderLabel(int col, String label) {
        this.topHeaderLabel.put(col, label);
    }

    protected void doSetColumnCount(int columnCount) {
        this.columnCount = columnCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    protected void doSetRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    void setCellHeight(int row, int col, int height) {
        int oldRowHeight = this.getRowHeight(row);
        HashMap<Integer, Integer> cols = this.cachedCellHeights.get(row);
        if (cols == null) {
            cols = new HashMap();
            this.cachedCellHeights.put(row, cols);
        }
        cols.put(col, height);
        int newRowHeight = this.getRowHeight(row);
        if (oldRowHeight != newRowHeight) {
            super.setRowHeight(row, newRowHeight);
            this.agileGrid.redraw();
        }
    }

    public int getRowHeight(int row) {
        int height = 18;
        if (this.cachedCellHeights.get(row) == null) {
            return height;
        }
        HashMap<Integer, Integer> cols = this.cachedCellHeights.get(row);
        if (cols == null) {
            return height;
        }
        for (Integer h : cols.values()) {
            if (h <= height) continue;
            height = h;
        }
        return height;
    }

    public String getLeftHeaderLabel(int row) {
        int level;
        SpecHierarchy parent;
        StringBuffer sb = new StringBuffer();
        ProrRow prorRow = ((ProrAgileGridContentProvider)this.agileGrid.getContentProvider()).getProrRow(row);
        if (!(prorRow instanceof ProrRow.ProrRowSpecHierarchy)) {
            return "";
        }
        SpecHierarchy specHierarchy = ((ProrRow.ProrRowSpecHierarchy)prorRow).getSpecHierarchy();
        while (specHierarchy.eContainer() instanceof SpecHierarchy) {
            parent = (SpecHierarchy)specHierarchy.eContainer();
            level = parent.getChildren().indexOf((Object)specHierarchy) + 1;
            sb.insert(0, level);
            sb.insert(0, ".");
            specHierarchy = parent;
        }
        if (specHierarchy.eContainer() instanceof Specification) {
            parent = (Specification)specHierarchy.eContainer();
            level = parent.getChildren().indexOf((Object)specHierarchy) + 1;
            sb.insert(0, level);
        }
        return sb.toString();
    }
}

