/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.pror.reqif10.editor.agilegrid;

import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.ICellEditorValidator;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.rmf.pror.reqif10.editor.agilegrid.ProrCellEditor;
import org.eclipse.rmf.pror.reqif10.util.ProrUtil;
import org.eclipse.rmf.reqif10.AttributeValue;

public class ProrRealCellEditor
extends ProrCellEditor {
    private double min = Double.MIN_VALUE;
    private double max = Double.MAX_VALUE;

    public ProrRealCellEditor(AgileGrid agileGrid, EditingDomain editingDomain, Object affectedObject) {
        super(agileGrid, editingDomain, affectedObject);
        this.setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                if (!(value instanceof String)) {
                    return null;
                }
                try {
                    double num = Double.parseDouble(value.toString());
                    if (num < ProrRealCellEditor.this.min || num > ProrRealCellEditor.this.max) {
                        return "Value must be in [" + ProrRealCellEditor.this.min + ".." + ProrRealCellEditor.this.max + "]";
                    }
                }
                catch (NumberFormatException e) {
                    return e.getLocalizedMessage();
                }
                return null;
            }
        });
    }

    protected Object doGetValue() {
        try {
            Double value = new Double(this.text.getText());
            ProrUtil.setTheValue((AttributeValue)this.attributeValue, (Object)value, (Object)this.affectedObject, (EditingDomain)this.editingDomain);
        }
        catch (NumberFormatException numberFormatException) {}
        return this.attributeValue;
    }

    public void setRange(Double min, Double max) {
        this.min = min != null ? min : Double.MIN_VALUE;
        this.max = max != null ? max : Double.MAX_VALUE;
    }
}

