/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.pror.reqif10.editor.presentation;

import java.io.File;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.rmf.pror.reqif10.editor.presentation.Reqif10EditorPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class OpenFilesOnStartup
implements IStartup {
    public void earlyStartup() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (window != null) {
                    OpenFilesOnStartup.this.processCommandLine(window);
                }
            }
        });
    }

    private void processCommandLine(IWorkbenchWindow window) {
        String[] args;
        String[] stringArray = args = Platform.getCommandLineArgs();
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (arg.toLowerCase().endsWith(".reqif")) {
                try {
                    File file = new File(arg);
                    if (!file.isAbsolute()) {
                        file = new File(System.getProperty("user.dir"), arg);
                    }
                    if (!file.exists()) {
                        System.out.println("Skipping file, does not exist: " + file);
                    }
                    System.out.println("Trying to open: " + file);
                    IFileStore store = EFS.getLocalFileSystem().getStore((IPath)new Path(file.getAbsolutePath()));
                    IDE.openEditorOnFileStore((IWorkbenchPage)window.getActivePage(), (IFileStore)store);
                }
                catch (PartInitException exception) {
                    MessageDialog.openError((Shell)window.getShell(), (String)Reqif10EditorPlugin.INSTANCE.getString("_UI_OpenEditorError_label"), (String)exception.getMessage());
                }
            } else if (arg.toLowerCase().endsWith(".reqifz")) {
                System.out.println("Not yet supported on command line: .reqifz");
            }
            ++n2;
        }
    }
}

