/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.pror.reqif10.editor.presentation.service;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.rmf.pror.reqif10.configuration.ProrPresentationConfiguration;
import org.eclipse.rmf.pror.reqif10.configuration.ProrPresentationConfigurations;
import org.eclipse.rmf.pror.reqif10.configuration.provider.ProrPresentationConfigurationsItemProvider;
import org.eclipse.rmf.pror.reqif10.edit.presentation.service.PresentationInterface;
import org.eclipse.rmf.pror.reqif10.edit.presentation.service.PresentationManager;
import org.eclipse.rmf.pror.reqif10.util.ConfigurationUtil;
import org.eclipse.rmf.pror.reqif10.util.ProrUtil;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.ReqIF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresentationServiceManager {
    public static final String PRESENTATION_EXTENSION_POINT_NAME = "org.eclipse.rmf.pror.reqif10.editor.presentation";
    private static Map<Class<? extends ProrPresentationConfiguration>, PresentationInterface> presentationServiceRegistry;

    private PresentationServiceManager() {
        throw new InstantiationError("This class is not designed to be instantiated.");
    }

    public static Map<Class<? extends ProrPresentationConfiguration>, PresentationInterface> getPresentationInterfaceMap() {
        if (presentationServiceRegistry == null) {
            IExtension[] extensions;
            HashMap<Class, PresentationInterface> tmpRegistry = new HashMap<Class, PresentationInterface>();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(PRESENTATION_EXTENSION_POINT_NAME);
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    try {
                        PresentationInterface service = (PresentationInterface)configElement.createExecutableExtension("service");
                        tmpRegistry.put(service.getConfigurationInterface(), service);
                        PresentationManager.addService((Class)service.getConfigurationInterface(), (PresentationInterface)service);
                    }
                    catch (CoreException e) {
                        MessageDialog.openError(null, (String)"Plugin Configuration Error", (String)("When initializing the installed plugins, something went wrong.  You can continue working, but Presentations may not be activated:" + e.getMessage()));
                        e.printStackTrace();
                    }
                    ++n4;
                }
                ++n2;
            }
            presentationServiceRegistry = Collections.unmodifiableMap(tmpRegistry);
        }
        return presentationServiceRegistry;
    }

    public static PresentationInterface getPresentationService(ProrPresentationConfiguration configuration) {
        for (Class<? extends ProrPresentationConfiguration> clazz : PresentationServiceManager.getPresentationInterfaceMap().keySet()) {
            if (!clazz.isInstance(configuration)) continue;
            return PresentationServiceManager.getPresentationInterfaceMap().get(clazz);
        }
        return null;
    }

    public static void notifiyOpenReqif(ReqIF reqif, AdapterFactory adapterFactory, EditingDomain editingDomain) {
        ProrPresentationConfigurations configs = ConfigurationUtil.getPresentationConfigurations((ReqIF)reqif);
        if (configs == null) {
            return;
        }
        ((ProrPresentationConfigurationsItemProvider)ProrUtil.getItemProvider((AdapterFactory)adapterFactory, (Object)configs)).setEditingDomain(editingDomain);
        for (ProrPresentationConfiguration config : configs.getPresentationConfigurations()) {
            ProrUtil.getConfigItemProvider((ProrPresentationConfiguration)config, (AdapterFactory)adapterFactory).registerPresentationConfiguration(config, editingDomain);
        }
    }

    public static void notifiyCloseReqif(ReqIF reqif, AdapterFactory adapterFactory, EditingDomain editingDomain) {
        ProrPresentationConfigurations configs = ConfigurationUtil.getPresentationConfigurations((ReqIF)reqif);
        if (configs == null) {
            return;
        }
        for (ProrPresentationConfiguration config : configs.getPresentationConfigurations()) {
            System.out.println("Unregistering: " + config);
            ProrUtil.getConfigItemProvider((ProrPresentationConfiguration)config, (AdapterFactory)adapterFactory).unregisterPresentationConfiguration(config);
        }
    }

    public static PresentationInterface getPresentationService(AttributeValue value, EditingDomain editingDomain) {
        PresentationInterface service = null;
        ProrPresentationConfiguration config = ConfigurationUtil.getPresentationConfig((AttributeValue)value);
        if (config != null) {
            service = PresentationServiceManager.getPresentationService(config);
        }
        return service;
    }
}

