/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.pror.reqif10.editor.propertiesview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.CellEditor;
import org.agilemore.agilegrid.ICellEditorValidator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.celleditor.FeatureEditorDialog;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.rmf.pror.reqif10.configuration.ProrPresentationConfiguration;
import org.eclipse.rmf.pror.reqif10.editor.agilegrid.AbstractProrCellEditorProvider;
import org.eclipse.rmf.pror.reqif10.editor.presentation.service.PresentationEditorInterface;
import org.eclipse.rmf.pror.reqif10.editor.propertiesview.EDataTypeAgileCellEditor;
import org.eclipse.rmf.pror.reqif10.editor.propertiesview.ExtendedAgileComboBoxCellEditor;
import org.eclipse.rmf.pror.reqif10.editor.propertiesview.ExtendedAgileDialogCellEditor;
import org.eclipse.rmf.pror.reqif10.editor.propertiesview.ProrPropertyContentProvider;
import org.eclipse.rmf.pror.reqif10.util.ConfigurationUtil;
import org.eclipse.rmf.pror.reqif10.util.ProrUtil;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ProrPropertyCellEditorProvider
extends AbstractProrCellEditorProvider {
    private final ProrPropertyContentProvider contentProvider;
    public static String SPEC_HIERARCHY_NAME = "Spec Hierarchy";
    public static String SPEC_OBJECT_NAME = "Spec Object";
    public static String SPEC_RELATION_NAME = "Spec Relation";

    public ProrPropertyCellEditorProvider(AgileGrid agileGrid, AdapterFactory adapterFactory, EditingDomain editingDomain, ProrPropertyContentProvider contentProvider) {
        super(agileGrid, adapterFactory, editingDomain);
        this.contentProvider = contentProvider;
    }

    protected AttributeValue getAttributeValue(int row, int col) {
        return this.contentProvider.getReqIfAttributeValue(row);
    }

    public boolean canEdit(int row, int col) {
        AttributeValue av = this.getAttributeValue(row, col);
        if (av != null) {
            ItemProviderAdapter ip;
            ProrPresentationConfiguration config = ConfigurationUtil.getPresentationConfiguration((AttributeValue)av);
            if (config != null && (ip = ProrUtil.getItemProvider((AdapterFactory)this.adapterFactory, (Object)config)) instanceof PresentationEditorInterface) {
                return ((PresentationEditorInterface)ip).canEdit();
            }
        } else {
            IItemPropertyDescriptor descriptor;
            ProrPropertyContentProvider.SortedItemPropertyDescriptor itemPropertyDescriptor = this.contentProvider.getItemPropertyDescriptor(row);
            if (itemPropertyDescriptor != null && (descriptor = itemPropertyDescriptor.getItemPropertyDescriptor()) != null) {
                return descriptor.canSetProperty(this.contentProvider.getElement());
            }
        }
        return true;
    }

    public CellEditor getCellEditor(int row, int col, Object hint) {
        AttributeValue attrValue = this.getAttributeValue(row, col);
        CellEditor cellEditor = null;
        if (attrValue != null) {
            ItemProviderAdapter ip;
            ProrPresentationConfiguration config = ConfigurationUtil.getPresentationConfiguration((AttributeValue)attrValue);
            if (config != null && (ip = ProrUtil.getItemProvider((AdapterFactory)this.adapterFactory, (Object)config)) instanceof PresentationEditorInterface) {
                cellEditor = ((PresentationEditorInterface)ip).getCellEditor(this.agileGrid, this.editingDomain, attrValue, this.getAffectedElement(row, col));
            }
            if (cellEditor == null) {
                cellEditor = this.getDefaultCellEditor(attrValue, this.getAffectedElement(row, col));
            }
        } else {
            IItemPropertyDescriptor descriptor = this.contentProvider.getItemPropertyDescriptor(row).getItemPropertyDescriptor();
            String categoryName = descriptor.getCategory(this.contentProvider.getElement());
            Object selectedElement = this.contentProvider.getElement();
            if (categoryName != null && categoryName.equals(SPEC_OBJECT_NAME) && this.contentProvider.getElement() instanceof SpecHierarchy) {
                selectedElement = ((SpecHierarchy)this.contentProvider.getElement()).getObject();
            }
            cellEditor = this.getNonAttributeCellEditor(selectedElement, descriptor);
        }
        return cellEditor;
    }

    CellEditor getNonAttributeCellEditor(final Object object, final IItemPropertyDescriptor itemPropertyDescriptor) {
        if (!itemPropertyDescriptor.canSetProperty(object)) {
            return null;
        }
        Object result = null;
        Object genericFeature = itemPropertyDescriptor.getFeature(object);
        if (genericFeature instanceof EReference[]) {
            result = null;
            result = new ExtendedAgileComboBoxCellEditor(this.agileGrid, this.editingDomain, new ArrayList(itemPropertyDescriptor.getChoiceOfValues(object)), itemPropertyDescriptor, object, itemPropertyDescriptor.isSortChoices(object));
        } else if (genericFeature instanceof EStructuralFeature) {
            EDataType eDataType;
            final EStructuralFeature feature = (EStructuralFeature)genericFeature;
            EClassifier eType = feature.getEType();
            final Collection choiceOfValues = itemPropertyDescriptor.getChoiceOfValues(object);
            if (choiceOfValues != null) {
                if (itemPropertyDescriptor.isMany(object)) {
                    boolean valid = true;
                    for (Object choice : choiceOfValues) {
                        if (eType.isInstance(choice)) continue;
                        valid = false;
                        break;
                    }
                    if (valid) {
                        final ILabelProvider editLabelProvider = ProrPropertyCellEditorProvider.getLabelProvider(itemPropertyDescriptor, object);
                        result = new ExtendedAgileDialogCellEditor(this.agileGrid, this.editingDomain, itemPropertyDescriptor, object){

                            protected Object openDialogBox(Control cellEditorWindow) {
                                FeatureEditorDialog dialog = new FeatureEditorDialog(cellEditorWindow.getShell(), editLabelProvider, object, feature.getEType(), (List)this.doGetValue(), ProrPropertyCellEditorProvider.getDisplayName(itemPropertyDescriptor, object), new ArrayList(choiceOfValues), false, itemPropertyDescriptor.isSortChoices(object), feature.isUnique());
                                super.openDialogBox(cellEditorWindow);
                                dialog.open();
                                return dialog.getResult();
                            }
                        };
                    }
                }
                if (result == null) {
                    result = new ExtendedAgileComboBoxCellEditor(this.agileGrid, this.editingDomain, new ArrayList(itemPropertyDescriptor.getChoiceOfValues(object)), itemPropertyDescriptor, object, itemPropertyDescriptor.isSortChoices(object));
                }
            } else if (eType instanceof EDataType && (eDataType = (EDataType)eType).isSerializable()) {
                if (itemPropertyDescriptor.isMany(object)) {
                    final ILabelProvider editLabelProvider = ProrPropertyCellEditorProvider.getLabelProvider(itemPropertyDescriptor, object);
                    result = new ExtendedAgileDialogCellEditor(this.agileGrid, this.editingDomain, itemPropertyDescriptor, object){

                        protected Object openDialogBox(Control cellEditorWindow) {
                            FeatureEditorDialog dialog = new FeatureEditorDialog(cellEditorWindow.getShell(), editLabelProvider, object, feature.getEType(), (List)this.doGetValue(), ProrPropertyCellEditorProvider.getDisplayName(itemPropertyDescriptor, object), null, itemPropertyDescriptor.isMultiLine(object), false, feature.isUnique());
                            super.openDialogBox(cellEditorWindow);
                            dialog.open();
                            return dialog.getResult();
                        }
                    };
                } else {
                    result = eDataType.getInstanceClass() == Boolean.class || eDataType.getInstanceClass() == Boolean.TYPE ? new ExtendedAgileComboBoxCellEditor(this.agileGrid, this.editingDomain, Arrays.asList(Boolean.FALSE, Boolean.TRUE), itemPropertyDescriptor, object, itemPropertyDescriptor.isSortChoices(object)) : (itemPropertyDescriptor.isMultiLine(object) ? new ExtendedAgileDialogCellEditor(this.agileGrid, this.editingDomain, itemPropertyDescriptor, object, eDataType){
                        protected EDataTypeValueHandler valueHandler;
                        {
                            super($anonymous0, $anonymous1, $anonymous2, $anonymous3);
                            this.valueHandler = new EDataTypeValueHandler(eDataType);
                        }

                        protected Object openDialogBox(Control cellEditorWindow) {
                            MultiLineInputDialog dialog = new MultiLineInputDialog(cellEditorWindow.getShell(), EMFEditUIPlugin.INSTANCE.getString("_UI_FeatureEditorDialog_title", new Object[]{ProrPropertyCellEditorProvider.getDisplayName(itemPropertyDescriptor, object), ProrPropertyCellEditorProvider.getLabelProvider(itemPropertyDescriptor, object).getText(object)}), EMFEditUIPlugin.INSTANCE.getString("_UI_MultiLineInputDialog_message"), this.valueHandler.toString(this.getValue()), this.valueHandler);
                            return dialog.open() == 0 ? this.valueHandler.toValue(dialog.getValue()) : null;
                        }
                    } : new EDataTypeAgileCellEditor(this.agileGrid, this.editingDomain, itemPropertyDescriptor, object, eDataType));
                }
            }
        }
        return result;
    }

    public Object getAffectedElement(int row, int col) {
        if (this.contentProvider != null) {
            return this.contentProvider.getElement();
        }
        return null;
    }

    public static ILabelProvider getLabelProvider(IItemPropertyDescriptor itemPropertyDescriptor, Object object) {
        final IItemLabelProvider itemLabelProvider = itemPropertyDescriptor.getLabelProvider(object);
        return new LabelProvider(){

            public String getText(Object object) {
                return itemLabelProvider.getText(object);
            }

            public Image getImage(Object object) {
                return ExtendedImageRegistry.getInstance().getImage(itemLabelProvider.getImage(object));
            }
        };
    }

    public static String getDisplayName(IItemPropertyDescriptor itemPropertyDescriptor, Object object) {
        return itemPropertyDescriptor.getDisplayName(object);
    }

    protected static class EDataTypeValueHandler
    implements ICellEditorValidator,
    IInputValidator {
        protected EDataType eDataType;

        public EDataTypeValueHandler(EDataType eDataType) {
            this.eDataType = eDataType;
        }

        public String isValid(Object object) {
            Object value;
            try {
                value = this.eDataType.getEPackage().getEFactoryInstance().createFromString(this.eDataType, (String)object);
            }
            catch (Exception exception) {
                String message = exception.getClass().getName();
                int index = message.lastIndexOf(46);
                if (index >= 0) {
                    message = message.substring(index + 1);
                }
                if (exception.getLocalizedMessage() != null) {
                    message = String.valueOf(message) + ": " + exception.getLocalizedMessage();
                }
                return message;
            }
            Diagnostic diagnostic = Diagnostician.INSTANCE.validate(this.eDataType, value);
            if (diagnostic.getSeverity() == 0) {
                return null;
            }
            return ((Diagnostic)diagnostic.getChildren().get(0)).getMessage().replaceAll("'", "''").replaceAll("\\{", "'{'");
        }

        public String isValid(String text) {
            return this.isValid((Object)text);
        }

        public Object toValue(String string) {
            return EcoreUtil.createFromString((EDataType)this.eDataType, (String)string);
        }

        public String toString(Object value) {
            String result = EcoreUtil.convertToString((EDataType)this.eDataType, (Object)value);
            return result == null ? "" : result;
        }
    }

    private static class MultiLineInputDialog
    extends InputDialog {
        public MultiLineInputDialog(Shell parentShell, String title, String message, String initialValue, IInputValidator validator) {
            super(parentShell, title, message, initialValue, validator);
            this.setShellStyle(this.getShellStyle() | 0x10);
        }
    }
}

