/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.pror.reqif10.editor.propertiesview;

import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.DefaultCellRendererProvider;
import org.agilemore.agilegrid.ICellRenderer;
import org.agilemore.agilegrid.SWTResourceManager;
import org.agilemore.agilegrid.renderers.TextCellRenderer;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.rmf.pror.reqif10.editor.propertiesview.ProrPropertyCellRenderer;
import org.eclipse.rmf.pror.reqif10.editor.propertiesview.ProrPropertyContentProvider;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class ProrPropertyCellRendererProvider
extends DefaultCellRendererProvider {
    private final ProrPropertyCellRenderer attributeCellRenderer;
    private final TextCellRenderer categoryCellRenderer;

    public ProrPropertyCellRendererProvider(AgileGrid agileGrid, AdapterFactory adapterFactory) {
        super(agileGrid);
        this.attributeCellRenderer = new ProrPropertyCellRenderer(agileGrid, adapterFactory);
        this.categoryCellRenderer = new TextCellRenderer(agileGrid, 1);
        this.categoryCellRenderer.setDefaultBackground(SWTResourceManager.getColor((int)22));
    }

    public ICellRenderer getCellRenderer(int row, int col) {
        ProrPropertyContentProvider contentProvider = (ProrPropertyContentProvider)this.agileGrid.getContentProvider();
        Object obj = contentProvider.getRowContent(row);
        if (col <= 1 && obj instanceof ProrPropertyContentProvider.ItemCategory) {
            return this.categoryCellRenderer;
        }
        if (col == 1 && obj instanceof ProrPropertyContentProvider.SortedItemPropertyDescriptor) {
            AttributeValue attributeValue = ((ProrPropertyContentProvider)this.agileGrid.getContentProvider()).getReqIfAttributeValue(row);
            if (attributeValue != null) {
                return this.attributeCellRenderer;
            }
            IItemLabelProvider labelProvider = contentProvider.getItemLabelProvider(row);
            if (labelProvider != null) {
                Object itemPropertyValue = contentProvider.getItemPropertyValue(row);
                final String text = labelProvider.getText(itemPropertyValue);
                final Image image = this.getImageFromObject(labelProvider.getImage(itemPropertyValue));
                return new TextCellRenderer(this.agileGrid){

                    protected void doDrawCellContent(GC gc, Rectangle rect, int row, int col) {
                        if (col == 1) {
                            if ((this.style & 0x200) != 0) {
                                this.drawVerticalTextImage(gc, rect, text, null, this.foreground, this.background);
                            } else {
                                int alignment = this.getAlignment();
                                this.drawTextImage(gc, text, alignment, image, alignment, rect.x + 3, rect.y + 2, rect.width - 6, rect.height - 4);
                            }
                        }
                    }
                };
            }
        }
        return super.getCellRenderer(row, col);
    }

    private Image getImageFromObject(Object object) {
        return ExtendedImageRegistry.getInstance().getImage(object);
    }
}

