/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.pror.reqif10.editor.propertiesview;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.agilemore.agilegrid.AbstractContentProvider;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;

public class ProrPropertyContentProvider
extends AbstractContentProvider {
    private AdapterFactoryEditingDomain editingDomain;
    private Object object;
    private HashMap<String, ItemCategory> customCategories;
    public static String SPEC_HIERARCHY_NAME = "Spec Hierarchy";
    public static String SPEC_OBJECT_NAME = "Spec Object";
    public static String SPEC_RELATION_NAME = "Spec Relation";
    private static HashSet<AdvancedProp> ADVANCED_PROPS;
    private ItemCategory specHierarchyItemCategory = new ItemCategory(SPEC_HIERARCHY_NAME);
    private ItemCategory specObjectItemCategory = new ItemCategory(SPEC_OBJECT_NAME);
    private ItemCategory specRelationItemCategory = new ItemCategory(SPEC_RELATION_NAME);
    private HashMap<Integer, Object> rows;
    private boolean showAllProps;
    public static String DEFAULT_CATEGORY_NAME;

    static {
        DEFAULT_CATEGORY_NAME = "Misc";
        ADVANCED_PROPS = new HashSet();
        ADVANCED_PROPS.add(new AdvancedProp("Specification", "identifier"));
        ADVANCED_PROPS.add(new AdvancedProp("Spec Object", "identifier"));
        ADVANCED_PROPS.add(new AdvancedProp("Spec Hierarchy", "identifier"));
        ADVANCED_PROPS.add(new AdvancedProp("Spec Relation", "identifier"));
        ADVANCED_PROPS.add(new AdvancedProp("Specification", "longName"));
        ADVANCED_PROPS.add(new AdvancedProp("Spec Object", "longName"));
        ADVANCED_PROPS.add(new AdvancedProp("Spec Hierarchy", "longName"));
        ADVANCED_PROPS.add(new AdvancedProp("Relation", "longName"));
        ADVANCED_PROPS.add(new AdvancedProp("Specification", "lastChange"));
        ADVANCED_PROPS.add(new AdvancedProp("Spec Object", "lastChange"));
        ADVANCED_PROPS.add(new AdvancedProp("Spec Hierarchy", "lastChange"));
        ADVANCED_PROPS.add(new AdvancedProp("Spec Relation", "lastChange"));
        ADVANCED_PROPS.add(new AdvancedProp("Specification", "desc"));
        ADVANCED_PROPS.add(new AdvancedProp("Spec Object", "desc"));
        ADVANCED_PROPS.add(new AdvancedProp("Spec Hierarchy", "desc"));
        ADVANCED_PROPS.add(new AdvancedProp("Spec Relation", "desc"));
        ADVANCED_PROPS.add(new AdvancedProp("Spec Hierarchy", "tableInternal"));
        ADVANCED_PROPS.add(new AdvancedProp("Spec Hierarchy", "object"));
        ADVANCED_PROPS.add(new AdvancedProp("Spec Hierarchy", "editableAtts"));
        ADVANCED_PROPS.add(new AdvancedProp("Spec Hierarchy", "editable"));
        ADVANCED_PROPS.add(new AdvancedProp(null, "desc"));
        ADVANCED_PROPS.add(new AdvancedProp(null, "identifier"));
        ADVANCED_PROPS.add(new AdvancedProp(null, "lastChange"));
        ADVANCED_PROPS.add(new AdvancedProp(null, "editable"));
    }

    public ProrPropertyContentProvider(EditingDomain editingDomain, boolean showAllProps) {
        this.editingDomain = (AdapterFactoryEditingDomain)editingDomain;
        this.customCategories = new HashMap();
        this.rows = new HashMap();
        this.showAllProps = showAllProps;
    }

    public Object doGetContentAt(int row, int col) {
        if (this.object != null) {
            int size = this.rows.size();
            if (row > size - 1 || col > 1) {
                return null;
            }
            Object element = this.rows.get(row);
            switch (col) {
                case 0: {
                    SortedItemPropertyDescriptor descriptor;
                    if (element instanceof ItemCategory) {
                        return ((ItemCategory)element).getCategoryName();
                    }
                    if (element instanceof SortedItemPropertyDescriptor && (descriptor = (SortedItemPropertyDescriptor)element).getItemPropertyDescriptor() != null) {
                        return descriptor.getItemPropertyDescriptor().getDisplayName(this.object);
                    }
                }
                case 1: {
                    if (!(element instanceof SortedItemPropertyDescriptor)) break;
                    AttributeValue atrValue = this.getReqIfAttributeValue((SortedItemPropertyDescriptor)element);
                    if (atrValue != null) {
                        return atrValue;
                    }
                    ItemPropertyDescriptor.PropertyValueWrapper wrapper = (ItemPropertyDescriptor.PropertyValueWrapper)this.getItemPropertyValue(row);
                    if (wrapper == null) break;
                    return wrapper.getEditableValue(this.object);
                }
            }
        }
        return null;
    }

    public void doSetContentAt(int row, int col, Object newValue) {
    }

    protected void setContent(Object obj) {
        this.object = obj;
        this.customCategories.clear();
        this.specHierarchyItemCategory.getDescriptors().clear();
        this.specObjectItemCategory.getDescriptors().clear();
        this.specRelationItemCategory.getDescriptors().clear();
        this.rows.clear();
        if (this.object != null) {
            IItemPropertySource itemPropertySource = (IItemPropertySource)this.editingDomain.getAdapterFactory().adapt(this.object, IItemPropertySource.class);
            List descriptorList = itemPropertySource.getPropertyDescriptors(this.object);
            for (IItemPropertyDescriptor descriptor : descriptorList) {
                ItemCategory customCategory;
                if (!this.showAllProps && !this.isStandard(descriptor)) continue;
                String categoryName = descriptor.getCategory(this.object);
                if (categoryName == null) {
                    categoryName = DEFAULT_CATEGORY_NAME;
                }
                if (categoryName.equals(SPEC_HIERARCHY_NAME)) {
                    this.specHierarchyItemCategory.addDescriptor(descriptor, this.object);
                    continue;
                }
                if (categoryName.equals(SPEC_OBJECT_NAME)) {
                    this.specObjectItemCategory.addDescriptor(descriptor, this.object);
                    continue;
                }
                if (categoryName.equals(SPEC_RELATION_NAME)) {
                    this.specRelationItemCategory.addDescriptor(descriptor, this.object);
                    continue;
                }
                if (!this.customCategories.containsKey(categoryName)) {
                    customCategory = new ItemCategory(categoryName);
                    customCategory.addDescriptor(descriptor, this.object);
                    this.customCategories.put(categoryName, customCategory);
                    continue;
                }
                customCategory = this.customCategories.get(categoryName);
                customCategory.addDescriptor(descriptor, this.object);
            }
            for (ItemCategory cat : this.customCategories.values()) {
                this.addItemCategory(cat);
            }
            this.addItemCategory(this.specObjectItemCategory);
            this.addItemCategory(this.specHierarchyItemCategory);
            this.addItemCategory(this.specRelationItemCategory);
        }
    }

    private boolean isStandard(IItemPropertyDescriptor descriptor) {
        return !ADVANCED_PROPS.contains(new AdvancedProp(descriptor.getCategory(this.object), descriptor.getId(this.object)));
    }

    private void addItemCategory(ItemCategory cat) {
        if (cat.getDescriptors().size() == 0) {
            return;
        }
        int size = this.rows.size();
        this.rows.put(size, cat);
        ++size;
        Collections.sort(cat.getDescriptors());
        for (SortedItemPropertyDescriptor des : cat.getDescriptors()) {
            this.rows.put(size, des);
            ++size;
        }
    }

    public Object getElement() {
        return this.object;
    }

    public SortedItemPropertyDescriptor getItemPropertyDescriptor(int row) {
        Object obj;
        if (this.object != null && (obj = this.rows.get(row)) instanceof SortedItemPropertyDescriptor) {
            return (SortedItemPropertyDescriptor)obj;
        }
        return null;
    }

    public IItemLabelProvider getItemLabelProvider(int row) {
        IItemPropertyDescriptor itemPropertyDescriptor = this.getItemPropertyDescriptor(row).getItemPropertyDescriptor();
        if (itemPropertyDescriptor != null) {
            return itemPropertyDescriptor.getLabelProvider(this.object);
        }
        return null;
    }

    public Object getItemPropertyValue(int row) {
        return this.getItemPropertyDescriptor(row).getItemPropertyDescriptor().getPropertyValue(this.object);
    }

    public Object getRowContent(int row) {
        return this.rows.get(row);
    }

    public AttributeValue getReqIfAttributeValue(int row) {
        Object obj = this.rows.get(row);
        if (obj instanceof SortedItemPropertyDescriptor) {
            return this.getReqIfAttributeValue((SortedItemPropertyDescriptor)obj);
        }
        return null;
    }

    private AttributeValue getReqIfAttributeValue(SortedItemPropertyDescriptor descriptor) {
        SpecElementWithAttributes sepcAtr = null;
        if (this.object instanceof SpecElementWithAttributes) {
            sepcAtr = (SpecElementWithAttributes)this.object;
        } else if (this.object instanceof SpecHierarchy) {
            sepcAtr = ((SpecHierarchy)this.object).getObject();
        }
        if (sepcAtr != null && descriptor.getItemPropertyDescriptor() != null) {
            return ReqIF10Util.getAttributeValueForLabel((SpecElementWithAttributes)sepcAtr, (String)descriptor.getItemPropertyDescriptor().getDisplayName((Object)sepcAtr));
        }
        return null;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    private static class AdvancedProp {
        private String category;
        private String name;

        AdvancedProp(String category, String name) {
            if (category == null) {
                category = DEFAULT_CATEGORY_NAME;
            }
            if (name == null) {
                throw new NullPointerException();
            }
            this.category = category;
            this.name = name;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AdvancedProp)) {
                return false;
            }
            AdvancedProp that = (AdvancedProp)obj;
            return this.category.equals(that.category) && this.name.equals(that.name);
        }

        public int hashCode() {
            return this.category.hashCode() + this.name.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ItemCategory {
        private String categoryName;
        private ArrayList<SortedItemPropertyDescriptor> descriptors;

        public ItemCategory(String categoryName) {
            this.categoryName = categoryName;
            this.descriptors = new ArrayList();
        }

        public void setCategoryName(String categoryName) {
            this.categoryName = categoryName;
        }

        public String getCategoryName() {
            return this.categoryName;
        }

        public ArrayList<SortedItemPropertyDescriptor> getDescriptors() {
            return this.descriptors;
        }

        public void addDescriptor(IItemPropertyDescriptor descriptor, Object specElement) {
            this.descriptors.add(new SortedItemPropertyDescriptor(descriptor, specElement));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SortedItemPropertyDescriptor
    implements Comparable<SortedItemPropertyDescriptor> {
        private IItemPropertyDescriptor itemPropertyDescriptor;
        private Object specElement;

        public SortedItemPropertyDescriptor(IItemPropertyDescriptor itemPropertyDescriptor, Object element) {
            this.itemPropertyDescriptor = itemPropertyDescriptor;
            this.specElement = element;
        }

        @Override
        public int compareTo(SortedItemPropertyDescriptor o) {
            return this.itemPropertyDescriptor.getDisplayName(this.specElement).compareTo(o.itemPropertyDescriptor.getDisplayName(o.specElement));
        }

        public IItemPropertyDescriptor getItemPropertyDescriptor() {
            return this.itemPropertyDescriptor;
        }

        public Object getSpecElement() {
            return this.specElement;
        }
    }
}

